/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.imagedb.input.listener;

import com.geoway.adf.dms.common.util.FileUtil;
import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.dms.datasource.service.ThumbService;
import com.geoway.imagedb.dataset.event.ImageDataAfterDeleteEvent;
import com.geoway.imagedb.input.dao.ImgAutoScanDatumDao;
import com.geoway.imagedb.input.plugin.meta.MetaPluginManager;
import java.io.File;
import java.nio.file.Path;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

@Component
public class ImageDataAfterDeleteEventListener
implements ApplicationListener<ImageDataAfterDeleteEvent> {
    private static final Logger log = LoggerFactory.getLogger(ImageDataAfterDeleteEventListener.class);
    @Resource
    private ImgAutoScanDatumDao imgAutoScanDatumDao;
    @Resource
    private ThumbService thumbService;

    public void onApplicationEvent(ImageDataAfterDeleteEvent event) {
        if (event.getDataIdList() != null && event.getDataIdList().size() > 0) {
            this.imgAutoScanDatumDao.deleteByDataIdList(event.getDataIdList());
            this.thumbService.deleteThumbByDataIds(event.getDataIdList());
        } else if (event.getDatasetId() != null) {
            this.imgAutoScanDatumDao.deleteByDatasetId(event.getDatasetId());
        }
        if (event.getSnapshotUrlList() != null && event.getSnapshotUrlList().size() > 0) {
            Path snapshotPath = MetaPluginManager.getSnapshotUnZipDir();
            String snapshotPathStr = snapshotPath.toFile().getAbsolutePath();
            for (String snapshotUrl : event.getSnapshotUrlList()) {
                File file;
                if (!StringUtil.isNotEmpty((String)snapshotUrl) || !snapshotUrl.startsWith(snapshotPathStr) || !(file = new File(snapshotUrl)).getParentFile().exists()) continue;
                try {
                    FileUtil.deleteDir((String)file.getParentFile().getAbsolutePath());
                    log.debug("\u5220\u9664\u5feb\u89c6\u56fe" + file.getParentFile().getAbsolutePath());
                }
                catch (Exception e) {
                    log.error("\u5220\u9664\u5feb\u89c6\u56fe\u5931\u8d25" + file.getParentFile().getAbsolutePath(), (Throwable)e);
                }
            }
        }
    }
}

