/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.imagedb.input.plugin.listener;

import com.alibaba.fastjson.JSONObject;
import com.geoway.adf.dms.common.web.EnvironmentConfig;
import com.geoway.adf.gis.geosrv.util.HttpClientUtil;
import com.geoway.imagedb.input.component.ImageImportScheduleTask;
import com.geoway.imagedb.input.plugin.ImageDatasetScheduleImportPlugin;
import com.geoway.imagedb.input.plugin.VectorThematicImportPlugin;
import com.geoway.imagedb.input.plugin.VectorThematicSettingParams;
import com.geoway.webstore.input.constant.TaskStatusEnum;
import com.geoway.webstore.input.dao.ImpTaskDao;
import com.geoway.webstore.input.dto.ImpSchemaDTO;
import com.geoway.webstore.input.entity.ImpTask;
import com.geoway.webstore.input.event.ImportTaskFinishedEvent;
import com.geoway.webstore.input.service.ImpTaskService;
import java.util.HashMap;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

@Component
public class ImportTaskFinishedEventListener
implements ApplicationListener<ImportTaskFinishedEvent> {
    private static final Logger log = LoggerFactory.getLogger(ImportTaskFinishedEventListener.class);
    @Resource
    private ImageImportScheduleTask imageImportScheduleTask;
    @Resource
    private ImpTaskService impTaskService;
    @Resource
    private ImpTaskDao taskDao;

    public void onApplicationEvent(ImportTaskFinishedEvent event) {
        ImpTask impTask;
        ImpSchemaDTO impSchema = event.getImpSchema();
        if (impSchema != null && impSchema.getPlugin().getClassName().equals(ImageDatasetScheduleImportPlugin.class.getName()) && this.imageImportScheduleTask.hasScheduleTask((impTask = event.getImpTask()).getId()).booleanValue()) {
            impTask.setStatus(Integer.valueOf(TaskStatusEnum.Processing.getValue()));
            this.taskDao.updateStatus(impTask);
            this.impTaskService.disableCache();
        }
        if (impSchema != null && impSchema.getPlugin().getClassName().equals(VectorThematicImportPlugin.class.getName()) && "automatic".equals((impTask = event.getImpTask()).getTaskType())) {
            VectorThematicSettingParams settingParams = (VectorThematicSettingParams)JSONObject.parseObject((String)impTask.getSettingParams(), VectorThematicSettingParams.class);
            JSONObject json = new JSONObject();
            json.put("dataPath", (Object)settingParams.originalShpPath);
            json.put("SceneType", (Object)settingParams.imageryModel);
            json.put("productTaskId", (Object)settingParams.productTaskId);
            Integer storeStatus = impTask.getStatus().intValue() == TaskStatusEnum.FinishedSuccessed.getValue() ? 1 : 0;
            json.put("ArchivState", (Object)storeStatus);
            String jsonStr = JSONObject.toJSONString((Object)json);
            String url = EnvironmentConfig.getProperty((String)"project.push-image-product-url", (String)"http://172.16.67.71:9220/rsmse-sz-seawatch-admin/");
            if (!url.endsWith("/")) {
                url = url + "/";
            }
            log.info("\u5165\u5e93\u72b6\u6001\u53cd\u9988URL\uff1a{}rs/unattended/storeCallback", (Object)url);
            log.info("\u5165\u5e93\u72b6\u6001\u53cd\u9988\u53c2\u6570\uff1a{}", (Object)jsonStr);
            String result = "";
            try {
                HashMap<String, String> header = new HashMap<String, String>(0);
                header.put("Content-Type", "application/json;charset=UTF-8");
                result = HttpClientUtil.doPostJson((String)String.format("%srs/unattended/storeCallback", url), (String)jsonStr, header, (int)30000);
            }
            catch (Exception e) {
                log.error("\u5165\u5e93\u72b6\u6001\u53cd\u9988\u5931\u8d25\uff01", (Throwable)e);
                return;
            }
            JSONObject resultJson = JSONObject.parseObject((String)result);
            if (resultJson.getInteger("code") == 200) {
                log.info("\u5165\u5e93\u72b6\u6001\u53cd\u9988\u6210\u529f\uff01");
            } else {
                log.error("\u5165\u5e93\u72b6\u6001\u53cd\u9988\u5931\u8d25\uff01{}", (Object)resultJson.getString("msg"));
            }
        }
    }
}

