/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.imagedb.input.plugin;

import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.dms.config.entity.DmFileData;
import com.geoway.adf.dms.datasource.dto.datum.DatumFieldDTO;
import com.geoway.adf.gis.basic.geometry.GeometryFunc;
import com.geoway.adf.gis.basic.geometry.IGeometry;
import com.geoway.adf.gis.basic.geometry.ISpatialReferenceSystem;
import com.geoway.adf.gis.basic.geometry.SpatialReferenceSystemFunc;
import com.geoway.adf.gis.geodb.IFeatureClass;
import com.geoway.adf.gis.geodb.IMosaicDataset;
import com.geoway.adf.gis.geodb.field.FieldType;
import com.geoway.imagedb.dataset.util.ImageDateUtil;
import com.geoway.imagedb.input.dto.meta.ImageMetaPluginDTO;
import com.geoway.imagedb.input.plugin.ImageDatasetImportPluginBase;
import com.geoway.imagedb.input.plugin.meta.IImageMetaDataPlugin;
import com.geoway.imagedb.input.plugin.meta.MetaPluginInfo;
import com.geoway.imagedb.input.plugin.meta.MetaPluginManager;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ImageDatasetImportPlugin
extends ImageDatasetImportPluginBase {
    protected IImageMetaDataPlugin imageMetaDataPlugin;

    @Override
    public void initialize(String sourceParamsStr, String targetParamsStr, String settingParamsStr) {
        super.initialize(sourceParamsStr, targetParamsStr, settingParamsStr);
        this.initMetaPlugin();
    }

    protected void initMetaPlugin() {
        if (StringUtil.isEmptyOrWhiteSpace((String)this.targetParams.metaPluginInfo)) {
            throw new RuntimeException("\u8bf7\u9009\u62e9\u5143\u6570\u636e\u89e3\u6790\u63d2\u4ef6");
        }
        try {
            MetaPluginInfo pluginInfo = this.targetParams.getImageMetaPluginInfo();
            if (StringUtil.isEmptyOrWhiteSpace((String)pluginInfo.getPluginClassName())) {
                ImageMetaPluginDTO metaPluginDTO = this.imageMetaPluginService.getDetail(pluginInfo.getConfigFile());
                this.imageMetaDataPlugin = MetaPluginManager.createImageMetaDataPlugin(metaPluginDTO);
            } else {
                this.imageMetaDataPlugin = MetaPluginManager.createImageMetaDataPlugin(this.targetParams.getImageMetaPluginInfo());
            }
        }
        catch (Exception e) {
            this.log.error("\u5143\u6570\u636e\u5165\u5e93\u63d2\u4ef6\u521d\u59cb\u5316\u5931\u8d25\uff01", (Throwable)e);
            throw new RuntimeException("\u5143\u6570\u636e\u5165\u5e93\u63d2\u4ef6\u521d\u59cb\u5316\u5931\u8d25\uff01");
        }
    }

    @Override
    protected Map<String, Object> getMetaData(DmFileData fileData) {
        HashMap<String, Object> contents = new HashMap<String, Object>(0);
        Map<String, Object> metaData = this.imageMetaDataPlugin.readMetaData(fileData, this.scanFileStorage);
        HashMap<String, String> meta = new HashMap<String, String>(0);
        metaData.forEach((key, value) -> meta.put((String)key, value == null ? "" : value.toString()));
        this.setExternalMetaValue(meta);
        this.currentDataGeometry = this.createGeometryFromMeta(meta);
        if (this.currentDataGeometry == null) {
            this.onImportDataLog("\u672a\u4ece\u5143\u6570\u636e\u89e3\u6790\u5230\u7a7a\u95f4\u8303\u56f4\uff01");
        }
        List fieldList = this.imageDataset.getFields();
        block3: for (String key2 : meta.keySet()) {
            String matchKey = key2.replace(" ", "");
            String matchValue = meta.get(key2) == null ? null : (String)meta.get(key2);
            for (DatumFieldDTO field : fieldList) {
                if (!matchKey.equalsIgnoreCase(field.getName()) && !matchKey.equalsIgnoreCase(field.getAliasName())) continue;
                FieldType type = FieldType.getByValue((Integer)field.getFieldType());
                Object value2 = null;
                if (!StringUtil.isEmptyOrWhiteSpace((String)matchValue)) {
                    switch (type) {
                        case DateTime: {
                            value2 = ImageDateUtil.parse((String)matchValue);
                            break;
                        }
                        default: {
                            value2 = matchValue;
                        }
                    }
                }
                contents.put(field.getName(), value2);
                continue block3;
            }
        }
        return contents;
    }

    @Override
    protected String getSnapshotFile(DmFileData fileData) {
        Integer targetSrid = null;
        if (this.targetGeoDataset instanceof IFeatureClass) {
            targetSrid = ((IFeatureClass)this.targetGeoDataset).getSpatialReferenceSystem().getSrid();
        } else if (this.targetGeoDataset instanceof IMosaicDataset) {
            targetSrid = ((IMosaicDataset)this.targetGeoDataset).getSpatialReferenceSystem().getSrid();
        }
        String snapshotFile = this.imageMetaDataPlugin.createSnapshotFile(fileData, this.scanFileStorage, false, targetSrid);
        if (StringUtil.isEmptyOrWhiteSpace((String)snapshotFile)) {
            this.onImportDataLog("\u65e0\u5feb\u89c6\u56fe\u6587\u4ef6\uff01");
        }
        if (this.currentDataGeometry != null && targetSrid != null) {
            ISpatialReferenceSystem sp84 = SpatialReferenceSystemFunc.createSpatialReference((int)4326);
            ISpatialReferenceSystem targetSp = SpatialReferenceSystemFunc.createSpatialReference((int)targetSrid);
            this.currentDataGeometry = this.currentDataGeometry.projectToCopy(sp84, targetSp);
        }
        return snapshotFile;
    }

    @Override
    protected Map<String, Object> getBusinessValues(Map<String, Object> meta) {
        Map<String, Object> values = super.getBusinessValues(meta);
        values.put("f_satellite", meta.get("f_satellite"));
        values.put("f_sensor", meta.get("f_sensor"));
        values.put("f_product_time", meta.get("f_product_time"));
        values.put("f_cloud", meta.get("f_cloud"));
        values.put("f_resolution", meta.get("f_resolution"));
        values.put("f_rollviewangle", meta.get("f_rollviewangle"));
        return values;
    }

    protected IGeometry createGeometryFromMeta(Map<String, String> meta) {
        try {
            double leftTopX = Double.parseDouble(meta.get("\u56fe\u50cf\u5de6\u4e0a\u89d2\u7ecf\u5ea6"));
            double leftTopY = Double.parseDouble(meta.get("\u56fe\u50cf\u5de6\u4e0a\u89d2\u7eac\u5ea6"));
            double rightTopX = Double.parseDouble(meta.get("\u56fe\u50cf\u53f3\u4e0a\u89d2\u7ecf\u5ea6"));
            double rightTopY = Double.parseDouble(meta.get("\u56fe\u50cf\u53f3\u4e0a\u89d2\u7eac\u5ea6"));
            double leftBottomX = Double.parseDouble(meta.get("\u56fe\u50cf\u5de6\u4e0b\u89d2\u7ecf\u5ea6"));
            double leftBottomY = Double.parseDouble(meta.get("\u56fe\u50cf\u5de6\u4e0b\u89d2\u7eac\u5ea6"));
            double rightBottomX = Double.parseDouble(meta.get("\u56fe\u50cf\u53f3\u4e0b\u89d2\u7ecf\u5ea6"));
            double rightBottomY = Double.parseDouble(meta.get("\u56fe\u50cf\u53f3\u4e0b\u89d2\u7eac\u5ea6"));
            return GeometryFunc.createGeometry((String)String.format("POLYGON((%s %s,%s %s,%s %s,%s %s,%s %s))", leftBottomX, leftBottomY, leftTopX, leftTopY, rightTopX, rightTopY, rightBottomX, rightBottomY, leftBottomX, leftBottomY));
        }
        catch (Exception e) {
            this.log.error("\u5143\u6570\u636e\u521b\u5efa\u51e0\u4f55\u56fe\u5f62\u5931\u8d25", (Throwable)e);
            this.onImportUnitLog(e.getMessage());
            return null;
        }
    }

    protected void setExternalMetaValue(Map<String, String> meta) {
        if (meta.containsKey("\u536b\u661f\u6807\u8bc6")) {
            meta.put("f_satellite", meta.get("\u536b\u661f\u6807\u8bc6"));
        } else if (!meta.containsKey("f_satellite")) {
            if (meta.containsKey("\u536b\u661f\u540d\u79f0")) {
                meta.put("f_satellite", meta.get("\u536b\u661f\u540d\u79f0"));
            } else {
                meta.put("f_satellite", this.settingParams.satellite);
            }
        }
        if (meta.containsKey("\u4f20\u611f\u5668\u6807\u8bc6")) {
            meta.put("f_sensor", meta.get("\u4f20\u611f\u5668\u6807\u8bc6"));
        } else if (!meta.containsKey("f_sensor")) {
            if (meta.containsKey("\u4f20\u611f\u5668")) {
                meta.put("f_sensor", meta.get("\u4f20\u611f\u5668"));
            } else {
                meta.put("f_sensor", this.settingParams.sensor);
            }
        }
        if (meta.containsKey("\u5f71\u50cf\u83b7\u53d6\u65e5\u671f")) {
            meta.put("f_product_time", meta.get("\u5f71\u50cf\u83b7\u53d6\u65e5\u671f"));
        } else if (!meta.containsKey("f_product_time")) {
            if (meta.containsKey("\u5f71\u50cf\u91c7\u96c6\u65f6\u95f4")) {
                meta.put("f_product_time", meta.get("\u5f71\u50cf\u91c7\u96c6\u65f6\u95f4"));
            } else if (!StringUtil.isEmptyOrWhiteSpace((String)this.settingParams.productTime)) {
                meta.put("f_product_time", this.settingParams.productTime);
            }
        }
        if (meta.containsKey("\u4e91\u91cf")) {
            meta.put("f_cloud", meta.get("\u4e91\u91cf"));
        } else if (!meta.containsKey("f_cloud")) {
            if (meta.containsKey("\u4e91\u91cf")) {
                meta.put("f_cloud", meta.get("\u4e91\u91cf"));
            } else if (this.settingParams.cloud != null) {
                meta.put("f_cloud", this.settingParams.cloud.toString());
            } else {
                meta.put("f_cloud", null);
            }
        }
    }
}

