/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.imagedb.input.plugin;

import com.alibaba.fastjson.JSONObject;
import com.geoway.adf.dms.common.config.UploadPathConfig;
import com.geoway.adf.dms.common.dto.TransferResult;
import com.geoway.adf.dms.common.util.FileUtil;
import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.dms.common.web.SpringContextUtil;
import com.geoway.adf.dms.datasource.dto.DatasetNameInfo;
import com.geoway.adf.dms.datasource.util.DatasetUtil;
import com.geoway.adf.gis.fs.IFileStorage;
import com.geoway.adf.gis.fs.IFileset;
import com.geoway.adf.gis.geodb.GeoDatasetType;
import com.geoway.adf.gis.geodb.IFeatureClass;
import com.geoway.adf.gis.geodb.IFeatureWorkspace;
import com.geoway.adf.gis.geodb.IGeoDataset;
import com.geoway.adf.gis.geodb.ITable;
import com.geoway.imagedb.dataset.entity.ImgThematic;
import com.geoway.imagedb.dataset.service.ImageThematicImportService;
import com.geoway.imagedb.input.plugin.VectorThematicSettingParams;
import com.geoway.imagedb.input.plugin.VectorThematicTargetParams;
import com.geoway.webstore.input.plugin.data.IImportData;
import com.geoway.webstore.input.plugin.data.IImportUnit;
import com.geoway.webstore.input.plugin.data.ImportUnit;
import com.geoway.webstore.input.plugin.data.ImportVector;
import com.geoway.webstore.input.plugin.event.ImportScanUnitEventArgs;
import com.geoway.webstore.input.plugin.model.DataDuplicateStrategyEnum;
import com.geoway.webstore.input.plugin.model.EnumVectorFormat;
import com.geoway.webstore.input.plugin.model.ExecuteResult;
import com.geoway.webstore.input.plugin.model.ExecuteResultDetail;
import com.geoway.webstore.input.plugin.vector.VectorImportPluginBase;
import com.geoway.webstore.input.plugin.vector.VectorImportScan;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class VectorThematicImportPlugin
extends VectorImportPluginBase {
    private VectorThematicSettingParams settingParams = null;
    private VectorThematicTargetParams targetParams = null;
    private IFeatureWorkspace targetWorkspace = null;
    protected ImageThematicImportService imageThematicImportService = (ImageThematicImportService)SpringContextUtil.getBean(ImageThematicImportService.class);

    public void initialize(String sourceParamsStr, String targetParamsStr, String settingParamsStr) {
        super.initialize(sourceParamsStr, targetParamsStr, settingParamsStr);
        this.targetParams = (VectorThematicTargetParams)JSONObject.parseObject((String)targetParamsStr, VectorThematicTargetParams.class);
        this.settingParams = (VectorThematicSettingParams)JSONObject.parseObject((String)settingParamsStr, VectorThematicSettingParams.class);
        if (this.targetParams == null) {
            this.targetParams = new VectorThematicTargetParams();
            if (StringUtil.isNotEmpty((String)this.settingParams.datasetId)) {
                this.targetParams.datasetId = this.settingParams.datasetId;
                this.sourceParams.setPath(this.settingParams.shpPath);
            }
            if (StringUtil.isNotEmpty((String)this.settingParams.sceneType)) {
                this.targetParams.sceneType = this.settingParams.sceneType;
            }
            if (StringUtil.isNotEmpty((String)this.settingParams.sampleScheme)) {
                this.targetParams.sampleScheme = this.settingParams.sampleScheme;
            }
        }
    }

    public void scanData() {
        DatasetNameInfo nameInfo = DatasetUtil.getDatasetNameInfo((String)this.targetParams.datasetId);
        String dataUnitName = "";
        String path = "";
        ArrayList<ImportVector> dataList = new ArrayList<ImportVector>();
        if (StringUtil.isNotEmpty((String)this.sourceParams.getPath())) {
            String sourcePath;
            IFileStorage fileStorage = this.fileStorageService.openFileStorageByFilePath(this.sourceParams.getPath());
            IFileset fileset = fileStorage.getFile(sourcePath = UploadPathConfig.getFileFullPath((String)this.sourceParams.getPath()));
            if (fileset == null) {
                throw new RuntimeException(sourcePath + " \u8def\u5f84\u4e0d\u5b58\u5728");
            }
            dataUnitName = FileUtil.getFileNameWithoutExtension((String)this.sourceParams.getPath());
            if (fileset.getIsDirectory()) {
                path = this.sourceParams.getPath();
                ArrayList<EnumVectorFormat> formats = new ArrayList<EnumVectorFormat>();
                formats.add(EnumVectorFormat.SHAPEFILE);
                VectorImportScan vectorImportScan = new VectorImportScan(fileset, formats, null);
                vectorImportScan.scan(dataPath -> {
                    ImportVector importVector = new ImportVector();
                    importVector.setName(FileUtil.getFileNameWithoutExtension((String)dataPath));
                    importVector.setDatasetName(nameInfo.getShortName());
                    importVector.setPath(dataPath);
                    dataList.add(importVector);
                });
            } else {
                ImportVector importVector = new ImportVector();
                importVector.setName(FileUtil.getFileNameWithoutExtension((String)this.sourceParams.getPath()));
                importVector.setDatasetName(nameInfo.getShortName());
                importVector.setPath(this.sourceParams.getPath());
                dataList.add(importVector);
            }
        } else if (StringUtil.isNotEmpty((String)this.settingParams.shpPath)) {
            dataUnitName = this.settingParams.imageryModel;
            path = FileUtil.getDirectoryName((String)this.settingParams.shpPath);
            ImportVector importVector = new ImportVector();
            importVector.setName(FileUtil.getFileNameWithoutExtension((String)this.settingParams.shpPath));
            importVector.setDatasetName(nameInfo.getShortName());
            importVector.setPath(this.settingParams.shpPath);
            dataList.add(importVector);
        }
        if (dataList.size() == 0) {
            throw new RuntimeException("\u672a\u626b\u63cf\u5230shp\u6570\u636e\uff01");
        }
        ImportUnit importUnit = new ImportUnit();
        importUnit.setName(dataUnitName);
        importUnit.setCode(dataUnitName);
        importUnit.setPath(path);
        ImportScanUnitEventArgs args = new ImportScanUnitEventArgs((Object)this, (IImportUnit)importUnit, dataList);
        this.onDataUnitScaned(args);
    }

    public ExecuteResult prepareImport() {
        ExecuteResult result = super.prepareImport();
        DatasetNameInfo nameInfo = DatasetUtil.getDatasetNameInfo((String)this.targetParams.datasetId);
        if (this.targetWorkspace == null) {
            this.targetWorkspace = this.openTargetWorkspace(nameInfo.getDsKey());
        }
        if (this.targetWorkspace == null) {
            result.setSuccess(Boolean.valueOf(false));
            result.setErrorMessage("\u6253\u5f00\u76ee\u6807\u6570\u636e\u5e93\u5931\u8d25\uff01");
            this.log.error("\u6253\u5f00\u76ee\u6807\u6570\u636e\u5e93\u5931\u8d25\uff01");
            return result;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecuteResultDetail executeImport(IImportData importData) {
        ExecuteResultDetail executeResult = super.executeImport(importData);
        try (IFeatureWorkspace srcWorkspace = null;){
            srcWorkspace = this.fileStorageService.openFileLayerWorkspace(importData.getPath());
            IGeoDataset srcDataset = srcWorkspace.openGeoDataset(importData.getName());
            if (srcDataset == null) {
                executeResult.setSuccess(Boolean.valueOf(false));
                executeResult.setErrorMessage(String.format("\u6253\u5f00\u6570\u636e\u6e90\u56fe\u5c42[%s]\u5931\u8d25\uff01", importData.getName()));
                this.onImportDataLog(executeResult.getErrorMessage());
                ExecuteResultDetail executeResultDetail = executeResult;
                return executeResultDetail;
            }
            String targetDsName = ((ImportVector)importData).getDatasetName();
            IGeoDataset targetDataset = this.targetWorkspace.openGeoDataset(targetDsName);
            if (targetDataset == null) {
                executeResult.setSuccess(Boolean.valueOf(false));
                executeResult.setErrorMessage(String.format("\u76ee\u6807\u56fe\u5c42[%s]\u6253\u5f00\u5931\u8d25\uff01", targetDsName));
                this.onImportDataLog(executeResult.getErrorMessage());
                ExecuteResultDetail executeResultDetail = executeResult;
                return executeResultDetail;
            }
            if (!(targetDataset instanceof ITable)) {
                executeResult.setSuccess(Boolean.valueOf(false));
                executeResult.setErrorMessage(String.format("\u76ee\u6807\u56fe\u5c42[%s]\u7c7b\u578b\u4e0d\u652f\u6301\uff1a%s\uff01", targetDsName, targetDataset.getType()));
                this.onImportDataLog(executeResult.getErrorMessage());
                ExecuteResultDetail executeResultDetail = executeResult;
                return executeResultDetail;
            }
            if (this.sourceParams.getDataDuplicateStrategy().intValue() == DataDuplicateStrategyEnum.Delete.getValue()) {
                this.deleteRows((ITable)targetDataset, null);
            }
            Map<String, Object> defaultValues = this.getDefaultValues();
            TransferResult transferResult = null;
            if (srcDataset.getType() == GeoDatasetType.FeatureClass) {
                IFeatureClass srcFc = (IFeatureClass)srcDataset;
                transferResult = this.inputFeatureClass(srcFc, (IFeatureClass)targetDataset, defaultValues);
            } else if (srcDataset.getType() == GeoDatasetType.Table) {
                ITable srcTable = (ITable)srcDataset;
                transferResult = this.inputTable(srcTable, (ITable)targetDataset, defaultValues);
            }
            executeResult.setTotalCount(transferResult.getTotalCount());
            executeResult.setSuccessCount(transferResult.getSuccessCount());
            executeResult.setFailCount(transferResult.getFailCount());
            executeResult.setSuccess(Boolean.valueOf(transferResult.isSuccess()));
            executeResult.setErrorMessage(transferResult.getErrorMessage());
            DatasetNameInfo nameInfo = DatasetUtil.getDatasetNameInfo((String)this.targetParams.datasetId);
            String datasetName = nameInfo.getShortName();
            ImgThematic thematic = new ImgThematic();
            thematic.setShpName(FileUtil.getFileNameWithoutExtension((String)importData.getPath()));
            thematic.setDsKey(nameInfo.getDsKey());
            thematic.setDatasetId(this.targetParams.datasetId);
            thematic.setDatasetName(datasetName);
            thematic.setImportCount(Integer.valueOf(Integer.parseInt(transferResult.getSuccessCount() + "")));
            thematic.setSceneType(this.targetParams.sceneType);
            thematic.setSampleScheme(this.targetParams.sampleScheme);
            thematic.setTaskId(importData.getId() + "");
            thematic.setSchemaName(this.settingParams.imageryModel);
            this.imageThematicImportService.addThematic(thematic);
            ExecuteResultDetail executeResultDetail = executeResult;
            return executeResultDetail;
        }
    }

    protected Map<String, Object> getDefaultValues() {
        HashMap<String, Object> defaultValues = new HashMap<String, Object>(0);
        defaultValues.put("productTaskId", this.settingParams.productTaskId);
        return defaultValues;
    }

    public void importFinised() {
        try {
            if (null == this.targetWorkspace) {
                return;
            }
            DatasetNameInfo nameInfo = DatasetUtil.getDatasetNameInfo((String)this.targetParams.datasetId);
            String datasetName = nameInfo.getShortName();
            IGeoDataset targetDataset = this.targetWorkspace.openGeoDataset(datasetName);
            if (targetDataset instanceof IFeatureClass) {
                IFeatureClass targetFc = (IFeatureClass)targetDataset;
                this.updateExtent(targetFc, datasetName);
                if (Boolean.TRUE.equals(this.sourceParams.getAutoCreateIndex())) {
                    this.publishVectorService(nameInfo.getDsKey(), targetFc);
                }
            }
        }
        catch (Exception e) {
            this.log.error("\u5165\u5e93\u540e\u64cd\u4f5c\u5f02\u5e38", (Throwable)e);
            this.onImportTaskLog(e.getMessage());
        }
    }

    public void dispose() {
        if (this.targetWorkspace != null) {
            this.targetWorkspace.close();
        }
    }
}

