/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.imagedb.input.plugin.batch;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.dms.config.dto.filepackage.model.ScanResultDTO;
import com.geoway.adf.dms.config.entity.DmFileData;
import com.geoway.adf.dms.config.filemodel.DataPackage;
import com.geoway.adf.dms.config.filemodel.ScanFileResultParam;
import com.geoway.adf.dms.config.filemodel.constant.FileModelNodeTypeEnum;
import com.geoway.adf.dms.datasource.dto.DatasetNameInfo;
import com.geoway.adf.dms.datasource.util.DatasetUtil;
import com.geoway.adf.gis.fs.IFileset;
import com.geoway.imagedb.input.dto.meta.ImageMetaPluginDTO;
import com.geoway.imagedb.input.plugin.ImageGeoDatasetSettingParams;
import com.geoway.imagedb.input.plugin.ImageGeoDatasetTargetParams;
import com.geoway.imagedb.input.plugin.ImageMosaicDatasetImportPlugin;
import com.geoway.imagedb.input.plugin.batch.ImageGeoDatasetBatchSettingParams;
import com.geoway.imagedb.input.plugin.batch.ImageGeoDatasetBatchTargetParams;
import com.geoway.imagedb.input.plugin.meta.MetaPluginInfo;
import com.geoway.imagedb.input.plugin.meta.MetaPluginManager;
import com.geoway.webstore.input.plugin.data.IImportUnit;
import com.geoway.webstore.input.plugin.data.ImportDatum;
import com.geoway.webstore.input.plugin.data.ImportUnit;
import com.geoway.webstore.input.plugin.event.ImportScanUnitEventArgs;
import com.geoway.webstore.input.plugin.model.DataDuplicateStrategyEnum;
import com.geoway.webstore.input.plugin.model.ExecuteResult;
import com.geoway.webstore.input.plugin.params.ImportSourceParams;
import java.util.ArrayList;
import java.util.List;

public class ImageProductBatchImportPlugin
extends ImageMosaicDatasetImportPlugin {
    protected ImageGeoDatasetBatchTargetParams batchTargetParams;
    protected ImageGeoDatasetBatchSettingParams batchSettingParams;

    @Override
    public void initialize(String sourceParamsStr, String targetParamsStr, String settingParamsStr) {
        this.sourceParams = (ImportSourceParams)JSONObject.parseObject((String)sourceParamsStr, ImportSourceParams.class);
        this.deleteRepeatedData = DataDuplicateStrategyEnum.getByValue((Integer)this.sourceParams.getDataDuplicateStrategy()) == DataDuplicateStrategyEnum.Delete;
        this.batchSettingParams = (ImageGeoDatasetBatchSettingParams)JSONObject.parseObject((String)settingParamsStr, ImageGeoDatasetBatchSettingParams.class);
        this.batchTargetParams = (ImageGeoDatasetBatchTargetParams)JSONObject.parseObject((String)targetParamsStr, ImageGeoDatasetBatchTargetParams.class);
        this.fileStorage = this.dataSourceManager.getDataSourceDetail(this.batchSettingParams.serviceId);
        if (this.fileStorage == null) {
            throw new RuntimeException("\u83b7\u53d6\u5b58\u50a8\u8282\u70b9\u5931\u8d25\uff01");
        }
        if (!this.batchSettingParams.sourceFolderPath.contains(this.fileStorage.getUrl())) {
            throw new RuntimeException("\u6570\u636e\u4f4d\u7f6e\u4e0e\u5b58\u50a8\u8282\u70b9\u4e0d\u5339\u914d\uff01");
        }
        this.scanFileStorage = this.fileStorageService.openFileStorage(this.fileStorage.getKey());
        this.dataPath = this.batchSettingParams.sourceFolderPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void scanData() {
        for (int i = 0; i < this.batchTargetParams.datasetIdArray.length; ++i) {
            DatasetNameInfo datasetNameInfo = DatasetUtil.getDatasetNameInfo((String)this.batchTargetParams.datasetIdArray[i]);
            DataPackage dataPackage = this.fileModelService.getDataPackage(this.batchTargetParams.fileModelIdArray[i]);
            boolean hasCompact = false;
            if (dataPackage.getDataKeyObject().getNodeType().intValue() == FileModelNodeTypeEnum.CompactPackage.getValue()) {
                dataPackage.setUncompress(false);
                hasCompact = true;
            }
            IFileset dataFile = this.scanFileStorage.getFile(this.dataPath);
            try {
                ScanResultDTO scanResultDTO = dataPackage.scanFile(dataFile, Boolean.valueOf(false));
                if (scanResultDTO.getDataCount() == 0L) {
                    this.log.error(String.format("\u6570\u636e\u7ec4\u7ec7\u7ed3\u6784\u4e0d\u6b63\u786e\uff0c\u8bf7\u68c0\u67e5[%s]\u3002", dataPackage.getName()));
                    continue;
                }
            }
            catch (Exception e) {
                this.log.error(String.format("\u6570\u636e\u5305[%s]\u626b\u63cf\u5931\u8d25\u3002%s", dataPackage.getName(), e.getMessage()), (Throwable)e);
                continue;
            }
            finally {
                if (hasCompact) {
                    dataPackage.getArchiveEnvironment().dispose();
                }
            }
            ImportUnit importUnit = new ImportUnit();
            importUnit.setName(datasetNameInfo.getShortName());
            importUnit.setCode(i + "");
            importUnit.setPath(this.dataPath);
            ArrayList<ImportDatum> importDataList = new ArrayList<ImportDatum>();
            List scanFileResultParams = dataPackage.getScanFileResultParams();
            for (ScanFileResultParam resultItem : scanFileResultParams) {
                if (!hasCompact && !resultItem.getScanResult().booleanValue()) {
                    this.log.error(String.format("\u6570\u636e\u5305[%s]\u6709\u6548\u6027\u68c0\u67e5\u672a\u901a\u8fc7\u3002", resultItem.getMainFilePath()));
                    continue;
                }
                DmFileData fileData = resultItem.getData();
                if (importDataList.stream().anyMatch(c -> c.getName().equals(fileData.getDataName()))) {
                    this.log.error(String.format("\u6307\u5b9a\u6570\u636e\u76ee\u5f55\u4e0b\u6570\u636e\u5305[%s]\u5b58\u5728\u91cd\u590d\u3002", fileData.getDataName()));
                    continue;
                }
                ImportDatum importDatum = new ImportDatum();
                importDatum.setName(fileData.getDataName());
                importDatum.setPath(resultItem.getMainFilePath());
                importDatum.setDatasetName(datasetNameInfo.getShortName());
                importDatum.setFileData(JSONObject.toJSONString((Object)fileData, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect}));
                importDataList.add(importDatum);
            }
            ImportScanUnitEventArgs args = new ImportScanUnitEventArgs((Object)this, (IImportUnit)importUnit, importDataList);
            this.onDataUnitScaned(args);
        }
    }

    @Override
    public ExecuteResult prepareImport() {
        ExecuteResult result = new ExecuteResult();
        result.setSuccess(Boolean.valueOf(true));
        return result;
    }

    public ExecuteResult prepareImport(IImportUnit importUnit) {
        this.targetParams = new ImageGeoDatasetTargetParams();
        this.targetParams.datasetId = this.batchTargetParams.datasetIdArray[Integer.parseInt(importUnit.getCode())];
        this.targetParams.fileModelId = this.batchTargetParams.fileModelIdArray[Integer.parseInt(importUnit.getCode())];
        this.targetParams.metaPluginInfo = this.batchTargetParams.metaPluginInfoArray[Integer.parseInt(importUnit.getCode())];
        this.settingParams = new ImageGeoDatasetSettingParams();
        this.settingParams.serviceId = this.batchSettingParams.serviceId;
        this.settingParams.sourceFolderPath = this.batchSettingParams.sourceFolderPath;
        this.settingParams.time = this.batchSettingParams.time;
        this.settingParams.imageClassify = this.batchSettingParams.imageClassify;
        this.dataPackage = this.fileModelService.getDataPackage(this.targetParams.fileModelId);
        if (this.dataPackage.getDataKeyObject().getNodeType().intValue() == FileModelNodeTypeEnum.CompactPackage.getValue()) {
            this.dataPackage.setUncompress(false);
            this.hasCompact = true;
        }
        if (StringUtil.isNotEmpty((String)this.targetParams.metaPluginInfo)) {
            try {
                MetaPluginInfo pluginInfo = this.targetParams.getImageMetaPluginInfo();
                if (StringUtil.isEmptyOrWhiteSpace((String)pluginInfo.getPluginClassName())) {
                    ImageMetaPluginDTO metaPluginDTO = this.imageMetaPluginService.getDetail(pluginInfo.getConfigFile());
                    this.imageMetaDataPlugin = MetaPluginManager.createImageMetaDataPlugin(metaPluginDTO);
                } else {
                    this.imageMetaDataPlugin = MetaPluginManager.createImageMetaDataPlugin(this.targetParams.getImageMetaPluginInfo());
                }
                this.settingParams.imageClassify = this.settingParams.imageClassify.replace("/", "_");
            }
            catch (Exception e) {
                this.log.error("\u5143\u6570\u636e\u5165\u5e93\u63d2\u4ef6\u521d\u59cb\u5316\u5931\u8d25\uff01", (Throwable)e);
                throw new RuntimeException("\u5143\u6570\u636e\u5165\u5e93\u63d2\u4ef6\u521d\u59cb\u5316\u5931\u8d25\uff01");
            }
        }
        return super.prepareImport();
    }

    @Override
    public void importFinised(IImportUnit importUnit) {
        super.importFinised(importUnit);
        super.importFinised();
        if (this.targetWorkspace != null) {
            this.targetWorkspace.close();
        }
        if (this.businessSnapshotWorkspace != null) {
            this.businessSnapshotWorkspace.close();
        }
    }

    @Override
    public void importFinised() {
    }
}

