/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.imagedb.input.plugin.meta;

import cn.hutool.core.io.resource.ResourceUtil;
import cn.hutool.core.util.NumberUtil;
import com.geoway.adf.dms.common.util.FileUtil;
import com.geoway.adf.dms.common.util.ListUtil;
import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.dms.config.entity.DmFileData;
import com.geoway.adf.dms.config.filemodel.FileDataUnit;
import com.geoway.adf.gis.fs.IFileStorage;
import com.geoway.imagedb.input.dto.meta.MetaFieldMappingDTO;
import com.geoway.imagedb.input.plugin.meta.IImageMetaDataPlugin;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.gdal.gdal.Dataset;
import org.gdal.gdal.TranslateOptions;
import org.gdal.gdal.WarpOptions;
import org.gdal.gdal.gdal;
import org.gdal.gdalconst.gdalconstConstants;
import org.gdal.osr.SpatialReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public abstract class ImageMetaDataPluginBase
implements IImageMetaDataPlugin {
    private static final Logger log = LoggerFactory.getLogger(ImageMetaDataPluginBase.class);
    protected String tifTempDir;
    protected Map<String, List<String>> matchTable;
    protected Map<String, String> defaultValue;
    protected Map<String, Object> metaData;
    protected String WGS_1984 = "GEOGCS[\"WGS 84\",\n    DATUM[\"WGS_1984\",\n        SPHEROID[\"WGS 84\",6378137,298.257223563,\n            AUTHORITY[\"EPSG\",\"7030\"]],\n        AUTHORITY[\"EPSG\",\"6326\"]],\n    PRIMEM[\"Greenwich\",0,\n        AUTHORITY[\"EPSG\",\"8901\"]],\n    UNIT[\"degree\",0.0174532925199433,\n        AUTHORITY[\"EPSG\",\"9122\"]],\n    AXIS[\"Latitude\",NORTH],\n    AXIS[\"Longitude\",EAST],\n    AUTHORITY[\"EPSG\",\"4326\"]]";
    protected double topLeftX = 0.0;
    protected double bottomLeftY = 0.0;
    protected double topRightX = 0.0;
    protected double topLeftY = 0.0;
    protected double bottomRightX = 0.0;
    protected double bottomRightY = 0.0;

    @Override
    public void setConfigFile(String configFile) {
        this.matchTable = new HashMap<String, List<String>>(0);
        this.defaultValue = new HashMap<String, String>(0);
        if (configFile != null) {
            this.generateMatchTable(configFile);
        }
    }

    @Override
    public void setMatchFields(List<MetaFieldMappingDTO> matchFields) {
        this.matchTable = new HashMap<String, List<String>>(0);
        this.defaultValue = new HashMap<String, String>(0);
        for (MetaFieldMappingDTO mapping : matchFields) {
            if (!this.matchTable.containsKey(mapping.getSourceField())) {
                this.matchTable.put(mapping.getSourceField(), new LinkedList());
            }
            this.matchTable.get(mapping.getSourceField()).add(mapping.getTargetField());
            if (!StringUtil.isNotEmpty((String)mapping.getDefaultValue())) continue;
            this.defaultValue.put(mapping.getTargetField(), mapping.getDefaultValue());
        }
    }

    @Override
    public void modifyDefaultValue(String key, String value) {
        this.defaultValue.put(key, value);
    }

    @Override
    public Map<String, Object> readMetaData(DmFileData fileData, IFileStorage scanFileStorage) {
        return this.readMetaDataAbstract(fileData, scanFileStorage);
    }

    protected abstract Map<String, Object> readMetaDataAbstract(DmFileData var1, IFileStorage var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String createSnapshotFile(DmFileData fileData, IFileStorage scanFileStorage, boolean isProductImageData, Integer targetSrid) {
        File tempDir = new File(this.tifTempDir);
        List<File> tempFiles = this.readAllFile(tempDir);
        if (tempFiles.size() == 0) {
            throw new RuntimeException("\u672a\u89e3\u538b\u539f\u59cb\u5f71\u50cf\uff01");
        }
        try {
            Object object;
            String jpg = null;
            for (File tempFile : tempFiles) {
                if (!tempFile.getPath().toLowerCase(Locale.ROOT).endsWith(".jpg")) continue;
                jpg = tempFile.getPath();
                break;
            }
            if (jpg == null) {
                object = null;
                return object;
            }
            object = this.createSnapshotFileBySourceImage(fileData, jpg, isProductImageData, targetSrid);
            return object;
        }
        finally {
            for (File file : tempFiles) {
                file.delete();
            }
        }
    }

    protected void readMetaDataFromXML(InputStream tarIn, String metaFileName) throws ParserConfigurationException, IOException, SAXException {
        String[] geoCoords;
        for (String fld : this.defaultValue.keySet()) {
            String value = this.defaultValue.get(fld);
            if (!value.startsWith("${") || !value.endsWith("}")) continue;
            value = this.readMetaDataFromJs(value.substring(2, value.length() - 1), metaFileName);
            this.defaultValue.put(fld, value);
        }
        String regex = ".*\\[\\d+\\]$";
        Pattern pattern = Pattern.compile(regex);
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        factory.setNamespaceAware(true);
        factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.parse(tarIn);
        for (String nodeNameString : this.matchTable.keySet()) {
            String utf_8_bom;
            String[] nodeNames = nodeNameString.split("/");
            String rootNodeName = nodeNames[0];
            if (rootNodeName.startsWith(utf_8_bom = "\ufeff")) {
                rootNodeName = rootNodeName.substring(1);
            }
            int number = 0;
            if (pattern.matcher(rootNodeName).matches()) {
                number = Integer.parseInt(rootNodeName.substring(rootNodeName.lastIndexOf("[") + 1, rootNodeName.lastIndexOf("]")));
                rootNodeName = rootNodeName.substring(0, rootNodeName.lastIndexOf("["));
            }
            NodeList nodeList = document.getElementsByTagName(rootNodeName);
            for (int index = 1; nodeList.getLength() > 0 && index < nodeNames.length; ++index) {
                Element element = (Element)nodeList.item(number);
                String nodeName = nodeNames[index];
                if (pattern.matcher(nodeName).matches()) {
                    number = Integer.parseInt(nodeName.substring(nodeName.lastIndexOf("[") + 1, nodeName.lastIndexOf("]")));
                    nodeName = nodeName.substring(0, nodeName.lastIndexOf("["));
                } else {
                    number = 0;
                }
                nodeList = element.getElementsByTagName(nodeName);
                if (index != nodeNames.length - 1 || nodeList.getLength() <= 0 || StringUtil.isEmptyOrWhiteSpace((String)(element = (Element)nodeList.item(number)).getTextContent()) || "null".equalsIgnoreCase(element.getTextContent())) continue;
                for (String targetField : this.matchTable.get(nodeNameString)) {
                    this.metaData.put(targetField, element.getTextContent());
                }
            }
            for (String targetField : this.matchTable.get(nodeNameString)) {
                if (this.metaData.containsKey(targetField) || !this.defaultValue.containsKey(targetField)) continue;
                this.metaData.put(targetField, this.defaultValue.get(targetField));
            }
        }
        if (this.metaData.containsKey("\u56fe\u50cf\u5de6\u4e0a\u89d2\u7ecf\u5ea6") && this.metaData.containsKey("\u56fe\u50cf\u53f3\u4e0a\u89d2\u7ecf\u5ea6") && this.metaData.containsKey("\u56fe\u50cf\u5de6\u4e0b\u89d2\u7ecf\u5ea6") && this.metaData.containsKey("\u56fe\u50cf\u53f3\u4e0b\u89d2\u7ecf\u5ea6") && this.metaData.get("\u56fe\u50cf\u5de6\u4e0a\u89d2\u7ecf\u5ea6").equals(this.metaData.get("\u56fe\u50cf\u5de6\u4e0a\u89d2\u7ecf\u5ea6")) && this.metaData.get("\u56fe\u50cf\u5de6\u4e0a\u89d2\u7ecf\u5ea6").equals(this.metaData.get("\u56fe\u50cf\u5de6\u4e0b\u89d2\u7ecf\u5ea6")) && this.metaData.get("\u56fe\u50cf\u5de6\u4e0b\u89d2\u7ecf\u5ea6").equals(this.metaData.get("\u56fe\u50cf\u53f3\u4e0b\u89d2\u7ecf\u5ea6")) && (geoCoords = this.metaData.get("\u56fe\u50cf\u5de6\u4e0a\u89d2\u7ecf\u5ea6").toString().split(" ")).length == 4) {
            this.sortCoordinate(geoCoords);
        }
        if (this.metaData.containsKey("\u56fe\u50cf\u5de6\u4e0a\u89d2\u7ecf\u5ea6") && this.metaData.get("\u56fe\u50cf\u5de6\u4e0a\u89d2\u7ecf\u5ea6").toString().contains(" ") && this.metaData.get("\u56fe\u50cf\u5de6\u4e0a\u89d2\u7ecf\u5ea6").equals(this.metaData.get("\u56fe\u50cf\u5de6\u4e0a\u89d2\u7eac\u5ea6"))) {
            String[] strTopLeft = this.metaData.get("\u56fe\u50cf\u5de6\u4e0a\u89d2\u7ecf\u5ea6").toString().split(" ");
            this.metaData.put("\u56fe\u50cf\u5de6\u4e0a\u89d2\u7eac\u5ea6", strTopLeft[0]);
            this.metaData.put("\u56fe\u50cf\u5de6\u4e0a\u89d2\u7ecf\u5ea6", strTopLeft[1]);
            String[] strTopRight = this.metaData.get("\u56fe\u50cf\u53f3\u4e0a\u89d2\u7ecf\u5ea6").toString().split(" ");
            this.metaData.put("\u56fe\u50cf\u53f3\u4e0a\u89d2\u7eac\u5ea6", strTopRight[0]);
            this.metaData.put("\u56fe\u50cf\u53f3\u4e0a\u89d2\u7ecf\u5ea6", strTopRight[1]);
            String[] strBottomLeft = this.metaData.get("\u56fe\u50cf\u5de6\u4e0b\u89d2\u7ecf\u5ea6").toString().split(" ");
            this.metaData.put("\u56fe\u50cf\u5de6\u4e0b\u89d2\u7eac\u5ea6", strBottomLeft[0]);
            this.metaData.put("\u56fe\u50cf\u5de6\u4e0b\u89d2\u7ecf\u5ea6", strBottomLeft[1]);
            String[] strBottomRight = this.metaData.get("\u56fe\u50cf\u53f3\u4e0b\u89d2\u7ecf\u5ea6").toString().split(" ");
            this.metaData.put("\u56fe\u50cf\u53f3\u4e0b\u89d2\u7eac\u5ea6", strBottomRight[0]);
            this.metaData.put("\u56fe\u50cf\u53f3\u4e0b\u89d2\u7ecf\u5ea6", strBottomRight[1]);
        }
    }

    protected void readMetaExtent() {
        if (!this.metaData.containsKey("\u56fe\u50cf\u5de6\u4e0a\u89d2\u7ecf\u5ea6")) {
            throw new RuntimeException("\u5143\u6570\u636e\u672a\u8bfb\u53d6\u5230\u56fe\u50cf\u5de6\u4e0a\u89d2\u7ecf\u5ea6");
        }
        this.topLeftX = Double.parseDouble(this.metaData.get("\u56fe\u50cf\u5de6\u4e0a\u89d2\u7ecf\u5ea6").toString());
        if (!this.metaData.containsKey("\u56fe\u50cf\u5de6\u4e0b\u89d2\u7eac\u5ea6")) {
            throw new RuntimeException("\u5143\u6570\u636e\u672a\u8bfb\u53d6\u5230\u56fe\u50cf\u5de6\u4e0b\u89d2\u7eac\u5ea6");
        }
        this.bottomLeftY = Double.parseDouble(this.metaData.get("\u56fe\u50cf\u5de6\u4e0b\u89d2\u7eac\u5ea6").toString());
        if (!this.metaData.containsKey("\u56fe\u50cf\u53f3\u4e0a\u89d2\u7ecf\u5ea6")) {
            throw new RuntimeException("\u5143\u6570\u636e\u672a\u8bfb\u53d6\u5230\u56fe\u50cf\u53f3\u4e0a\u89d2\u7ecf\u5ea6");
        }
        this.topRightX = Double.parseDouble(this.metaData.get("\u56fe\u50cf\u53f3\u4e0a\u89d2\u7ecf\u5ea6").toString());
        if (!this.metaData.containsKey("\u56fe\u50cf\u5de6\u4e0a\u89d2\u7eac\u5ea6")) {
            throw new RuntimeException("\u5143\u6570\u636e\u672a\u8bfb\u53d6\u5230\u56fe\u50cf\u5de6\u4e0a\u89d2\u7eac\u5ea6");
        }
        this.topLeftY = Double.parseDouble(this.metaData.get("\u56fe\u50cf\u5de6\u4e0a\u89d2\u7eac\u5ea6").toString());
        if (!this.metaData.containsKey("\u56fe\u50cf\u53f3\u4e0b\u89d2\u7ecf\u5ea6")) {
            throw new RuntimeException("\u5143\u6570\u636e\u672a\u8bfb\u53d6\u5230\u56fe\u50cf\u53f3\u4e0b\u89d2\u7ecf\u5ea6");
        }
        this.bottomRightX = Double.parseDouble(this.metaData.get("\u56fe\u50cf\u53f3\u4e0b\u89d2\u7ecf\u5ea6").toString());
        if (!this.metaData.containsKey("\u56fe\u50cf\u53f3\u4e0b\u89d2\u7eac\u5ea6")) {
            throw new RuntimeException("\u5143\u6570\u636e\u672a\u8bfb\u53d6\u5230\u56fe\u50cf\u53f3\u4e0b\u89d2\u7eac\u5ea6");
        }
        this.bottomRightY = Double.parseDouble(this.metaData.get("\u56fe\u50cf\u53f3\u4e0b\u89d2\u7eac\u5ea6").toString());
        if (this.metaData.containsKey("\u4f7f\u7528\u5916\u63a5\u77e9\u5f62\u914d\u51c6\u5feb\u89c6\u56fe") && this.metaData.get("\u4f7f\u7528\u5916\u63a5\u77e9\u5f62\u914d\u51c6\u5feb\u89c6\u56fe") != null && "true".equals(this.metaData.get("\u4f7f\u7528\u5916\u63a5\u77e9\u5f62\u914d\u51c6\u5feb\u89c6\u56fe").toString())) {
            double minX = Math.min(this.topLeftX, Math.min(this.topRightX, Math.min(Double.parseDouble(this.metaData.get("\u56fe\u50cf\u5de6\u4e0b\u89d2\u7ecf\u5ea6").toString()), this.bottomRightX)));
            double minY = Math.min(this.bottomLeftY, Math.min(this.topLeftY, Math.min(Double.parseDouble(this.metaData.get("\u56fe\u50cf\u53f3\u4e0a\u89d2\u7eac\u5ea6").toString()), this.bottomRightY)));
            double maxX = Math.max(this.topLeftX, Math.max(this.topRightX, Math.max(Double.parseDouble(this.metaData.get("\u56fe\u50cf\u5de6\u4e0b\u89d2\u7ecf\u5ea6").toString()), this.bottomRightX)));
            double maxY = Math.max(this.bottomLeftY, Math.max(this.topLeftY, Math.max(Double.parseDouble(this.metaData.get("\u56fe\u50cf\u53f3\u4e0a\u89d2\u7eac\u5ea6").toString()), this.bottomRightY)));
            this.topLeftX = minX;
            this.bottomLeftY = minY;
            this.topRightX = maxX;
            this.topLeftY = maxY;
            this.bottomRightX = maxX;
            this.bottomRightY = minY;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readMetaExtentFromSourceImage(DmFileData fileData) {
        List lstFile = fileData.getFiles();
        FileDataUnit sRasterFileData = (FileDataUnit)ListUtil.find((List)lstFile, f -> f.getProperties() != null && f.getProperties().contains("RasterFile"));
        if (sRasterFileData == null) {
            throw new RuntimeException("\u672a\u6307\u5b9a\u5f71\u50cf\u6570\u636e\u6587\u4ef6\uff01");
        }
        String imageDataFile = sRasterFileData.getFileSourceLocation();
        Dataset dataset = null;
        try {
            dataset = gdal.Open((String)imageDataFile, (int)gdalconstConstants.GA_ReadOnly);
            if (dataset == null) {
                throw new RuntimeException("\u6805\u683c\u8bfb\u53d6\u5931\u8d25\uff01");
            }
            double[] geoTransform = dataset.GetGeoTransform();
            int xSize = dataset.GetRasterXSize();
            int ySize = dataset.GetRasterYSize();
            double[] topLeft = this.getCoordinate(geoTransform, 0, 0);
            double[] topRight = this.getCoordinate(geoTransform, xSize, 0);
            double[] bottomRight = this.getCoordinate(geoTransform, xSize, ySize);
            double[] bottomLeft = this.getCoordinate(geoTransform, 0, ySize);
            this.topLeftX = topLeft[0];
            this.topLeftY = topLeft[1];
            this.topRightX = topRight[0];
            this.bottomRightX = bottomRight[0];
            this.bottomRightY = bottomRight[1];
            this.bottomLeftY = bottomLeft[1];
        }
        finally {
            if (dataset != null) {
                dataset.delete();
            }
        }
    }

    private double[] getCoordinate(double[] geoTransform, int pixel, int line) {
        double[] coord = new double[]{geoTransform[0] + (double)pixel * geoTransform[1] + (double)line * geoTransform[2], geoTransform[3] + (double)pixel * geoTransform[4] + (double)line * geoTransform[5]};
        return coord;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String createSnapshotFileByRasterFile(DmFileData fileData, String snapshotFileDir, Integer targetSrid) {
        List lstFile = fileData.getFiles();
        FileDataUnit sRasterFileData = (FileDataUnit)ListUtil.find((List)lstFile, f -> f.getProperties() != null && f.getProperties().contains("RasterFile"));
        if (sRasterFileData == null) {
            throw new RuntimeException("\u672a\u6307\u5b9a\u5f71\u50cf\u6570\u636e\u6587\u4ef6\uff01");
        }
        String imageDataFile = sRasterFileData.getFileSourceLocation();
        String snapshotFile = null;
        Dataset dataset = null;
        try {
            dataset = gdal.Open((String)imageDataFile, (int)gdalconstConstants.GA_ReadOnly);
            if (dataset == null) {
                throw new RuntimeException("\u6805\u683c\u8bfb\u53d6\u5931\u8d25\uff01");
            }
            int xSize = dataset.getRasterXSize();
            if (xSize > 2048) {
                xSize = 2048;
            }
            String snapshotFile_t = Paths.get(snapshotFileDir, FileUtil.getFileNameWithoutExtension((String)imageDataFile) + "-snapshot-t.png").toFile().getAbsolutePath();
            Vector vector = gdal.ParseCommandLine((String)String.format("-of PNG -outsize %d %d -ot Byte -scale", xSize, 0));
            if (dataset.GetRasterCount() >= 4) {
                vector = gdal.ParseCommandLine((String)String.format("-of PNG -outsize %d %d -ot Byte -b 1 -b 2 -b 3 -scale", xSize, 0));
            } else if (dataset.GetRasterCount() == 1) {
                vector = gdal.ParseCommandLine((String)String.format("-of PNG -outsize %d %d -ot Byte -b 1 -b 1 -b 1 -scale", xSize, 0));
            }
            TranslateOptions options = new TranslateOptions(vector);
            Dataset snapshotDataset_t = gdal.Translate((String)snapshotFile_t, (Dataset)dataset, (TranslateOptions)options);
            if (snapshotDataset_t != null) {
                snapshotFile = Paths.get(snapshotFileDir, FileUtil.getFileNameWithoutExtension((String)imageDataFile) + "-snapshot.png").toFile().getAbsolutePath();
                this.setSnapshotSrid(snapshotDataset_t, snapshotFile, targetSrid);
                snapshotDataset_t.delete();
                File pngFile = new File(snapshotFile_t);
                pngFile.delete();
                File pngAuxFile = new File(snapshotFile_t + ".aux.xml");
                pngAuxFile.delete();
            }
        }
        finally {
            if (dataset != null) {
                dataset.delete();
            }
        }
        return snapshotFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String createSnapshotFileBySourceImage(DmFileData fileData, String srcJpg, boolean isProductImageData, Integer targetSrid) {
        String snapshotFile = srcJpg;
        if (!isProductImageData) {
            this.readMetaExtent();
        } else {
            this.readMetaExtentFromSourceImage(fileData);
        }
        Dataset dataset = null;
        try {
            double[] geoTransform;
            String snapshotFileTemp = Paths.get(FileUtil.getDirectoryName((String)srcJpg), FileUtil.getFileNameWithoutExtension((String)srcJpg) + "-temp.tif").toFile().getAbsolutePath();
            Dataset jpgDataset = gdal.Open((String)srcJpg, (int)gdalconstConstants.GA_ReadOnly);
            if (jpgDataset == null) {
                throw new RuntimeException("\u6805\u683c\u8bfb\u53d6\u5931\u8d25\uff01");
            }
            String tifTemp = Paths.get(FileUtil.getDirectoryName((String)srcJpg), FileUtil.getFileNameWithoutExtension((String)srcJpg) + "-gw.tif").toFile().getAbsolutePath();
            Vector tifVector = gdal.ParseCommandLine((String)"-of GTiff -ot Byte -scale");
            if (jpgDataset.GetRasterCount() == 1) {
                tifVector = gdal.ParseCommandLine((String)"-of GTiff -ot Byte -b 1 -b 1 -b 1 -scale");
            }
            TranslateOptions tifTranslateOptions = new TranslateOptions(tifVector);
            Dataset tifDataset = gdal.Translate((String)tifTemp, (Dataset)jpgDataset, (TranslateOptions)tifTranslateOptions);
            tifDataset.delete();
            jpgDataset.delete();
            dataset = gdal.Open((String)tifTemp, (int)gdalconstConstants.GA_Update);
            int xSize = dataset.getRasterXSize();
            int ySize = dataset.GetRasterYSize();
            SpatialReference spatialReference = dataset.GetSpatialRef();
            if (spatialReference == null) {
                dataset.SetProjection(this.WGS_1984);
            }
            if (Math.abs((geoTransform = dataset.GetGeoTransform())[0] - this.topLeftX) > 1.0) {
                geoTransform[0] = this.topLeftX;
                geoTransform[3] = this.topLeftY;
                double xRes = NumberUtil.div((double)(this.topRightX - this.topLeftX), (float)xSize);
                double yRes = NumberUtil.div((double)(this.topLeftY - this.bottomLeftY), (float)ySize);
                geoTransform[1] = xRes;
                geoTransform[5] = -yRes;
                geoTransform[2] = NumberUtil.div((double)(this.bottomRightX - geoTransform[0] - (double)xSize * geoTransform[1]), (float)ySize);
                geoTransform[4] = NumberUtil.div((double)(this.bottomRightY - geoTransform[3] - (double)ySize * geoTransform[5]), (float)xSize);
                dataset.SetGeoTransform(geoTransform);
            }
            dataset.FlushCache();
            dataset.delete();
            dataset = null;
            dataset = gdal.Open((String)tifTemp, (int)gdalconstConstants.GA_ReadOnly);
            Vector<String> vector = new Vector<String>();
            vector.add("-r");
            vector.add("bilinear");
            WarpOptions options = new WarpOptions(vector);
            Dataset[] srcDatasets = new Dataset[]{dataset};
            Dataset targetDataset = gdal.Warp((String)snapshotFileTemp, (Dataset[])srcDatasets, (WarpOptions)options);
            if (targetDataset != null) {
                targetDataset.delete();
            }
            String snapshotFile_t = Paths.get(FileUtil.getDirectoryName((String)srcJpg), FileUtil.getFileNameWithoutExtension((String)srcJpg) + "-snapshot-t.png").toFile().getAbsolutePath();
            Dataset tempDataset = gdal.Open((String)snapshotFileTemp, (int)gdalconstConstants.GA_ReadOnly);
            Vector vectorTranslate = gdal.ParseCommandLine((String)"-of PNG -ot Byte -scale");
            if (dataset.GetRasterCount() >= 4) {
                vectorTranslate = gdal.ParseCommandLine((String)"-of PNG -ot Byte -b 1 -b 2 -b 3 -scale");
            } else if (dataset.GetRasterCount() == 1) {
                vectorTranslate = gdal.ParseCommandLine((String)"-of PNG -ot Byte -b 1 -b 1 -b 1 -scale");
            }
            TranslateOptions translateOptions = new TranslateOptions(vectorTranslate);
            Dataset snapshotDataset_t = gdal.Translate((String)snapshotFile_t, (Dataset)tempDataset, (TranslateOptions)translateOptions);
            if (snapshotDataset_t != null) {
                snapshotFile = Paths.get(FileUtil.getDirectoryName((String)srcJpg), FileUtil.getFileNameWithoutExtension((String)srcJpg) + "-snapshot.png").toFile().getAbsolutePath();
                this.setSnapshotSrid(snapshotDataset_t, snapshotFile, targetSrid);
                snapshotDataset_t.delete();
                File pngFile = new File(snapshotFile_t);
                pngFile.delete();
                File pngAuxFile = new File(snapshotFile_t + ".aux.xml");
                pngAuxFile.delete();
            }
            tempDataset.delete();
            dataset.delete();
            File tempSnapshotFile = new File(snapshotFileTemp);
            tempSnapshotFile.delete();
            File tifTempFile = new File(tifTemp);
            tifTempFile.delete();
        }
        finally {
            if (dataset != null) {
                dataset.delete();
            }
        }
        return snapshotFile;
    }

    protected void setSnapshotSrid(Dataset dataset, String snapshotFile, Integer targetSrid) {
        Vector<String> vector = new Vector<String>();
        vector.add("-r");
        vector.add("bilinear");
        vector.add("-t_srs");
        vector.add(String.format("EPSG:%d", targetSrid));
        vector.add("-dstalpha");
        WarpOptions options = new WarpOptions(vector);
        Dataset[] srcDatasets = new Dataset[]{dataset};
        Dataset snapshotDataset = gdal.Warp((String)snapshotFile, (Dataset[])srcDatasets, (WarpOptions)options);
        if (snapshotDataset != null) {
            snapshotDataset.delete();
        }
    }

    protected void generateMatchTable(String configFile) {
        try {
            URL resource;
            File pluginFile = new File("image/meta/" + configFile + ".txt");
            if (pluginFile.exists() && pluginFile.isFile()) {
                log.info("\u8bfb\u53d6\u5143\u6570\u636e\u914d\u7f6e\u6587\u4ef6\uff1a" + pluginFile.getAbsolutePath());
                resource = pluginFile.toURI().toURL();
            } else {
                resource = ResourceUtil.getResource((String)("image/meta/" + configFile + ".txt"));
                log.info("\u8bfb\u53d6\u5143\u6570\u636e\u914d\u7f6e\u6587\u4ef6\uff1a" + resource.getPath());
            }
            List lines = cn.hutool.core.io.FileUtil.readLines((URL)resource, (Charset)StandardCharsets.UTF_8);
            for (String line : lines) {
                String[] array;
                if (StringUtil.isEmptyOrWhiteSpace((String)line.trim()) || (array = line.split(" ", 3)).length < 2) continue;
                if (!this.matchTable.containsKey(array[0])) {
                    this.matchTable.put(array[0], new LinkedList());
                }
                this.matchTable.get(array[0]).add(array[1]);
                if (array.length != 3) continue;
                this.defaultValue.put(array[1], array[2]);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("configFile\u8bfb\u53d6\u5931\u8d25\uff01", e);
        }
    }

    protected List<File> readAllFile(File tempDir) {
        ArrayList<File> tempFiles = new ArrayList<File>();
        File[] files = tempDir.listFiles();
        if (files != null && files.length > 0) {
            for (File file : files) {
                tempFiles.add(file);
                if (!file.isDirectory()) continue;
                tempFiles.addAll(this.readAllFile(file));
            }
        }
        return tempFiles;
    }

    protected String readMetaDataFromJs(String jsonContent, String metaFileName) {
        try {
            if (StringUtil.isEmptyOrWhiteSpace((String)jsonContent)) {
                return "";
            }
            ScriptEngineManager manager = new ScriptEngineManager();
            ScriptEngine engine = manager.getEngineByName("js");
            Bindings bindings = engine.createBindings();
            bindings.put("CurrentFileName", (Object)metaFileName);
            String js = String.format("function GetFileName(CurrentFileName){%s} GetFileName(CurrentFileName);", jsonContent);
            Object result = engine.eval(js, bindings);
            return result == null ? null : result.toString();
        }
        catch (Exception e) {
            log.error("js\u811a\u672c\u9519\u8bef\uff1a", (Throwable)e);
            throw new RuntimeException("js\u811a\u672c\u9519\u8bef\uff1a" + e.getMessage());
        }
    }

    protected void sortCoordinate(String[] geoCoords) {
        ArrayList<String[]> geoCoordsList = new ArrayList<String[]>();
        geoCoordsList.add(geoCoords[0].split(","));
        geoCoordsList.add(geoCoords[1].split(","));
        geoCoordsList.add(geoCoords[2].split(","));
        geoCoordsList.add(geoCoords[3].split(","));
        geoCoordsList.sort((o1, o2) -> {
            double lat1 = Double.parseDouble(o1[0]);
            double lat2 = Double.parseDouble(o2[0]);
            int result = Double.compare(lat2, lat1);
            if (result == 0) {
                double lon1 = Double.parseDouble(o1[1]);
                double lon2 = Double.parseDouble(o2[1]);
                return Double.compare(lon1, lon2);
            }
            return result;
        });
        ArrayList north = new ArrayList(geoCoordsList.subList(0, 2));
        ArrayList south = new ArrayList(geoCoordsList.subList(2, 4));
        if (Double.parseDouble(((String[])north.get(0))[1]) < Double.parseDouble(((String[])north.get(1))[1])) {
            this.metaData.put("\u56fe\u50cf\u5de6\u4e0a\u89d2\u7eac\u5ea6", ((String[])north.get(0))[0]);
            this.metaData.put("\u56fe\u50cf\u5de6\u4e0a\u89d2\u7ecf\u5ea6", ((String[])north.get(0))[1]);
            this.metaData.put("\u56fe\u50cf\u53f3\u4e0a\u89d2\u7eac\u5ea6", ((String[])north.get(1))[0]);
            this.metaData.put("\u56fe\u50cf\u53f3\u4e0a\u89d2\u7ecf\u5ea6", ((String[])north.get(1))[1]);
        } else {
            this.metaData.put("\u56fe\u50cf\u5de6\u4e0a\u89d2\u7eac\u5ea6", ((String[])north.get(1))[0]);
            this.metaData.put("\u56fe\u50cf\u5de6\u4e0a\u89d2\u7ecf\u5ea6", ((String[])north.get(1))[1]);
            this.metaData.put("\u56fe\u50cf\u53f3\u4e0a\u89d2\u7eac\u5ea6", ((String[])north.get(0))[0]);
            this.metaData.put("\u56fe\u50cf\u53f3\u4e0a\u89d2\u7ecf\u5ea6", ((String[])north.get(0))[1]);
        }
        if (Double.parseDouble(((String[])south.get(0))[1]) < Double.parseDouble(((String[])south.get(1))[1])) {
            this.metaData.put("\u56fe\u50cf\u5de6\u4e0b\u89d2\u7eac\u5ea6", ((String[])south.get(0))[0]);
            this.metaData.put("\u56fe\u50cf\u5de6\u4e0b\u89d2\u7ecf\u5ea6", ((String[])south.get(0))[1]);
            this.metaData.put("\u56fe\u50cf\u53f3\u4e0b\u89d2\u7eac\u5ea6", ((String[])south.get(1))[0]);
            this.metaData.put("\u56fe\u50cf\u53f3\u4e0b\u89d2\u7ecf\u5ea6", ((String[])south.get(1))[1]);
        } else {
            this.metaData.put("\u56fe\u50cf\u5de6\u4e0b\u89d2\u7eac\u5ea6", ((String[])south.get(1))[0]);
            this.metaData.put("\u56fe\u50cf\u5de6\u4e0b\u89d2\u7ecf\u5ea6", ((String[])south.get(1))[1]);
            this.metaData.put("\u56fe\u50cf\u53f3\u4e0b\u89d2\u7eac\u5ea6", ((String[])south.get(0))[0]);
            this.metaData.put("\u56fe\u50cf\u53f3\u4e0b\u89d2\u7ecf\u5ea6", ((String[])south.get(0))[1]);
        }
    }
}

