/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.jckj.api.controller;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.geoway.jckj.base.base.dto.LoginResponse;
import com.geoway.jckj.base.base.dto.ResponseDataBase;
import com.geoway.jckj.base.support.Pair;
import com.geoway.jckj.base.support.StringUtils;
import com.geoway.jckj.base.support.encryption.AESUtils;
import com.geoway.jckj.biz.annotation.OpLog;
import com.geoway.jckj.biz.config.ProjectConfig;
import com.geoway.jckj.biz.entity.SysUser;
import com.geoway.jckj.biz.entity.SysUserSecurity;
import com.geoway.jckj.biz.service.dev.unity.IUnityUserService;
import com.geoway.jckj.biz.service.login.ICaptchaService;
import com.geoway.jckj.biz.service.sys.SysUserSecurityService;
import com.geoway.sso.client.rpc.Result;
import com.geoway.sso.client.rpc.RpcAccessToken;
import com.geoway.sso.client.util.Oauth2Utils;
import com.geoway.sso.client.util.SessionUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u77ed\u4fe1\u9a8c\u8bc1\u767b\u5f55"})
@RestController
@RequestMapping(value={"/phoneLogin"})
public class PhoneLoginController {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="${SMS.url}")
    private String smsURL;
    @Value(value="${SMS.sysName}")
    private String sysName;
    private RedisTemplate<String, Object> redisTemplate = new RedisTemplate();
    @Autowired
    private ProjectConfig projectConfig;
    @Autowired
    private IUnityUserService sysUserService;
    @Autowired
    SysUserSecurityService sysUserSecurityService;
    @Autowired
    private ICaptchaService commonService;

    @ApiOperation(value="\u83b7\u53d6\u624b\u673a\u9a8c\u8bc1\u7801")
    @RequestMapping(value={"/getSmsCode"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase getSmsCode(HttpServletRequest request, String phoneNumber, String userSys) throws Exception {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        JSONObject json = null;
        if (phoneNumber == null || phoneNumber.equals("")) {
            return ResponseDataBase.error((String)"\u83b7\u53d6\u9a8c\u8bc1\u7801\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u8f93\u5165\u624b\u673a\u53f7\u7801\u4e3a\u7a7a\uff01");
        }
        List users = this.sysUserService.queryList("telEncrypt_EQ_" + AESUtils.encrypt((String)phoneNumber, (String)"FWAijk4A2Dwt2MKw"));
        if (users == null || users.size() == 0) {
            return ResponseDataBase.error((String)"\u6b64\u624b\u673a\u53f7\u7801\u672a\u6ce8\u518c");
        }
        String smmCode = PhoneLoginController.getRandomSmsCode();
        JSONObject jsonObject = this.sendMessage(phoneNumber, "WORK_APP", StringUtils.format((String)"\u3010{}\u3011\u60a8\u7684\u9a8c\u8bc1\u7801\u4e3a\uff1a{}\uff0c\u4e3a\u4e86\u4fdd\u8bc1\u60a8\u7684\u8d26\u6237\u5b89\u5168\uff0c\u8bf7\u52ff\u5411\u4efb\u4f55\u4eba\u63d0\u4f9b\u6b64\u9a8c\u8bc1\u7801\u3002\u611f\u8c22\u60a8\u4f7f\u7528{}\uff01", (Object[])new Object[]{this.sysName, smmCode, this.sysName}));
        if (jsonObject == null || !"ok".equalsIgnoreCase(jsonObject.getString("status"))) {
            return ResponseDataBase.error((String)jsonObject.getString("description"));
        }
        UUID uid = UUID.randomUUID();
        String uuid = uid.toString();
        Long timeStamp = System.currentTimeMillis();
        json = new JSONObject();
        json.put("verifyCode", (Object)smmCode);
        json.put("createTime", (Object)timeStamp);
        json.put("isVerifyed", (Object)false);
        json.put("left", (Object)3);
        json.put("uid", (Object)uuid);
        this.commonService.storeCaptcha(uuid, json.toString());
        responseDataBase.put((Object)"data", (Object)json);
        return responseDataBase;
    }

    @ApiOperation(value="\u6839\u636e\u624b\u673a\u53f7\u83b7\u53d6\u9a8c\u8bc1\u7801")
    @RequestMapping(value={"/getSmsCodeByPhone"}, method={RequestMethod.GET})
    public ResponseDataBase getSmsCode(String phoneNumber, String userSys) throws Exception {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        if (phoneNumber == null || phoneNumber.equals("")) {
            return ResponseDataBase.error((String)"\u83b7\u53d6\u9a8c\u8bc1\u7801\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u8f93\u5165\u624b\u673a\u53f7\u7801\u4e3a\u7a7a\uff01");
        }
        String smmCode = PhoneLoginController.getRandomSmsCode();
        UUID uid = UUID.randomUUID();
        String uuid = uid.toString();
        Long timeStamp = System.currentTimeMillis();
        JSONObject json = new JSONObject();
        json.put("verifyCode", (Object)smmCode);
        json.put("createTime", (Object)timeStamp);
        json.put("isVerifyed", (Object)false);
        json.put("left", (Object)3);
        json.put("uid", (Object)uuid);
        this.commonService.storeCaptcha(uuid, json.toString());
        responseDataBase.put((Object)"data", (Object)json);
        return responseDataBase;
    }

    @RequestMapping(value={"/loginBySmsCode.action"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @OpLog(name="\u79fb\u52a8\u7aef\u901a\u8fc7SM\u7801\u767b\u5f55", opType=OpLog.OpType.login)
    public LoginResponse loginBySmsCode(HttpServletRequest request, String phoneNumber, String verifyCode, @RequestParam(value="uid") String uid, String userSys) throws Exception {
        LoginResponse loginResponse = new LoginResponse();
        if (phoneNumber == null || phoneNumber.equals("")) {
            loginResponse.setMessage("\u624b\u673a\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            loginResponse.setStatus("FAILURE");
            return loginResponse;
        }
        if (verifyCode == null || verifyCode.equals("") || verifyCode.length() != 6) {
            loginResponse.setMessage("\u9a8c\u8bc1\u7801\u4e0d\u80fd\u4e3a\u7a7a,\u4e14\u957f\u5ea6\u5fc5\u987b\u662f6\u4f4d\uff01");
            loginResponse.setStatus("FAILURE");
            return loginResponse;
        }
        Pair<Boolean, String> pair = this.checkVerifySession(request, verifyCode, uid);
        if (!((Boolean)pair.getKey()).booleanValue()) {
            loginResponse.setStatus("FAILURE");
            loginResponse.setMessage((String)pair.getValue());
            return loginResponse;
        }
        List users = this.sysUserService.queryList("telEncrypt_EQ_" + AESUtils.encrypt((String)phoneNumber, (String)"FWAijk4A2Dwt2MKw"));
        if (users == null || users.size() == 0) {
            loginResponse.setMessage("\u6b64\u624b\u673a\u53f7\u7801\u672a\u6ce8\u518c");
            loginResponse.setStatus("FAILURE");
            return loginResponse;
        }
        SysUser loginUser = (SysUser)users.get(0);
        String userName = loginUser.getName();
        SysUserSecurity sysUserSecurity = (SysUserSecurity)this.sysUserSecurityService.getById((Serializable)((Object)loginUser.getId()));
        if (sysUserSecurity == null) {
            loginResponse.setMessage("\u67e5\u627e\u7528\u6237\u5bc6\u7801\u5931\u8d25");
            loginResponse.setStatus("FAILURE");
            return loginResponse;
        }
        String password = sysUserSecurity.getPassword();
        String userAccout = loginUser.getName();
        Result results = Oauth2Utils.getAccessToken((String)this.projectConfig.getSsoServerUrl(), (String)this.projectConfig.getSsoAppId(), (String)this.projectConfig.getSsoAppSecret(), (String)userAccout, (String)password, (String)phoneNumber);
        if (ObjectUtil.isNotNull((Object)results) && results.isSuccess()) {
            RpcAccessToken rpcAccessToken = (RpcAccessToken)results.getData();
            SessionUtils.setAccessToken((HttpServletRequest)request, (RpcAccessToken)rpcAccessToken);
            loginResponse.setStatus("OK");
            loginResponse.setMessage("\u767b\u9646\u6210\u529f");
            loginResponse.setAlisName(loginUser.getAname());
            loginResponse.setUserName(loginUser.getName());
            loginResponse.setUserId(loginUser.getId());
            loginResponse.setToken(rpcAccessToken.getAccessToken());
            loginResponse.setRefreshToken(rpcAccessToken.getRefreshToken());
            loginResponse.setUserCatalog(loginUser.getCatalog() + "");
            loginResponse.setValidateType("sso");
            return loginResponse;
        }
        loginResponse.setMessage("\u767b\u5f55\u5931\u8d25");
        loginResponse.setStatus("FAILURE");
        return loginResponse;
    }

    private static String getRandomSmsCode() {
        return (int)((Math.random() * 9.0 + 1.0) * 100000.0) + "";
    }

    private JSONObject sendMessage(String phones, String customId, String content) {
        HashMap<String, String> map = new HashMap<String, String>(8);
        map.put("phones", phones);
        map.put("customId", customId);
        map.put("content", content);
        this.logger.info("\u53d1\u9001\u7684\u624b\u673a\u53f7:{},\u53d1\u9001\u7684\u5185\u5bb9:{}", (Object)phones, (Object)content);
        String post = HttpUtil.post((String)(this.smsURL + "/sms"), map);
        return JSONObject.parseObject((String)post);
    }

    private Pair<Boolean, String> checkVerifySession(HttpServletRequest request, String verifyCode, String uid) {
        Pair result = null;
        long SMS_CODE_OUT_DATE = 300000L;
        String smsCodeObj = this.commonService.queryCaptcha(uid);
        JSONObject smsCodeJson = null;
        if (smsCodeObj != null) {
            smsCodeJson = JSON.parseObject((String)smsCodeObj.toString());
            int left = smsCodeJson.getIntValue("left");
            if (left <= 0) {
                result = new Pair((Object)false, (Object)"\u9a8c\u8bc1\u7801\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u53d1\u9001\u9a8c\u8bc1\u7801\uff01");
                return result;
            }
            if (System.currentTimeMillis() - Long.parseLong(smsCodeJson.getString("createTime")) > 300000L) {
                result = new Pair((Object)false, (Object)"\u9a8c\u8bc1\u7801\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u53d1\u9001\u9a8c\u8bc1\u7801\uff01");
                return result;
            }
            if (!verifyCode.equalsIgnoreCase(smsCodeJson.getString("verifyCode"))) {
                smsCodeJson.put("left", (Object)(--left));
                this.commonService.storeCaptcha(uid, smsCodeJson.toString());
                result = new Pair((Object)false, (Object)"\u9a8c\u8bc1\u7801\u9519\u8bef\uff0c\u8bf7\u91cd\u8bd5\uff01");
                return result;
            }
            smsCodeJson.put("isVerifyed", (Object)true);
            this.commonService.storeCaptcha(uid, smsCodeJson.toString());
            result = new Pair((Object)true, (Object)"\u9a8c\u8bc1\u6210\u529f\uff01");
            return result;
        }
        result = new Pair((Object)false, (Object)"\u9a8c\u8bc1\u7801\u9519\u8bef\uff01");
        return result;
    }
}

