/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.jckj.api.controller;

import com.geoway.jckj.base.base.dto.ResponseDataBase;
import com.geoway.jckj.biz.annotation.OpLog;
import com.geoway.jckj.biz.annotation.RequireAuth;
import com.geoway.jckj.biz.constant.RoleLevel;
import com.geoway.jckj.biz.entity.SysTenant;
import com.geoway.jckj.biz.entity.SysTenantMenu;
import com.geoway.jckj.biz.service.sys.SysTenantMenuService;
import com.geoway.jckj.biz.service.sys.SysTenantOrganizationService;
import com.geoway.jckj.biz.service.sys.SysTenantRegionService;
import com.geoway.jckj.biz.service.sys.SysTenantService;
import com.geoway.jckj.biz.service.sys.SysTenantSpaceService;
import com.geoway.jckj.biz.service.sys.SysTenantSystemService;
import com.geoway.jckj.biz.service.sys.SysUserTenantService;
import com.geoway.sso.client.util.CommonLoginUserUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u79df\u6237\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/tenant"})
@RequireAuth(roleLevel=RoleLevel.superAdmin)
public class SysTenantController {
    @Autowired
    private SysTenantService sysTenantService;
    @Autowired
    private SysUserTenantService sysUserTenantService;
    @Autowired
    private SysTenantSystemService sysTenantSystemService;
    @Autowired
    private SysTenantMenuService sysTenantMenuService;
    @Autowired
    private SysTenantRegionService sysTenantRegionService;
    @Autowired
    private SysTenantOrganizationService sysTenantOrganizationService;
    @Autowired
    private SysTenantSpaceService sysTenantSpaceService;

    @ApiOperation(value="\u4fdd\u5b58\u79df\u6237")
    @OpLog(name="\u4fdd\u5b58\u79df\u6237", opType=OpLog.OpType.add)
    @RequestMapping(value={"/saveOrUp"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase save(SysTenant sysTenant) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        this.sysTenantService.saveOrUp(sysTenant);
        return responseDataBase;
    }

    @ApiOperation(value="\u5220\u9664\u79df\u6237")
    @OpLog(name="\u5220\u9664\u79df\u6237", opType=OpLog.OpType.del)
    @RequestMapping(value={"/delete"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase delete(@RequestParam String id) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        this.sysTenantService.delete(id);
        return responseDataBase;
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u79df\u6237(\u5305\u62ec\u7ba1\u7406\u7684\u9879)")
    @RequestMapping(value={"/queryPage"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase queryPage(@RequestParam(value="filterParam", required=false) String filterParam, @RequestParam(value="page") Integer page, @RequestParam(value="size") Integer size) throws Exception {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        responseDataBase.put((Object)"data", (Object)this.sysTenantService.queryPage(filterParam, page, size));
        return responseDataBase;
    }

    @ApiOperation(value="\u65b0\u589e\u79df\u6237\u4eba\u5458")
    @OpLog(name="\u65b0\u589e\u4e1a\u52a1\u4eba\u5458", opType=OpLog.OpType.update)
    @RequestMapping(value={"/addTenantUsers"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase addTenantUsers(@RequestParam String userIds, @RequestParam String tenantId, @RequestParam Integer isAdmin) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        this.sysUserTenantService.bindUsers(userIds, tenantId, isAdmin);
        return responseDataBase;
    }

    @ApiOperation(value="\u5220\u9664\u79df\u6237\u4eba\u5458")
    @OpLog(name="\u5220\u9664\u4e1a\u52a1\u4eba\u5458", opType=OpLog.OpType.del)
    @RequestMapping(value={"/deleteTenantUsers"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase deleteTenantUsers(@RequestParam String tenantId, @RequestParam String userIds) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        this.sysUserTenantService.removeBindUsers(tenantId, userIds);
        return responseDataBase;
    }

    @RequireAuth(roleLevel=RoleLevel.commonUser)
    @ApiOperation(value="\u83b7\u53d6\u5f53\u524d\u7528\u6237\u7ba1\u7406\u7684\u6240\u6709\u79df\u6237\u7a7a\u95f4")
    @RequestMapping(value={"/getTenants"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase queryTenants() {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        String userId = CommonLoginUserUtil.getUserId();
        List sysTenants = this.sysTenantService.queryByUserId(userId);
        responseDataBase.put((Object)"data", (Object)sysTenants);
        return responseDataBase;
    }

    @ApiOperation(value="\u5173\u8054\u7cfb\u7edf")
    @OpLog(name="\u5173\u8054\u7cfb\u7edf", opType=OpLog.OpType.update)
    @RequestMapping(value={"/bindSystems"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase bindSystem(@RequestParam String tenantId, @RequestParam String systemIds) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        this.sysTenantSystemService.bindSystems(tenantId, systemIds);
        return responseDataBase;
    }

    @ApiOperation(value="\u5173\u8054\u7cfb\u7edf")
    @OpLog(name="\u5173\u8054\u7cfb\u7edf", opType=OpLog.OpType.update)
    @RequestMapping(value={"/bindMenus"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase bindMenu(@RequestParam String tenantId, @RequestParam String systemId, @RequestBody List<SysTenantMenu> menus) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        this.sysTenantMenuService.bindMenus(tenantId, systemId, menus);
        return responseDataBase;
    }

    @ApiOperation(value="\u5173\u8054\u8f96\u533a")
    @OpLog(name="\u5173\u8054\u8f96\u533a", opType=OpLog.OpType.update)
    @RequestMapping(value={"/bindRegions"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase bindRegions(@RequestParam String tenantId, @RequestParam String regionIds) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        this.sysTenantRegionService.bindRegions(tenantId, regionIds);
        return responseDataBase;
    }

    @ApiOperation(value="\u5173\u8054\u7ec4\u7ec7")
    @OpLog(name="\u5173\u8054\u7ec4\u7ec7", opType=OpLog.OpType.update)
    @RequestMapping(value={"/bindOrgs"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase bindOrgs(@RequestParam String tenantId, @RequestParam String orgIds) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        this.sysTenantOrganizationService.bindOrgs(tenantId, orgIds);
        return responseDataBase;
    }

    @ApiOperation(value="\u79fb\u9664\u5173\u8054\u7cfb\u7edf")
    @OpLog(name="\u79fb\u9664\u5173\u8054\u7cfb\u7edf", opType=OpLog.OpType.update)
    @RequestMapping(value={"/removeBindSystems"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase removeBindSystems(@RequestParam String tenantId, @RequestParam String systemIds) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        this.sysTenantSystemService.removeBindSystems(tenantId, systemIds);
        return responseDataBase;
    }

    @ApiOperation(value="\u67e5\u8be2\u7ba1\u7406\u7684\u7cfb\u7edf")
    @OpLog(name="\u67e5\u8be2\u7ba1\u7406\u7684\u7cfb\u7edf", opType=OpLog.OpType.update)
    @RequestMapping(value={"/systems"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase queryBindSystems(@RequestParam String tenantId) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        List systems = this.sysTenantSystemService.queryBindSystems(tenantId);
        responseDataBase.put((Object)"data", (Object)systems);
        return responseDataBase;
    }

    @ApiOperation(value="\u67e5\u8be2\u7ba1\u7406\u7684\u83dc\u5355")
    @OpLog(name="\u67e5\u8be2\u7ba1\u7406\u7684\u83dc\u5355", opType=OpLog.OpType.update)
    @RequestMapping(value={"/menus"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase queryBindMenus(@RequestParam String tenantId, @RequestParam String systemId) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        List systems = this.sysTenantMenuService.queryBindMenus(tenantId, systemId);
        responseDataBase.put((Object)"data", (Object)systems);
        return responseDataBase;
    }

    @ApiOperation(value="\u67e5\u8be2\u7ba1\u7406\u7684\u8f96\u533a")
    @OpLog(name="\u67e5\u8be2\u7ba1\u7406\u7684\u8f96\u533a", opType=OpLog.OpType.update)
    @RequestMapping(value={"/regions"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase queryBindRegions(@RequestParam String tenantId) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        List regions = this.sysTenantRegionService.queryBindRegions(tenantId);
        responseDataBase.put((Object)"data", (Object)regions);
        return responseDataBase;
    }

    @ApiOperation(value="\u521b\u5efa\u79df\u6237\u7a7a\u95f4")
    @OpLog(name="\u521b\u5efa\u79df\u6237\u7a7a\u95f4", opType=OpLog.OpType.update)
    @RequestMapping(value={"/createTenantSpace"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase createTenantSpace(String tenantId, String systemId) {
        if (this.sysTenantSpaceService.createTenantSpace(tenantId, systemId)) {
            return ResponseDataBase.ok();
        }
        return ResponseDataBase.error((String)"\u521b\u5efa\u79df\u6237\u7a7a\u95f4\u5931\u8d25");
    }

    @RequestMapping(value={"/createSpace"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase createSpace(String tenen) {
        return ResponseDataBase.ok();
    }
}

