/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.jckj.api.config;

import cn.hutool.cron.CronUtil;
import cn.hutool.cron.task.Task;
import com.geoway.jckj.base.config.SsoConfigProp;
import com.geoway.jckj.biz.service.dev.unity.IUnityUserSyncService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Component;

@Component
public class UserSyncConfig {
    private static final Logger log = LoggerFactory.getLogger(UserSyncConfig.class);
    @Value(value="${sso.userSync.cron:0 0/10 * * * *}")
    private String cron;
    @Value(value="${sso.userSync.enable:false}")
    private boolean enable;
    @Autowired
    private SsoConfigProp ssoConfigProp;
    @Autowired
    private IUnityUserSyncService unityUserSyncService;

    @Bean
    public void syncUser() {
        if (!this.enable) {
            return;
        }
        CronUtil.schedule((String)this.cron, (Task)new Task(){

            public void execute() {
                UserSyncConfig.this.unityUserSyncService.syncUserInfo();
            }
        });
        CronUtil.setMatchSecond((boolean)true);
        CronUtil.start((boolean)true);
    }
}

