/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.jckj.api.controller;

import cn.hutool.core.bean.BeanUtil;
import com.geoway.jckj.base.base.dto.ResponseDataBase;
import com.geoway.jckj.biz.annotation.OpLog;
import com.geoway.jckj.biz.annotation.RequireAuth;
import com.geoway.jckj.biz.dto.SysMenuDTO;
import com.geoway.jckj.biz.entity.SysMenu;
import com.geoway.jckj.biz.service.sys.SysMenuService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u83dc\u5355\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/menu"})
@RequireAuth
public class SysMenuController {
    @Autowired
    private SysMenuService menuSysService;

    @ApiOperation(value="\u65b0\u589e\u6216\u4fee\u6539\u83dc\u5355\u4fe1\u606f")
    @OpLog(name="\u65b0\u589e\u6216\u4fee\u6539\u83dc\u5355\u4fe1\u606f", opType=OpLog.OpType.update)
    @RequestMapping(value={"/saveOrUp"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase saveOrUp(@Valid SysMenuDTO sysMenuDTO) throws Exception {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        SysMenu menuSys = new SysMenu();
        BeanUtil.copyProperties((Object)sysMenuDTO, (Object)menuSys, (String[])new String[0]);
        this.menuSysService.saveOrUp(menuSys);
        return responseDataBase;
    }

    @ApiOperation(value="\u67e5\u8be2\u6811\u7ed3\u6784")
    @RequestMapping(value={"/queryTree"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase queryTree(HttpServletRequest request, @RequestParam(value="systemId", required=true) String systemId, @RequestParam(value="group", required=true) Integer group) throws Exception {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        List menuSys = this.menuSysService.queryMenuTree(systemId, group);
        responseDataBase.put((Object)"data", (Object)menuSys);
        return responseDataBase;
    }

    @ApiOperation(value="\u5220\u9664")
    @OpLog(name="\u5220\u9664\u83dc\u5355\u4fe1\u606f", opType=OpLog.OpType.del)
    @RequestMapping(value={"/delete"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase delete(String id) throws Exception {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        this.menuSysService.deleteMenu(id);
        return responseDataBase;
    }

    @ApiOperation(value="\u6392\u5e8f\u7f6e\u6362")
    @RequestMapping(value={"/sortUp"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase sortUp(Integer flag, String id, String pid, String systemId, Integer sort) throws Exception {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        this.menuSysService.sortUp(flag, id, pid, systemId, sort);
        return responseDataBase;
    }

    @ApiOperation(value="\u9ed8\u8ba4\u8bbe\u7f6e")
    @OpLog(name="\u4fee\u6539\u9ed8\u8ba4\u83dc\u5355", opType=OpLog.OpType.update)
    @RequestMapping(value={"/updateDefault"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase updateDefault(String menuId) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        this.menuSysService.setDefault(menuId);
        return responseDataBase;
    }

    @ApiOperation(value="\u6839\u636e\u83dc\u5355\u5173\u952e\u5b57\u83b7\u53d6\u83dc\u5355\u4fe1\u606f")
    @RequestMapping(value={"/queryMenuByKey"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase queryMenuByKey(String menuKey, String systemId) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        SysMenu menuSys = this.menuSysService.queryMenuByKey(menuKey, systemId);
        responseDataBase.put((Object)"data", (Object)menuSys);
        return responseDataBase;
    }

    @ApiOperation(value="\u8bbe\u7f6e\u83dc\u5355\u662f\u5426\u8d44\u6e90\u9694\u79bb")
    @OpLog(name="\u8bbe\u7f6e\u83dc\u5355\u662f\u5426\u8d44\u6e90\u9694\u79bb", opType=OpLog.OpType.update)
    @RequestMapping(value={"/updateIsolate"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase updateIsolate(String menuId, String tenantId, Integer flag) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        this.menuSysService.setIsolate(menuId, tenantId, flag > 0);
        return responseDataBase;
    }

    @ApiOperation(value="\u67e5\u8be2\u7528\u6237\u6240\u5c5e\u7cfb\u7edf\u7684\u83dc\u5355\u4fe1\u606f")
    @RequestMapping(value={"/userMenus"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase queryuserMenus(String userId, String systemId) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        HashMap menuSys = this.menuSysService.queryUserSystemMenus(systemId);
        responseDataBase.put((Object)"data", (Object)menuSys);
        return responseDataBase;
    }

    @ApiOperation(value="\u6839\u636eid\u67e5\u8be2")
    @RequestMapping(value={"/findOne"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase findOne(@RequestParam(value="id", required=true) String id) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        SysMenu menuSys = (SysMenu)this.menuSysService.getById((Serializable)((Object)id));
        responseDataBase.put((Object)"data", (Object)menuSys);
        return responseDataBase;
    }
}

