/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.jckj.api.controller;

import cn.hutool.core.util.StrUtil;
import com.geoway.jckj.base.base.dto.ResponseDataBase;
import com.geoway.jckj.biz.service.dev.unity.IUnityLoginService;
import com.geoway.jckj.biz.service.login.ISsoAppService;
import com.geoway.jckj.biz.service.login.ISysLoginService;
import com.geoway.sso.client.annotation.OpLog;
import com.geoway.sso.client.enums.OpTypeEnum;
import com.geoway.sso.client.rpc.Result;
import com.geoway.sso.client.rpc.SsoUser;
import com.geoway.sso.client.util.CommonLoginUserUtil;
import com.geoway.sso.server.config.PropertyConfig;
import com.geoway.sso.server.session.CodeManager;
import com.geoway.sso.server.session.SessionManager;
import com.google.code.kaptcha.impl.DefaultKaptcha;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import springfox.documentation.annotations.ApiIgnore;

@Api(tags={"\u7528\u6237\u767b\u9646"})
@Controller
@RequestMapping(value={"/login"})
public class LoginController {
    @Autowired
    private DefaultKaptcha defaultKaptcha;
    @Autowired
    private ISysLoginService loginService;
    @Autowired
    PropertyConfig propertyConfig;
    @Autowired
    private CodeManager codeManager;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private ISsoAppService ssoAppService;
    @Autowired
    private IUnityLoginService ssoUserService;

    @ApiOperation(value="\u67e5\u8be2\u7cfb\u7edflogo")
    @RequestMapping(value={"/findLogo"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public ResponseDataBase findLogo(HttpServletRequest request, @RequestParam(value="filterParam", required=true) String filterParam) {
        ResponseDataBase response = new ResponseDataBase();
        response.put((Object)"data", null);
        return response;
    }

    @ApiOperation(value="\u56fe\u7247\u683c\u5f0f\u9a8c\u8bc1\u7801")
    @GetMapping(value={"/captchaPNG.action"})
    protected void captchaPNG(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.ssoUserService.createCaptchaPng(req, resp);
    }

    @ApiOperation(value="\u6587\u672c\u683c\u5f0f\u9a8c\u8bc1\u7801")
    @GetMapping(value={"/captchaText.action"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public ResponseDataBase captchaText(HttpServletRequest req, HttpServletResponse resp) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        responseDataBase.put((Object)"data", (Object)this.ssoUserService.createCaptchaText(req));
        return responseDataBase;
    }

    @ApiOperation(value="\u767b\u9646\u9a8c\u8bc1\u63a5\u53e3")
    @OpLog(name="\u7cfb\u7edf\u767b\u5f55", opType=OpTypeEnum.login)
    @RequestMapping(value={"/rest/login"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public ResponseDataBase restLogin(HttpServletRequest request, @RequestParam(value="username") String username, @RequestParam(value="password") String password, @RequestParam(value="code") String code, @RequestParam(value="uid") String uid) {
        ResponseDataBase response = new ResponseDataBase();
        response = this.loginService.checkLogin(username, password, uid, code, request);
        return response;
    }

    @ApiOperation(value="App\u7aef\u7528\u6237\u767b\u5f55")
    @OpLog(name="App\u7aef\u7528\u6237\u767b\u5f55", opType=OpTypeEnum.login)
    @RequestMapping(value={"/rest/app/login"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public ResponseDataBase restAppLogin(HttpServletRequest request, @RequestParam(value="username") String username, @RequestParam(value="password") String password) {
        ResponseDataBase response = new ResponseDataBase();
        response = this.loginService.checkLogin(username, password, request);
        return response;
    }

    @RequestMapping(value={"/islogin"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    @ApiIgnore
    public Result islogin(HttpServletRequest request, HttpServletResponse response) {
        String code = request.getParameter("code");
        if (code != null) {
            Result tokenResult = this.loginService.getAccessTokenByCode(code, request);
            return tokenResult;
        }
        return Result.createSuccess();
    }

    @ApiOperation(value="\u8df3\u8f6c\u5230\u5355\u70b9\u767b\u5f55\u9875\u9762")
    @RequestMapping(value={"/redirectlogin"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public ResponseDataBase redirectlogin(String redirectUri) {
        ResponseDataBase responseData = new ResponseDataBase();
        String url = this.loginService.redirectToSsoLogin(redirectUri);
        responseData.put((Object)"loginUrl", (Object)url);
        return responseData;
    }

    @ApiOperation(value="\u9000\u51fa\u767b\u5f55")
    @OpLog(name="\u9000\u51fa\u767b\u5f55", opType=OpTypeEnum.loginout)
    @RequestMapping(value={"/rest/logout"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public ResponseDataBase logout(HttpServletRequest request) {
        String token = CommonLoginUserUtil.getToken();
        if (StrUtil.isEmpty((CharSequence)token)) {
            return ResponseDataBase.error((String)"token\u4e3a\u7a7a");
        }
        if (this.ssoUserService.loginOut(request, token)) {
            return ResponseDataBase.ok();
        }
        return ResponseDataBase.error((String)"\u9000\u51fa\u5931\u8d25");
    }

    @ApiOperation(value="\u5355\u70b9\u9000\u51fa")
    @OpLog(name="\u5355\u70b9\u767b\u5f55\u9000\u51fa", opType=OpTypeEnum.loginout)
    @RequestMapping(value={"/ssoLogout"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public ResponseDataBase ssoLogout(HttpServletRequest request, String redirectUri) {
        ResponseDataBase responseData = new ResponseDataBase();
        String url = this.loginService.getSsoLogoutUrl(redirectUri, request);
        responseData.put((Object)"logoutUrl", (Object)url);
        return responseData;
    }

    @RequestMapping(method={RequestMethod.GET})
    @ApiIgnore
    public String login(@RequestParam(value="redirectUri", required=true) String redirectUri, @RequestParam(value="appId", required=true) String appId, HttpServletRequest request) throws UnsupportedEncodingException {
        String tgt = this.sessionManager.getTgt(request);
        if (StringUtils.isEmpty((CharSequence)tgt)) {
            request.setAttribute("errorMessage", (Object)"");
            return this.goLoginPath(redirectUri, appId, request);
        }
        return this.generateCodeAndRedirect(redirectUri, tgt);
    }

    @ApiOperation(value="\u9a8c\u8bc1\u7528\u6237\u662f\u5426\u5728\u7ebf\u63a5\u53e3")
    @OpLog(name="\u7cfb\u7edf\u767b\u5f55", opType=OpTypeEnum.login)
    @RequestMapping(value={"/rest/islogin"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public ResponseDataBase userIsLogin(HttpServletRequest request, @RequestParam(value="username") String username, @RequestParam(value="password") String password) {
        ResponseDataBase response = new ResponseDataBase();
        response = this.loginService.checkOnline(username, password);
        return response;
    }

    @RequestMapping(method={RequestMethod.POST})
    @OpLog(name="SSO\u767b\u5f55", opType=OpTypeEnum.login)
    @ApiIgnore
    public String login(@RequestParam(value="redirectUri", required=true) String redirectUri, @RequestParam(value="appId", required=true) String appId, @RequestParam String username, @RequestParam String password, @RequestParam(value="tel", required=false, defaultValue="") String tel, @RequestParam String vertifycode, @RequestParam String uid, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (!this.ssoAppService.exists(appId)) {
            request.setAttribute("errorMessage", (Object)"\u975e\u6cd5\u5e94\u7528");
            return this.goLoginPath(redirectUri, appId, request);
        }
        Result result = this.ssoUserService.login(username, password, tel, uid, vertifycode, request);
        if (!result.isSuccess()) {
            request.setAttribute("errorMessage", (Object)result.getMessage());
            return this.goLoginPath(redirectUri, appId, request);
        }
        String tgt = this.sessionManager.setUser((SsoUser)result.getData(), request, response);
        return this.generateCodeAndRedirect(redirectUri, tgt);
    }

    private String goLoginPath(String redirectUri, String appId, HttpServletRequest request) {
        request.setAttribute("redirectUri", (Object)redirectUri);
        request.setAttribute("appId", (Object)appId);
        return this.propertyConfig.getLoginPath();
    }

    private String generateCodeAndRedirect(String redirectUri, String tgt) throws UnsupportedEncodingException {
        String code = this.codeManager.generate(tgt, true, redirectUri);
        return "redirect:" + this.authRedirectUri(redirectUri, code);
    }

    private String authRedirectUri(String redirectUri, String code) throws UnsupportedEncodingException {
        StringBuilder sbf = new StringBuilder(redirectUri);
        if (redirectUri.indexOf("?") > -1) {
            sbf.append("&");
        } else {
            sbf.append("?");
        }
        sbf.append("code").append("=").append(code);
        return URLDecoder.decode(sbf.toString(), "utf-8");
    }
}

