/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.jckj.api.controller.uisapi;

import com.geoway.jckj.base.base.dto.ResponseDataBase;
import com.geoway.jckj.biz.service.oauth2.IOauth2Service;
import com.geoway.jckj.biz.service.uis.IUISService;
import com.geoway.sso.client.annotation.RequireAuth;
import com.geoway.sso.client.enums.RoleLevelEnum;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u4effUIS1.0\u7528\u6237\u4fe1\u606f\u67e5\u8be2\u63a5\u53e3"})
@RestController
@RequestMapping(value={"/rest"})
public class CommonRestController {
    @Autowired
    private IUISService uisService;
    @Autowired
    IOauth2Service oauth2Service;

    @ApiOperation(value="\u7528\u6237\u67e5\u8be2")
    @RequestMapping(value={"/user/getUserInfo", "/user/getSimpleUserInfo"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase getUserInfo(String token, String userId, String userSys, HttpServletRequest request) throws Exception {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        List arrayList = this.uisService.getUserInfo(token, userId, userSys);
        responseDataBase.put((Object)"data", (Object)arrayList);
        return responseDataBase;
    }

    @RequireAuth(roleLevel=RoleLevelEnum.tenantAdmin)
    @ApiOperation(value="\u7528\u6237\u4fee\u6539")
    @RequestMapping(value={"/user/modify"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase modify(String id, String password, String userSys) {
        this.uisService.modifyUserInfo(id, password, userSys);
        return ResponseDataBase.ok();
    }

    @RequireAuth(roleLevel=RoleLevelEnum.tenantAdmin)
    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u5217\u8868")
    @RequestMapping(value={"/user/getUserList"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase getUserList(String filterParam, String userSys) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        try {
            List simpleUserList = this.uisService.getUserList(filterParam, userSys);
            responseDataBase.put((Object)"data", (Object)simpleUserList);
        }
        catch (Exception ex) {
            return ResponseDataBase.error((String)ex.getMessage());
        }
        return responseDataBase;
    }

    @ApiOperation(value="\u67e5\u8be2\u673a\u6784\u76ee\u5f55\u6811")
    @RequireAuth(roleLevel=RoleLevelEnum.tenantAdmin)
    @RequestMapping(value={"/org/getOrgTree"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase getOrgTree(String pid) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        List organizationList = this.uisService.getOrgTree(pid);
        responseDataBase.put((Object)"data", (Object)organizationList);
        return responseDataBase;
    }

    @ApiOperation(value="\u67e5\u8be2\u673a\u6784\u4fe1\u606f")
    @RequireAuth(roleLevel=RoleLevelEnum.tenantAdmin)
    @RequestMapping(value={"/org/getOrgInfo"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase getOrgInfo(String pid) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        try {
            List orgList = this.uisService.getOrgInfo(pid);
            responseDataBase.put((Object)"data", (Object)orgList);
        }
        catch (Exception e) {
            ResponseDataBase.error((String)e.getMessage());
        }
        return responseDataBase;
    }

    @ApiOperation(value="\u83b7\u53d6\u89d2\u8272\u6811\u5217\u8868")
    @RequireAuth(roleLevel=RoleLevelEnum.tenantAdmin)
    @RequestMapping(value={"/role/queryTree"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase queryRoleTree(String filterParam) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        try {
            List roleTree = this.uisService.queryRoleTree(filterParam);
            responseDataBase.put((Object)"data", (Object)roleTree);
        }
        catch (Exception e) {
            responseDataBase = ResponseDataBase.error((String)e.getMessage());
        }
        return responseDataBase;
    }

    @ApiOperation(value="\u83b7\u53d6\u89d2\u8272\u5217\u8868")
    @RequireAuth(roleLevel=RoleLevelEnum.tenantAdmin)
    @RequestMapping(value={"/role/list"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase queryRoleList(String filterParam) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        try {
            List roles = this.uisService.queryRoleList(filterParam);
            responseDataBase.put((Object)"data", (Object)roles);
        }
        catch (Exception e) {
            responseDataBase = ResponseDataBase.error((String)e.getMessage());
        }
        return responseDataBase;
    }

    @ApiOperation(value="\u83b7\u53d6\u89d2\u8272\u5173\u8054\u7528\u6237")
    @RequireAuth(roleLevel=RoleLevelEnum.tenantAdmin)
    @RequestMapping(value={"/role/users"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase queryRoleUsers(String roleId) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        try {
            List users = this.uisService.queryRoleUsers(roleId);
            responseDataBase.put((Object)"data", (Object)users);
        }
        catch (Exception e) {
            responseDataBase = ResponseDataBase.error((String)e.getMessage());
        }
        return responseDataBase;
    }
}

