/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.jckj.api.controller.login;

import com.geoway.jckj.base.base.dto.LoginResponse;
import com.geoway.jckj.base.base.dto.ResponseDataBase;
import com.geoway.jckj.base.support.Pair;
import com.geoway.jckj.base.support.StringUtils;
import com.geoway.jckj.biz.dto.SmsCaptchaDTO;
import com.geoway.jckj.biz.entity.SysUser;
import com.geoway.jckj.biz.service.dev.base.ISmsService;
import com.geoway.jckj.biz.service.dev.unity.IUnityUserTelService;
import com.geoway.jckj.biz.service.login.ISmsCaptchaService;
import com.geoway.jckj.biz.service.login.ISysLoginService;
import com.geoway.sso.client.annotation.OpLog;
import com.geoway.sso.client.enums.OpTypeEnum;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u77ed\u4fe1\u9a8c\u8bc1\u767b\u5f55"})
@RestController
@RequestMapping(value={"/phoneLogin"})
public class PhoneLoginController {
    @Autowired
    private ISysLoginService sysLoginService;
    @Autowired
    private IUnityUserTelService unityUserTelService;
    @Autowired
    private ISmsCaptchaService smsCaptchaService;
    @Autowired
    private ISmsService smsService;
    @Value(value="${SMS.sysName}")
    private String sysName;

    @ApiOperation(value="\u83b7\u53d6\u624b\u673a\u9a8c\u8bc1\u7801")
    @RequestMapping(value={"/getSmsCode"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase getSmsCode(HttpServletRequest request, String phoneNumber, String userSys) throws Exception {
        if (phoneNumber == null || phoneNumber.equals("")) {
            return ResponseDataBase.error((String)"\u83b7\u53d6\u9a8c\u8bc1\u7801\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u8f93\u5165\u624b\u673a\u53f7\u7801\u4e3a\u7a7a\uff01");
        }
        SysUser user = this.unityUserTelService.query(phoneNumber);
        if (user == null) {
            return ResponseDataBase.error((String)"\u6b64\u624b\u673a\u53f7\u7801\u672a\u6ce8\u518c");
        }
        String smmCode = this.smsCaptchaService.createCaptcha(6);
        Pair result = this.smsService.sendMessage(phoneNumber, "WORK_APP", StringUtils.format((String)"\u3010{}\u3011\u60a8\u7684\u9a8c\u8bc1\u7801\u4e3a\uff1a{}\uff0c\u4e3a\u4e86\u4fdd\u8bc1\u60a8\u7684\u8d26\u6237\u5b89\u5168\uff0c\u8bf7\u52ff\u5411\u4efb\u4f55\u4eba\u63d0\u4f9b\u6b64\u9a8c\u8bc1\u7801\u3002\u611f\u8c22\u60a8\u4f7f\u7528{}\uff01", (Object[])new Object[]{this.sysName, smmCode, this.sysName}));
        if (((Boolean)result.getKey()).booleanValue()) {
            SmsCaptchaDTO smsCaptchaDTO = this.smsCaptchaService.storeCaptcha(UUID.randomUUID().toString(), smmCode);
            smsCaptchaDTO.setVerifyCode("");
            ResponseDataBase responseDataBase = new ResponseDataBase();
            responseDataBase.put((Object)"data", (Object)smsCaptchaDTO);
            return responseDataBase;
        }
        return ResponseDataBase.error((String)((String)result.getValue()));
    }

    @RequestMapping(value={"/loginBySmsCode.action"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @OpLog(name="\u79fb\u52a8\u7aef\u901a\u8fc7SM\u7801\u767b\u5f55", opType=OpTypeEnum.login)
    public LoginResponse loginBySmsCode(HttpServletRequest request, String phoneNumber, String verifyCode, @RequestParam(value="uid") String uid) throws Exception {
        return this.sysLoginService.checkLoginBySms(phoneNumber, uid, verifyCode, request);
    }
}

