/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.jckj.api.controller;

import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.geoway.jckj.base.base.dto.ResponseDataBase;
import com.geoway.jckj.biz.entity.SysOrganization;
import com.geoway.jckj.biz.service.dev.unity.IUnityOrganizationService;
import com.geoway.sso.client.annotation.OpLog;
import com.geoway.sso.client.annotation.RequireAuth;
import com.geoway.sso.client.enums.OpTypeEnum;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u7ec4\u7ec7\u7ed3\u6784\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/organization"})
@RequireAuth
public class SysOrganizationController {
    @Autowired
    private IUnityOrganizationService sysOrganizationService;

    @ApiOperation(value="\u65b0\u589e\u6216\u4fee\u6539")
    @OpLog(name="\u65b0\u589e\u6216\u4fee\u6539\u673a\u6784\u4fe1\u606f", opType=OpTypeEnum.update)
    @RequestMapping(value={"/save"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase saveOrUp(SysOrganization org) throws Exception {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        this.sysOrganizationService.saveOrUp(org);
        return responseDataBase;
    }

    @ApiOperation(value="\u6279\u91cf\u6dfb\u52a0\u90e8\u95e8")
    @RequestMapping(value={"/batchSave"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase batchSave(@RequestParam(value="jsonOrgs", required=true) String jsonOrgs) throws Exception {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        List orgs = JSONArray.parseArray((String)jsonOrgs, SysOrganization.class);
        this.sysOrganizationService.batchSave(orgs);
        return responseDataBase;
    }

    @ApiOperation(value="\u67e5\u8be2\u6811\u7ed3\u6784")
    @RequestMapping(value={"/queryTree"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase queryTree(@RequestParam(value="filterParam", required=false) String filterParam, @RequestParam(value="bindUser", defaultValue="false", required=false) Boolean bindUser) throws Exception {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        List orgTree = this.sysOrganizationService.queryTree(filterParam, bindUser.booleanValue());
        responseDataBase.put((Object)"data", (Object)orgTree);
        return responseDataBase;
    }

    @ApiOperation(value="\u6309\u673a\u6784ID\u67e5\u8be2\u5176\u4e0b\u7ea7\u673a\u6784\u6811")
    @RequestMapping(value={"/queryTreeById"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase queryTreeById(String id) throws Exception {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        List orgTree = this.sysOrganizationService.queryListById(id);
        responseDataBase.put((Object)"data", (Object)orgTree);
        return responseDataBase;
    }

    @ApiOperation(value="\u6839\u636e\u6761\u4ef6\u67e5\u8be2\u5217\u8868")
    @RequestMapping(value={"/queryList"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase queryList(String filterParam) throws Exception {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        List orgs = this.sysOrganizationService.queryList(filterParam);
        responseDataBase.put((Object)"data", (Object)orgs);
        return responseDataBase;
    }

    @ApiOperation(value="\u6839\u636e\u6761\u4ef6\u67e5\u8be2\u5217\u8868")
    @RequestMapping(value={"/queryPage"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase queryPage(@RequestParam(value="filterParam", required=false) String filterParam, @RequestParam(value="page", required=true) Integer page, @RequestParam(value="size", required=true) Integer size) throws Exception {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        IPage pages = this.sysOrganizationService.queryPage(filterParam, page.intValue(), size.intValue());
        responseDataBase.put((Object)"data", (Object)pages);
        return responseDataBase;
    }

    @ApiOperation(value="\u90e8\u95e8\u8be6\u7ec6\u4fe1\u606f")
    @RequestMapping(value={"/findOne"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase findOne(@RequestParam(value="id", required=true) String id, @RequestParam(value="filterParam", required=false) String filterParam) throws Exception {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        SysOrganization org = this.sysOrganizationService.findOneById(id, filterParam);
        responseDataBase.put((Object)"data", (Object)org);
        return responseDataBase;
    }

    @ApiOperation(value="\u5220\u9664")
    @OpLog(name="\u5220\u9664\u673a\u6784\u4fe1\u606f", opType=OpTypeEnum.del)
    @RequestMapping(value={"/delete"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase delete(String id) throws Exception {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        this.sysOrganizationService.batchDelete(id);
        return responseDataBase;
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664")
    @OpLog(name="\u5220\u9664\u673a\u6784\u4fe1\u606f", opType=OpTypeEnum.del)
    @RequestMapping(value={"/batchDelete"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase batchDelete(@RequestParam(value="ids", required=true) String ids) throws Exception {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        this.sysOrganizationService.batchDelete(ids);
        return responseDataBase;
    }

    @ApiOperation(value="\u4fee\u6539\u90e8\u95e8\u5173\u8054\u7684\u7528\u6237\u4fe1\u606f")
    @OpLog(name="\u4fee\u6539\u90e8\u95e8\u5173\u8054\u7684\u7528\u6237\u4fe1\u606f", opType=OpTypeEnum.add)
    @RequestMapping(value={"/addUser"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase addUser(@RequestParam(value="orgId", required=true) String orgId, @RequestParam(value="userId", required=true) String userId) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        this.sysOrganizationService.bindOneUser(orgId, userId);
        return responseDataBase;
    }

    @ApiOperation(value="\u4fee\u6539\u90e8\u95e8\u5173\u8054\u7684\u7528\u6237\u4fe1\u606f")
    @OpLog(name="\u4fee\u6539\u90e8\u95e8\u5173\u8054\u7684\u7528\u6237\u4fe1\u606f", opType=OpTypeEnum.update)
    @RequestMapping(value={"/bindUsers"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase bindUsers(@RequestParam(value="orgId", required=true) String orgId, @RequestParam(value="userIds", required=true) String userIds) throws Exception {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        this.sysOrganizationService.bindUsers(orgId, userIds);
        return responseDataBase;
    }

    @ApiOperation(value="\u79fb\u9664\u90e8\u95e8\u5173\u8054\u7684\u7528\u6237\u4fe1\u606f")
    @OpLog(name="\u79fb\u9664\u90e8\u95e8\u5173\u8054\u7684\u7528\u6237\u4fe1\u606f", opType=OpTypeEnum.del)
    @RequestMapping(value={"/removeUsers"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase removeUsers(@RequestParam(value="orgId", required=true) String orgId, @RequestParam(value="userIds", required=true) String userIds) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        this.sysOrganizationService.removeBindUser(orgId, userIds);
        return responseDataBase;
    }

    @ApiOperation(value="\u67e5\u8be2\u90e8\u95e8\u5173\u8054\u7684\u7528\u6237\u4fe1\u606f")
    @RequestMapping(value={"/users"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase queryRelUsers(@RequestParam(value="orgId", required=true) String orgId) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        List users = this.sysOrganizationService.queryRelUsers(orgId);
        responseDataBase.put((Object)"data", (Object)users);
        return responseDataBase;
    }

    @ApiOperation(value="\u67e5\u8be2\u90e8\u95e8\u5173\u8054\u7684\u7528\u6237\u4fe1\u606f\u5206\u9875")
    @RequestMapping(value={"/orgUsers"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase queryOrgUsers(@RequestParam(value="orgId", required=false) String orgId, @RequestParam(value="noOrgId", required=false) String noOrgId, @RequestParam(value="noRoleId", required=false) String noRoleId, @RequestParam(value="filterParam", required=false) String filterParam, @RequestParam(value="sortParam", required=false) String sortParam, @RequestParam(value="page", required=true) Integer page, @RequestParam(value="size", required=true) Integer size) throws Exception {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        IPage users = this.sysOrganizationService.queryOrgUsers(orgId, noOrgId, noRoleId, filterParam, sortParam, page.intValue(), size.intValue());
        responseDataBase.put((Object)"data", (Object)users);
        return responseDataBase;
    }

    @ApiOperation(value="\u67e5\u8be2\u6240\u6709\u5b50\u90e8\u95e8\u5173\u8054\u7684\u7528\u6237\u4fe1\u606f\u5206\u9875")
    @RequestMapping(value={"/allUsers"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase allUsers(@RequestParam(value="orgId", required=false) String orgId, @RequestParam(value="noOrgId", required=false) String noOrgId, @RequestParam(value="noRoleId", required=false) String noRoleId, @RequestParam(value="filterParam", required=false) String filterParam, @RequestParam(value="sortParam", required=false) String sortParam, @RequestParam(value="page", required=true) Integer page, @RequestParam(value="size", required=true) Integer size) throws Exception {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        IPage users = this.sysOrganizationService.queryAllRelUsers(orgId, noOrgId, noRoleId, filterParam, sortParam, page.intValue(), size.intValue());
        responseDataBase.put((Object)"data", (Object)users);
        return responseDataBase;
    }

    @ApiOperation(value="\u67e5\u8be2\u65e0\u7ec4\u7ec7\u7528\u6237\u5217\u8868")
    @RequestMapping(value={"/nonOrgUsers"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase nonOrgUsers() {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        List users = this.sysOrganizationService.queryNonOrgUsers();
        responseDataBase.put((Object)"data", (Object)users);
        return responseDataBase;
    }

    @ApiOperation(value="\u67e5\u8be2\u6570\u91cf")
    @RequestMapping(value={"/queryCount"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase queryCount(String filterParam) throws Exception {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        int count = this.sysOrganizationService.queryCount(filterParam);
        responseDataBase.put((Object)"data", (Object)count);
        return responseDataBase;
    }
}

