/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.jckj.api.controller.sso;

import com.geoway.jckj.api.controller.sso.SsoCheckLogin;
import com.geoway.jckj.base.base.dto.ResponseDataBase;
import com.geoway.jckj.biz.service.dev.unity.IUnityLoginService;
import com.geoway.jckj.biz.service.login.ISsoAppService;
import com.geoway.sso.client.annotation.OpLog;
import com.geoway.sso.client.enums.OpTypeEnum;
import com.geoway.sso.client.provider.RpcClientInfoProvider;
import com.geoway.sso.client.rpc.Result;
import com.geoway.sso.client.rpc.RpcAccessToken;
import com.geoway.sso.client.rpc.SsoUser;
import com.geoway.sso.client.util.Oauth2Utils;
import com.geoway.sso.client.util.SessionUtils;
import com.geoway.sso.server.config.PropertyConfig;
import com.geoway.sso.server.session.CodeManager;
import com.geoway.sso.server.session.SessionManager;
import io.swagger.annotations.ApiOperation;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import springfox.documentation.annotations.ApiIgnore;

public class SsoLoginController {
    @Autowired
    private ISsoAppService ssoAppService;
    @Autowired
    private PropertyConfig propertyConfig;
    @Autowired
    private CodeManager codeManager;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IUnityLoginService ssoUserService;
    @Autowired
    private RpcClientInfoProvider rpcClientInfoProvider;

    @RequestMapping(method={RequestMethod.POST})
    @OpLog(name="SSO\u767b\u5f55", opType=OpTypeEnum.login)
    @ApiIgnore
    public String login(@RequestParam(value="redirectUri", required=true) String redirectUri, @RequestParam(value="appId", required=true) String appId, @RequestParam String username, @RequestParam String password, @RequestParam String vertifycode, @RequestParam String uid, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (!this.ssoAppService.exists(appId)) {
            request.setAttribute("errorMessage", (Object)"\u975e\u6cd5\u5e94\u7528");
            return this.goLoginPath(redirectUri, appId, request);
        }
        Result result = this.ssoUserService.login(username, password, uid, vertifycode, request);
        if (!result.isSuccess()) {
            request.setAttribute("errorMessage", (Object)result.getMessage());
            return this.goLoginPath(redirectUri, appId, request);
        }
        String tgt = this.sessionManager.setUser((SsoUser)result.getData(), request, response);
        return this.generateCodeAndRedirect(redirectUri, tgt);
    }

    @RequestMapping(method={RequestMethod.GET})
    @ApiIgnore
    public String login(@RequestParam(value="redirectUri", required=true) String redirectUri, @RequestParam(value="appId", required=true) String appId, HttpServletRequest request) throws UnsupportedEncodingException {
        String tgt = this.sessionManager.getTgt(request);
        if (StringUtils.isEmpty((CharSequence)tgt)) {
            request.setAttribute("errorMessage", (Object)"");
            return this.goLoginPath(redirectUri, appId, request);
        }
        return this.generateCodeAndRedirect(redirectUri, tgt);
    }

    @ApiOperation(value="\u5355\u70b9\u9000\u51fa")
    @OpLog(name="\u5355\u70b9\u767b\u5f55\u9000\u51fa", opType=OpTypeEnum.loginout)
    @RequestMapping(value={"/ssoLogout"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public ResponseDataBase ssoLogout(HttpServletRequest request, String redirectUri) {
        ResponseDataBase responseData = new ResponseDataBase();
        SsoCheckLogin ssoCheckLogin = new SsoCheckLogin(this.rpcClientInfoProvider.getRpcClientInfo().getServerUrl());
        String url = ssoCheckLogin.userLogut(redirectUri, request);
        responseData.put((Object)"logoutUrl", (Object)url);
        return responseData;
    }

    private String goLoginPath(String redirectUri, String appId, HttpServletRequest request) {
        request.setAttribute("redirectUri", (Object)redirectUri);
        request.setAttribute("appId", (Object)appId);
        return this.propertyConfig.getLoginPath();
    }

    private String generateCodeAndRedirect(String redirectUri, String tgt) throws UnsupportedEncodingException {
        String code = this.codeManager.generate(tgt, true, redirectUri);
        return "redirect:" + this.authRedirectUri(redirectUri, code);
    }

    private String authRedirectUri(String redirectUri, String code) throws UnsupportedEncodingException {
        StringBuilder sbf = new StringBuilder(redirectUri);
        if (redirectUri.indexOf("?") > -1) {
            sbf.append("&");
        } else {
            sbf.append("?");
        }
        sbf.append("code").append("=").append(code);
        return URLDecoder.decode(sbf.toString(), "utf-8");
    }

    @RequestMapping(value={"/islogin"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    @ApiIgnore
    public Result islogin(HttpServletRequest request, HttpServletResponse response) {
        String code = request.getParameter("code");
        if (code != null) {
            Result<RpcAccessToken> tokenResult = this.getAccessTokenByCode(code, request);
            return tokenResult;
        }
        return Result.createSuccess();
    }

    private Result<RpcAccessToken> getAccessTokenByCode(String code, HttpServletRequest request) {
        Result result = Oauth2Utils.getAccessToken((String)this.rpcClientInfoProvider.getRpcClientInfo().getServerUrl(), (String)this.rpcClientInfoProvider.getRpcClientInfo().getAppId(), (String)this.rpcClientInfoProvider.getRpcClientInfo().getAppSecret(), (String)code);
        SessionUtils.setAccessToken((HttpServletRequest)request, (RpcAccessToken)((RpcAccessToken)result.getData()));
        return result;
    }
}

