/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.jckj.api.controller;

import cn.hutool.core.util.StrUtil;
import com.geoway.jckj.base.base.dto.ResponseDataBase;
import com.geoway.jckj.biz.dto.SystemInfoDTO;
import com.geoway.jckj.biz.entity.SysGroup;
import com.geoway.jckj.biz.entity.SysSystem;
import com.geoway.jckj.biz.service.sys.SysRoleMenuService;
import com.geoway.jckj.biz.service.sys.SysRoleService;
import com.geoway.jckj.biz.service.sys.SystemService;
import com.geoway.jckj.biz.util.PasswordUtil;
import com.geoway.sso.client.annotation.OpLog;
import com.geoway.sso.client.annotation.RequireAuth;
import com.geoway.sso.client.enums.OpTypeEnum;
import com.geoway.sso.client.enums.RoleLevelEnum;
import com.geoway.sso.client.util.CommonLoginUserUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(tags={"\u7cfb\u7edf\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/system"})
@RequireAuth
public class SysSystemContorller {
    @Autowired
    private SystemService sysSystemService;
    @Autowired
    private PasswordUtil passwordUtil;
    @Autowired
    private SysRoleMenuService sysRoleMenuService;
    @Autowired
    private SysRoleService sysRoleService;

    @ApiOperation(value="\u65b0\u589e\u6216\u4fee\u6539\u7cfb\u7edf\u4fe1\u606f")
    @OpLog(name="\u65b0\u589e\u6216\u4fee\u6539\u7cfb\u7edf\u4fe1\u606f", opType=OpTypeEnum.update)
    @RequestMapping(value={"/save"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase saveOrUp(SysSystem sysNsSystem, @RequestParam(value="logofile", required=false) MultipartFile logofile, @RequestParam(value="bgfile", required=false) MultipartFile bgfile) throws Exception {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        this.sysSystemService.saveOrUp(sysNsSystem, logofile, bgfile);
        return responseDataBase;
    }

    @ApiOperation(value="\u5220\u9664")
    @OpLog(name="\u5220\u9664\u7cfb\u7edf\u4fe1\u606f", opType=OpTypeEnum.del)
    @RequestMapping(value={"/delete"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase deleteInfo(@RequestParam(value="id", required=false) String id, @RequestParam(value="ids", required=false) String ids) throws Exception {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        String validIds = StrUtil.isBlank((CharSequence)ids) ? id : ids;
        this.sysSystemService.deleteSystems(validIds);
        return responseDataBase;
    }

    @RequireAuth(roleLevel=RoleLevelEnum.None)
    @ApiOperation(value="\u67e5\u8be2\u7cfb\u7edf\u76f8\u5173\u4fe1\u606f\u4ee5\u53ca\u83dc\u5355(\u6839\u636e\u6743\u9650\u8fc7\u6ee4)")
    @RequestMapping(value={"/queryInfoByKey"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase queryInfoByKey(HttpServletRequest request, String systemKey, String key, String tenantKey) throws Exception {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        SystemInfoDTO systemInfoDTO = this.sysSystemService.querySystemInfoByUser(StrUtil.isNotEmpty((CharSequence)key) ? key : systemKey);
        responseDataBase.put((Object)"data", (Object)systemInfoDTO);
        return responseDataBase;
    }

    @RequireAuth(roleLevel=RoleLevelEnum.commonUser)
    @ApiOperation(value="\u6839\u636e\u83dc\u5355id\u83b7\u53d6\u5b50\u529f\u80fd\u70b9\u4fe1\u606f")
    @RequestMapping(value={"/querySubFunctions"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase querySubFunctions(String menuId) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        List sysRoles = this.sysRoleService.queryUserRoles(CommonLoginUserUtil.getUserId());
        List subFunctions = this.sysRoleMenuService.queryRelateSubFunctions(sysRoles.stream().map(f -> f.getId()).collect(Collectors.joining(",")), menuId);
        responseDataBase.put((Object)"data", (Object)subFunctions);
        return responseDataBase;
    }

    @ApiOperation(value="\u67e5\u8be2\u7cfb\u7edf\u76f8\u5173\u4fe1\u606f\u4ee5\u53ca\u83dc\u5355(\u8fd4\u56de\u6240\u6709)")
    @RequestMapping(value={"/queryInfoByKey2"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase queryInfoByKey2(HttpServletRequest request, String key) throws Exception {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        SystemInfoDTO map = this.sysSystemService.queryInfo(key);
        responseDataBase.put((Object)"data", (Object)map);
        return responseDataBase;
    }

    @RequireAuth(roleLevel=RoleLevelEnum.commonUser)
    @ApiOperation(value="\u67e5\u8be2\u7528\u6237\u6388\u6743\u7684\u5e94\u7528\u5217\u8868")
    @RequestMapping(value={"/queryListByUser"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase queryListByUser(HttpServletRequest request, String userId) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        List systemList = this.sysSystemService.querySystemListByUser(userId);
        responseDataBase.put((Object)"data", (Object)systemList);
        return responseDataBase;
    }

    @ApiOperation(value="\u67e5\u8be2\u5217\u8868")
    @RequestMapping(value={"/queryList"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase queryList() throws Exception {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        List sysNSystems = this.sysSystemService.queryList();
        responseDataBase.put((Object)"data", (Object)sysNSystems);
        return responseDataBase;
    }

    @ApiOperation(value="\u67e5\u8be2\u7cfb\u7edf\u5217\u8868")
    @RequestMapping(value={"/queryListNotInRole"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase queryListNotInRole(@RequestParam(value="roleId", required=true) String roleId) throws Exception {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        List sysNSystems = this.sysSystemService.queryListNotInRole(roleId);
        responseDataBase.put((Object)"data", (Object)sysNSystems);
        return responseDataBase;
    }

    @ApiOperation(value="\u72b6\u6001\u542f\u7528")
    @OpLog(name="\u4fee\u6539\u7cfb\u7edf\u72b6\u6001", opType=OpTypeEnum.update)
    @RequestMapping(value={"/stateUp"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase stateUp(String id, Integer state) throws Exception {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        this.sysSystemService.stateUp(id, state);
        return responseDataBase;
    }

    @ApiOperation(value="\u67e5\u8be2\u6240\u6709\u4fe1\u606f")
    @RequestMapping(value={"/queryAll"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase queryAll() throws Exception {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        List sysNSystems = this.sysSystemService.queryAll();
        responseDataBase.put((Object)"data", (Object)sysNSystems);
        return responseDataBase;
    }

    @ApiOperation(value="\u67e5\u8be2\u52a0\u5bc6\u65b9\u5f0f")
    @RequestMapping(value={"/encryption"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase queryEncryption() throws Exception {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        responseDataBase.put((Object)"data", (Object)this.passwordUtil.getEncryptMethod());
        return responseDataBase;
    }

    @ApiOperation(value="\u65b0\u589e\u6216\u4fee\u6539\u7cfb\u7edf\u5206\u7ec4")
    @OpLog(name="\u65b0\u589e\u6216\u4fee\u6539\u7cfb\u7edf\u5206\u7ec4", opType=OpTypeEnum.update)
    @RequestMapping(value={"/saveGroup"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase saveGroup(SysGroup group) throws Exception {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        this.sysSystemService.saveGroup(group);
        return responseDataBase;
    }

    @ApiOperation(value="\u67e5\u8be2\u7cfb\u7edf\u5206\u7ec4")
    @RequestMapping(value={"/systemGroups"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase queryAppGroups(HttpServletRequest request) throws Exception {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        List groups = this.sysSystemService.queryGroupSystems();
        responseDataBase.put((Object)"data", (Object)groups);
        return responseDataBase;
    }

    @ApiOperation(value="\u5220\u9664\u5e94\u7528\u7ec4")
    @OpLog(name="\u5220\u9664\u5e94\u7528\u7ec4", opType=OpTypeEnum.del)
    @RequestMapping(value={"/deleteGroup"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase saveGroup(String groupId) throws Exception {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        this.sysSystemService.deleteGroup(groupId);
        return responseDataBase;
    }

    @ApiOperation(value="\u67e5\u8be2\u5e94\u7528\u83dc\u5355\u6811")
    @RequestMapping(value={"/queryAppMenuTree"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase queryAppMenuTree(HttpServletRequest request, String key) throws Exception {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        List appMenuTrees = this.sysSystemService.queryAppMenus(key);
        responseDataBase.put((Object)"data", (Object)appMenuTrees);
        return responseDataBase;
    }

    @ApiOperation(value="\u4fdd\u5b58\u7528\u6237\u5173\u8054\u7684\u83dc\u5355\u4fe1\u606f")
    @OpLog(name="\u4fdd\u5b58\u7528\u6237\u5173\u8054\u7684\u83dc\u5355\u4fe1\u606f", opType=OpTypeEnum.update)
    @RequestMapping(value={"/saveRoleSystem"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase saveRoleSystem(@RequestParam(value="id", required=true) String id, @RequestParam(value="roleIds", required=true) String roleIds, @RequestParam(value="menuIds", required=true) String menuIds) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        List<Object> roleIdList = new ArrayList();
        if (StrUtil.isNotBlank((CharSequence)roleIds)) {
            roleIdList = Arrays.asList(roleIds.split(","));
        }
        List<Object> menuIdList = new ArrayList();
        if (StrUtil.isNotBlank((CharSequence)menuIds)) {
            menuIdList = Arrays.asList(menuIds.split(","));
        }
        this.sysSystemService.saveRoleSystem(id, roleIdList, menuIdList);
        return responseDataBase;
    }
}

