/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.jckj.api.controller;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.geoway.jckj.base.base.dto.ResponseDataBase;
import com.geoway.jckj.biz.entity.SysRole;
import com.geoway.jckj.biz.service.sys.SysRoleMenuService;
import com.geoway.jckj.biz.service.sys.SysRoleService;
import com.geoway.jckj.biz.service.sys.SysRoleSubFunctionService;
import com.geoway.jckj.biz.service.sys.SysRoleSystemService;
import com.geoway.sso.client.annotation.OpLog;
import com.geoway.sso.client.annotation.RequireAuth;
import com.geoway.sso.client.enums.OpTypeEnum;
import com.geoway.sso.client.enums.RoleLevelEnum;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u89d2\u8272\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/role"})
@RequireAuth
public class SysRoleController {
    @Autowired
    private SysRoleService sysRoleService;
    @Autowired
    SysRoleSystemService sysRoleSystemService;
    @Autowired
    SysRoleMenuService sysRoleMenuService;
    @Autowired
    SysRoleSubFunctionService saveRoleSubFunctions;

    @ApiOperation(value="\u65b0\u589e\u6216\u4fee\u6539")
    @OpLog(name="\u65b0\u589e\u6216\u4fee\u6539\u89d2\u8272", opType=OpTypeEnum.update)
    @RequestMapping(value={"/save"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase saveOrUp(SysRole role) throws Exception {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        this.sysRoleService.saveOrUp(role);
        return responseDataBase;
    }

    @ApiOperation(value="\u67e5\u8be2\u6811\u7ed3\u6784")
    @RequestMapping(value={"/queryTree"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    @RequireAuth(roleLevel=RoleLevelEnum.bizAdmin)
    public ResponseDataBase queryTree(String filterParam) throws Exception {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        List roleTree = this.sysRoleService.queryTree(filterParam);
        responseDataBase.put((Object)"data", (Object)roleTree);
        return responseDataBase;
    }

    @ApiOperation(value="\u6839\u636e\u6761\u4ef6\u67e5\u8be2\u5217\u8868")
    @RequestMapping(value={"/queryList"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    @RequireAuth(roleLevel=RoleLevelEnum.bizAdmin)
    public ResponseDataBase queryList(String filterParam) throws Exception {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        List roleTree = this.sysRoleService.queryList(filterParam);
        responseDataBase.put((Object)"data", (Object)roleTree);
        return responseDataBase;
    }

    @ApiOperation(value="\u6839\u636e\u6761\u4ef6\u67e5\u8be2\u5217\u8868")
    @RequestMapping(value={"/queryPage"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    @RequireAuth(roleLevel=RoleLevelEnum.bizAdmin)
    public ResponseDataBase queryPage(@RequestParam(value="filterParam", required=false) String filterParam, @RequestParam(value="page", required=true) Integer page, @RequestParam(value="size", required=true) Integer size) throws Exception {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        IPage pages = this.sysRoleService.queryPage(filterParam, page.intValue(), size.intValue());
        responseDataBase.put((Object)"data", (Object)pages);
        return responseDataBase;
    }

    @ApiOperation(value="\u67e5\u8be2\u6811\u7ed3\u6784")
    @RequestMapping(value={"/findOne"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    @RequireAuth(roleLevel=RoleLevelEnum.bizAdmin)
    public ResponseDataBase findOne(@RequestParam(value="id", required=true) String id, @RequestParam(value="filterParam", required=false) String filterParam) throws Exception {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        SysRole role = this.sysRoleService.findOne(id, filterParam);
        responseDataBase.put((Object)"data", (Object)role);
        return responseDataBase;
    }

    @ApiOperation(value="\u5220\u9664")
    @OpLog(name="\u5220\u9664\u89d2\u8272", opType=OpTypeEnum.del)
    @RequireAuth(roleLevel=RoleLevelEnum.tenantAdmin)
    @RequestMapping(value={"/delete"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase delete(String id) throws Exception {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        this.sysRoleService.batchDelete(id);
        return responseDataBase;
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664")
    @OpLog(name="\u6279\u91cf\u5220\u9664\u4fe1\u606f", opType=OpTypeEnum.del)
    @RequireAuth(roleLevel=RoleLevelEnum.tenantAdmin)
    @RequestMapping(value={"/batchDelete"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase batchDelete(@RequestParam(value="ids", required=true) String ids) throws Exception {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        this.sysRoleService.batchDelete(ids);
        return responseDataBase;
    }

    @ApiOperation(value="\u67e5\u8be2\u89d2\u8272\u5173\u8054\u7684\u7528\u6237")
    @RequestMapping(value={"/users"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @RequireAuth(roleLevel=RoleLevelEnum.bizAdmin)
    public ResponseDataBase queryRelUsers(@RequestParam(value="roleId", required=true) String roleId) throws Exception {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        List users = this.sysRoleService.queryRelUsers(roleId);
        responseDataBase.put((Object)"data", (Object)users);
        return responseDataBase;
    }

    @ApiOperation(value="\u67e5\u8be2\u89d2\u8272\u5173\u8054/\u975e\u5173\u8054\u7684\u7528\u6237")
    @RequestMapping(value={"/pageUsers"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @RequireAuth(roleLevel=RoleLevelEnum.bizAdmin)
    public ResponseDataBase queryPageUsers(@RequestParam(value="roleId", required=false) String roleId, @RequestParam(value="noRoleId", required=false) String noRoleId, @RequestParam(value="filterParam", required=false) String filterParam, @RequestParam(value="sortParam", required=false) String sortParam, @RequestParam(value="page", required=true) Integer page, @RequestParam(value="size", required=true) Integer size) throws Exception {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        IPage users = this.sysRoleService.queryPageUsers(roleId, noRoleId, filterParam, sortParam, page.intValue(), size.intValue());
        responseDataBase.put((Object)"data", (Object)users);
        return responseDataBase;
    }

    @ApiOperation(value="\u6392\u5e8f\u7f6e\u6362")
    @RequestMapping(value={"/sort"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @RequireAuth(roleLevel=RoleLevelEnum.tenantAdmin)
    public ResponseDataBase sortUp(@RequestParam(value="id", required=true) String id, @RequestParam(value="pid", required=true) String pid, @RequestParam(value="flag", required=true) Integer flag) throws Exception {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        this.sysRoleService.sortRoles(id, pid, flag.intValue());
        return responseDataBase;
    }

    @ApiOperation(value="\u6392\u5e8f\u7f6e\u6362")
    @RequestMapping(value={"/drag"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @RequireAuth(roleLevel=RoleLevelEnum.tenantAdmin)
    public ResponseDataBase drag(@RequestParam(value="id", required=true) String id, @RequestParam(value="refId", required=true) String refId, @RequestParam(value="type", required=true) String type) throws Exception {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        this.sysRoleService.dragRoleNode(id, refId, type);
        return responseDataBase;
    }

    @ApiOperation(value="\u6839\u636e\u6761\u4ef6\u67e5\u8be2\u4e2a\u6570")
    @RequestMapping(value={"/queryCount"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    @RequireAuth(roleLevel=RoleLevelEnum.bizAdmin)
    public ResponseDataBase queryCount(String filterParam) throws Exception {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        int count = this.sysRoleService.queryCount(filterParam);
        responseDataBase.put((Object)"data", (Object)count);
        return responseDataBase;
    }

    @ApiOperation(value="\u4fee\u6539\u5173\u8054\u7684\u7cfb\u7edf\u4fe1\u606f")
    @OpLog(name="\u4fee\u6539\u5173\u8054\u7684\u7cfb\u7edf\u4fe1\u606f", opType=OpTypeEnum.update)
    @RequireAuth(roleLevel=RoleLevelEnum.tenantAdmin)
    @RequestMapping(value={"/saveRelateSystems"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase saveRelateSystemsAndApps(@RequestParam(value="id", required=true) String id, @RequestParam(value="systemIds", required=false) String systemIds, @RequestParam(value="isClear", required=false, defaultValue="true") Boolean isClear) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        List<Object> systemIdList = new ArrayList();
        if (StrUtil.isNotBlank((CharSequence)systemIds)) {
            systemIdList = Arrays.asList(systemIds.split(","));
        }
        if (systemIdList.size() > 0) {
            this.sysRoleSystemService.saveRoleSystems(id, systemIdList, isClear.booleanValue());
        }
        return responseDataBase;
    }

    @ApiOperation(value="\u67e5\u8be2\u89d2\u8272\u5173\u8054\u7684\u7cfb\u7edf")
    @RequestMapping(value={"/relateSystems"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @RequireAuth(roleLevel=RoleLevelEnum.bizAdmin)
    public ResponseDataBase relateApps(@RequestParam(value="id", required=true) String id) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        responseDataBase.put((Object)"data", (Object)this.sysRoleSystemService.queryRoleSystems(id));
        return responseDataBase;
    }

    @ApiOperation(value="\u5220\u9664\u5173\u8054\u7684\u7cfb\u7edf\u4fe1\u606f")
    @OpLog(name="\u5220\u9664\u5173\u8054\u7684\u7cfb\u7edf\u4fe1\u606f", opType=OpTypeEnum.update)
    @RequireAuth(roleLevel=RoleLevelEnum.tenantAdmin)
    @RequestMapping(value={"/removeRelateSystems"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase removeRelateSystemsAndApps(@RequestParam(value="id", required=true) String id, @RequestParam(value="systemIds", required=true) String systemIds) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        this.sysRoleSystemService.removeRoleSystem(id, Arrays.asList(systemIds.split(",")));
        return responseDataBase;
    }

    @ApiOperation(value="\u67e5\u770b\u5173\u8054\u7684\u83dc\u5355\u4fe1\u606f")
    @RequestMapping(value={"/menus"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    @RequireAuth(roleLevel=RoleLevelEnum.bizAdmin)
    public ResponseDataBase queryRelateMenus(@RequestParam(value="id", required=true) String id, @RequestParam(value="appId", required=true) String appId) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        List menus = this.sysRoleMenuService.queryRelateMenus(id, appId);
        responseDataBase.put((Object)"data", (Object)menus);
        return responseDataBase;
    }

    @ApiOperation(value="\u4fdd\u5b58(\u5220\u9664)\u5173\u8054\u7684\u83dc\u5355\u4fe1\u606f")
    @OpLog(name="\u4fdd\u5b58(\u5220\u9664)\u5173\u8054\u7684\u83dc\u5355\u4fe1\u606f", opType=OpTypeEnum.update)
    @RequireAuth(roleLevel=RoleLevelEnum.tenantAdmin)
    @RequestMapping(value={"/saveRoleMenus"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase saveRoleMenus(@RequestParam(value="id", required=true) String id, @RequestParam(value="appId", required=true) String appId, @RequestParam(value="menuIds", required=false) String menuIds) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        List<Object> menuIdList = new ArrayList();
        if (StrUtil.isNotBlank((CharSequence)menuIds)) {
            menuIdList = Arrays.asList(menuIds.split(","));
        }
        this.sysRoleMenuService.saveRoleMenus(id, appId, menuIdList);
        return responseDataBase;
    }

    @ApiOperation(value="\u67e5\u8be2\u7cfb\u7edf\u5173\u8054\u7684\u89d2\u8272")
    @RequestMapping(value={"/systemRelateRoles"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @RequireAuth(roleLevel=RoleLevelEnum.bizAdmin)
    public ResponseDataBase saveSystemRoles(@RequestParam String systemId) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        responseDataBase.put((Object)"data", (Object)this.sysRoleSystemService.systemRelateRoles(systemId));
        return responseDataBase;
    }

    @ApiOperation(value="\u4fdd\u5b58(\u5220\u9664)\u7cfb\u7edf\u5173\u8054\u7684\u89d2\u8272")
    @RequestMapping(value={"/saveSystemRoles"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @RequireAuth(roleLevel=RoleLevelEnum.tenantAdmin)
    public ResponseDataBase saveSystemRoles(@RequestParam String systemId, String roleIds) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        this.sysRoleSystemService.saveSystemRoles(systemId, roleIds);
        return responseDataBase;
    }

    @ApiOperation(value="\u67e5\u770b\u5173\u8054\u7684\u529f\u80fd\u70b9\u4fe1\u606f")
    @RequestMapping(value={"/subFunctions"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    @RequireAuth(roleLevel=RoleLevelEnum.bizAdmin)
    public ResponseDataBase queryRelateSubFunction(@RequestParam(value="id", required=true) String id, @RequestParam(value="menuId", required=true) String menuId) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        List menus = this.saveRoleSubFunctions.queryRelateSubFunctionList(id, menuId);
        responseDataBase.put((Object)"data", (Object)menus);
        return responseDataBase;
    }

    @ApiOperation(value="\u4fdd\u5b58(\u5220\u9664)\u5173\u8054\u7684\u529f\u80fd\u70b9\u4fe1\u606f")
    @OpLog(name="\u4fdd\u5b58(\u5220\u9664)\u5173\u8054\u7684\u529f\u80fd\u70b9\u4fe1\u606f", opType=OpTypeEnum.update)
    @RequestMapping(value={"/saveRoleSubFunctions"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @RequireAuth(roleLevel=RoleLevelEnum.tenantAdmin)
    public ResponseDataBase saveRoleSubFunctions(@RequestParam(value="id", required=true) String id, @RequestParam(value="menuId", required=true) String menuId, @RequestParam(value="subFunctionIds", required=false) String subFunctionIds) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        List<Object> subFunctionList = new ArrayList();
        if (StrUtil.isNotBlank((CharSequence)subFunctionIds)) {
            subFunctionList = Arrays.asList(subFunctionIds.split(","));
        }
        this.saveRoleSubFunctions.saveRoleSubFunctions(id, menuId, subFunctionList);
        return responseDataBase;
    }

    @ApiOperation(value="\u4fee\u6539\u89d2\u8272\u5173\u8054\u7684\u7528\u6237\u4fe1\u606f")
    @OpLog(name="\u4fee\u6539\u89d2\u8272\u5173\u8054\u7684\u7528\u6237\u4fe1\u606f", opType=OpTypeEnum.update)
    @RequireAuth(roleLevel=RoleLevelEnum.bizAdmin)
    @RequestMapping(value={"/bindUsers"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase bindUsers(@RequestParam(value="roleId", required=true) String roleId, @RequestParam(value="userIds", required=true) String userIds) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        this.sysRoleService.bindUsers(roleId, userIds);
        return responseDataBase;
    }

    @ApiOperation(value="\u79fb\u9664\u89d2\u8272\u5173\u8054\u7684\u7528\u6237\u4fe1\u606f")
    @OpLog(name="\u79fb\u9664\u89d2\u8272\u5173\u8054\u7684\u7528\u6237\u4fe1\u606f", opType=OpTypeEnum.update)
    @RequireAuth(roleLevel=RoleLevelEnum.bizAdmin)
    @RequestMapping(value={"/removeUsers"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase removeUsers(@RequestParam(value="roleId", required=true) String roleId, @RequestParam(value="userIds", required=true) String userIds) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        this.sysRoleService.removeBindUsers(roleId, userIds);
        return responseDataBase;
    }
}

