/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.jckj.api.controller;

import cn.hutool.core.util.ObjectUtil;
import com.geoway.jckj.biz.service.oauth2.IOauth2Service;
import com.geoway.jckj.biz.service.sys.SysUserRegisterService;
import com.geoway.sso.client.rpc.Result;
import com.geoway.sso.client.rpc.RpcAccessToken;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"Oauth2.0\u6807\u51c6\u7528\u6237\u767b\u5f55"})
@RestController
@RequestMapping(value={"/oauth2"})
public class SsoOauth2Controller {
    @Autowired
    private IOauth2Service ssoOauth2Service;
    @Autowired
    private SysUserRegisterService sysUserRegisterService;

    @ApiOperation(value="\u83b7\u53d6accessToken")
    @RequestMapping(value={"/access_token"}, method={RequestMethod.POST, RequestMethod.GET})
    public Result getAccessToken(@RequestParam(value="grantType", required=true) String grantType, @RequestParam(value="appId", required=true) String appId, @RequestParam(value="appSecret", required=true) String appSecret, @RequestParam(value="code", required=false) String code, @RequestParam(value="username", required=false) String username, @RequestParam(value="password", required=false) String password, @RequestParam(value="tel", required=false) String tel, @RequestParam(value="source", required=false) String source, @RequestParam(value="sessionId", required=false) String sessionId, @RequestParam(value="catpcha", required=false) String catpcha, @RequestParam(value="caUserCert", required=false) String caUserCert, @RequestParam(value="caOauthName", required=false) String caOauthName, @RequestParam(value="oneProcessId", required=false) String oneProcessId, @RequestParam(value="oneToken", required=false) String oneToken, @RequestParam(value="oneAuthCode", required=false) String oneAuthCode) throws Exception {
        if (ObjectUtil.isNotEmpty((Object)source)) {
            this.sysUserRegisterService.registerUserWhenLogin(tel, source);
        }
        return Result.createSuccess((Object)this.ssoOauth2Service.getAccessToken(grantType, appId, appSecret, code, username, password, tel, sessionId, catpcha, caUserCert, caOauthName, oneProcessId, oneToken, oneAuthCode));
    }

    @ApiOperation(value="\u5237\u65b0accessToken")
    @RequestMapping(value={"/refresh_token"}, method={RequestMethod.POST, RequestMethod.GET})
    public Result refreshToken(@RequestParam(value="appId", required=true) String appId, @RequestParam(value="refreshToken", required=true) String refreshToken) {
        return Result.createSuccess((Object)this.ssoOauth2Service.refreshToken(appId, refreshToken));
    }

    @ApiOperation(value="\u9a8c\u8bc1accessToken\u6709\u6548\u6027")
    @RequestMapping(value={"/query_access_token"}, method={RequestMethod.POST, RequestMethod.GET})
    public Result queryAccessToken(@RequestParam(value="access_token", required=true) String token) {
        RpcAccessToken rpcAccessToken = this.ssoOauth2Service.queryAccessToken(token);
        if (rpcAccessToken != null) {
            return Result.createSuccess((Object)rpcAccessToken);
        }
        return Result.createNoLogin();
    }

    @ApiOperation(value="\u9500\u6bc1accessToken")
    @RequestMapping(value={"/revoke_access_token"}, method={RequestMethod.POST, RequestMethod.GET})
    public Result revokeAccessToken(@RequestParam(value="access_token", required=true) String token, HttpServletResponse response) {
        this.ssoOauth2Service.revokeAccessToken(token);
        return Result.createSuccess();
    }

    @ApiOperation(value="\u83b7\u53d6accessCode")
    @RequestMapping(value={"/access_code"}, method={RequestMethod.POST, RequestMethod.GET})
    public Result getAccessCode(@RequestParam(value="appId", required=true) String appId, @RequestParam(value="appSecret", required=true) String appSecret, @RequestParam(value="access_token", required=true) String token, @RequestParam(value="allowedUseCount", required=false, defaultValue="1") int allowedUseCount) {
        String code = this.ssoOauth2Service.getAccessCode(appId, appSecret, token, allowedUseCount);
        return Result.createSuccess((Object)code);
    }
}

