package com.geoway.jckj.base.base.dto;


import com.geoway.jckj.base.constants.CommonConstants;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @author: linkang @Date: 2021/7/19 10:25 @Description:
 */
@Data
public class BaseResponse {
    @ApiModelProperty(value = "状态标记",notes = "OK、FAILURE、NEEDLOGIN")
    protected String status = CommonConstants.RESPONSE_STATUS_OK;

    @ApiModelProperty(value = "状态信息")
    protected String message = "";

    @ApiModelProperty(value = "状态码")
    protected Integer code = CommonConstants.STATUS_SUCCESS;


    public static BaseResponse buildNoLoginResponse() {
        BaseResponse response = new BaseResponse();
        response.setCode( CommonConstants.STATUS_FALL);
        response.setStatus(CommonConstants.RESPONSE_STATUS_LOGINOUT);
        response.setMessage("用户未登录或已登录超时，请重新登录!");
        return response;
    }


    public static BaseResponse buildFailuaResponse(String error) {
        BaseResponse response = new BaseResponse();
        response.setCode( CommonConstants.STATUS_FALL);
        response.setStatus(CommonConstants.RESPONSE_STATUS_FAILURE);
        response.setMessage(error);
        return response;
    }

    public static BaseResponse buildFailuaResponse(String error, Integer code) {
        BaseResponse response = new BaseResponse();
        response.setStatus(CommonConstants.RESPONSE_STATUS_FAILURE);
        response.setCode(code);
        response.setMessage(error);
        return response;
    }

}
