package com.geoway.jckj.base.support.filter;


import cn.hutool.core.util.StrUtil;
import com.geoway.jckj.base.annotation.SwaggerInputFieldIgnore;
import com.geoway.jckj.base.config.ModelRetriveApiListingPugin;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.collections4.map.HashedMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.ReflectionUtils;
import springfox.documentation.oas.web.OpenApiTransformationContext;
import springfox.documentation.oas.web.WebMvcOpenApiTransformationFilter;
import springfox.documentation.schema.QualifiedModelName;
import springfox.documentation.spi.DocumentationType;

import javax.servlet.http.HttpServletRequest;
import java.lang.reflect.Field;
import java.util.*;

@Component
@Slf4j
public class InputFieldIgnoreFilter implements WebMvcOpenApiTransformationFilter {

    public static final String SUFFIX_INPUT = "-input";

    private Map<String, InjectedInputSchema> injectedSchemaMap = new HashedMap();

    @Autowired
    private ModelRetriveApiListingPugin modelRetriveApiListingPugin;

    @Value("${swagger.fieldIgnore.Enable:true}")
    private Boolean fieldIgnoreEnable;

    public static final class InjectedInputSchema {
        String originKey;
        String injectedKey;
        Class schemaClazz;
        Schema injectedSchema;

        public InjectedInputSchema(String originKey, Class schemaClazz) {
            this.originKey = originKey;
            this.injectedKey = originKey + "-input";
            this.schemaClazz = schemaClazz;
        }
    }

    /**
     * 1. 根据注解@SwaggerInputFieldIgnore，解析余下的字段
     * 2. 增加对应的schema
     *
     * @param oas
     */
    private void processInputInject(OpenAPI oas) {
        if (!fieldIgnoreEnable) {
            return;
        }


        for (PathItem each : oas.getPaths().values()) {
            //appendRefWithInput(each.getPut());
            removeRedundancy(each.getPost());
            removeRedundancy(each.getGet());
        }

        /*// 1. 解析paths，替换$ref; 同时，收集schema元数据用于补充schema-input。
        for (PathItem each : oas.getPaths().values()) {
            //appendRefWithInput(each.getPut());
            appendRefWithInput(each.getPost());
            appendRefWithInput(each.getGet());
        }

        if(MapUtils.isEmpty(injectedSchemaMap)){
            return;
        }

        // 2. 补充schema-input
        for (InjectedInputSchema each : injectedSchemaMap.values()) {
            // 2.1. 构造schema
            Schema old = oas.getComponents().getSchemas().get(each.originKey);
            Schema schema = constructSchema(each, old);
            // 2.2. 加入oas.components.schemas
            oas.getComponents().getSchemas().put(each.injectedKey, schema);
        }*/
    }

    /**
     * 移除无用参数（比如数组对象中 [0])
     * @param operation
     */
    private void removeRedundancy(Operation operation){
        if(operation == null){
            return;
        }
        List<Parameter> params = operation.getParameters();
        List<Parameter> removeParams = new ArrayList<>();
        for(Parameter param: params){
            if( param.getName().contains("[0].")){
                removeParams.add(param);
            }
        }

        removeParams.forEach( p -> params.remove(p));
    }

    private void appendRefWithInput(Operation operation) {
        if (operation == null || operation.getRequestBody() == null) {
            return;
        }
        try {

            Content content = operation.getRequestBody().getContent();
            MediaType mediaType = content.get(org.springframework.http.MediaType.APPLICATION_JSON_VALUE);
            Schema schema = mediaType.getSchema();
            String $ref = schema.get$ref();
            if($ref == null){
                return;
            }
            String originName = $ref.substring($ref.lastIndexOf("/") + 1);
            QualifiedModelName modelName = modelRetriveApiListingPugin.getApiModels().get(originName);
            if (modelName != null) {
                schema.set$ref($ref + SUFFIX_INPUT);
                injectedSchemaMap.put(originName, new InjectedInputSchema(originName, constructClazz(modelName)));
            }
        } catch (Exception e) {
            log.error("error occured", e);
        }
    }

    private static Class<?> constructClazz(QualifiedModelName modelName) throws ClassNotFoundException {
        return Class.forName(modelName.getNamespace() + "." + modelName.getName());
    }

    private Schema constructSchema(InjectedInputSchema each, Schema old) {

        Schema result = new ObjectSchema();
        result.title(each.injectedKey);
        result.type(old.getType());
        result.description(old.getDescription());

        HashMap<String, Schema> props = new HashMap<>(old.getProperties());
        Set<String> removingKey = new HashSet();
        props.keySet().forEach(filedName -> {
            Field field = ReflectionUtils.findField(each.schemaClazz, filedName);
            SwaggerInputFieldIgnore anno = AnnotationUtils.findAnnotation(field, SwaggerInputFieldIgnore.class);
            if (anno != null) {
                removingKey.add(filedName);
            }
        });

        removingKey.forEach(field -> props.remove(field));
        result.setProperties(props);

        return result;
    }

    @Override
    public OpenAPI transform(OpenApiTransformationContext<HttpServletRequest> context) {
        OpenAPI openApi = context.getSpecification();
        processInputInject(openApi);
        return openApi;
    }

    @Override
    public boolean supports(DocumentationType delimiter) {
        return delimiter == DocumentationType.OAS_30;
    }
}


