package com.geoway.jckj.base.support.query;

import com.geoway.jckj.base.support.StringUtils;
import org.springframework.data.domain.Sort;
import org.springframework.data.domain.Sort.Direction;
import org.springframework.data.domain.Sort.Order;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;


/**
 * @author geoway
 */
public class QueryParamUtil {
	
	public static final String complexFindKey = "#";

	/**
	 * 从请求对象获取查询参数,并进行构造
	 * <p>
	 * 参数名格式必须为: Q_firstName_S_EQ 其中Q_表示该参数为查询的参数，firstName查询的字段名称，和实体类的字段名称一致
	 * S代表该参数的类型为字符串类型,该位置的其他值有： D=日期，N=number,S=字符串 EQ代表等于。 该位置的其他值有：<br/>
	 * LT，GT，EQ，LE，GE,LK,NE<br/>
	 * 要别代表<,>,=,<=,>=,like的条件查询
	 * <p>
	 * 
	 * 支持带刮号的复杂表达式：如
	 *  Q_fieldA_N_LE=100;Q_fieldB_N_LT=200;(QOR_fieldC_N_LE=300;QOR_fieldD_N_LT=400;(Q_fieldE_N_LE=500;QOR_fieldF_N_LT=600;))
	 * 
	 * @param filterParam
	 * 
	 */
	public static List<QueryFilterParam> parseQueryFilterParams(String filterParam,boolean oldMode) {

	     //先判断是否复杂表达式
		if(!QueryParamParseUtil.isComplexExpession(filterParam)){
			return QueryParamParseUtil.parse4QueryParams(filterParam,oldMode);
		}

		String regex = "\\([^\\(\\)]+\\)";// 匹配()
		Pattern pattern = Pattern.compile(regex);
		Matcher matcher = pattern.matcher(filterParam);
		String finalRes = filterParam;
		int index = 1;
		final String matchKey = QueryParamParseUtil.complexFindKey;
		
		//对于复杂表达式，将其从子节点开始用特殊字符替换，并存入到对应的HashMap中，再用常规处理
		Map<String,String> matchMap = new HashMap<String,String>();
		while (matcher.find()) {
			
			String group = matcher.group();
			String findKey = matchKey + index;
			finalRes = matcher.replaceFirst(findKey);// #
			matcher.reset(finalRes);// 重置表达式
			String innalParam= group.substring(1, group.length() - 1);
			
			matchMap.put(findKey, innalParam);
			index++;
		}
		
		String newFilterParam = finalRes;
		List<QueryFilterParam> queryParams = new ArrayList<QueryFilterParam>();
		String[] paramPairs = newFilterParam.split(";");
		QueryFilterParam queryParam = null;
		for (int i = 0; i < paramPairs.length; i++) {
			String matchParam = paramPairs[i];
			if (StringUtils.isBlank( matchParam)) {
				continue;
			}
			
			//解析替换的复杂表达式
			if(matchParam.contains(matchKey)){
				queryParam = QueryParamParseUtil.parseComplexMatchParam(matchParam,matchMap,oldMode);
			}else{
				queryParam = QueryParamParseUtil.parseMatchParam(matchParam,oldMode);
			}
			queryParams.add(queryParam);
		}

		return queryParams;
	}

	/**
	 * 从请求对象获取排序参数,并进行构造
	 * <p>
	 * 参数名格式必须为: SORT_firstName_ASC
	 * 其中SORT表示该参数为排序参数,firstName查询的字段名称，和实体类的字段名称一致 ASC代表该参数为升序
	 * @param sortParam
	 */
	public static Sort parseSortParams(String sortParam) {

		/*if (StringUtils.isBlank(sortParam)) {
			return null;
		}*/

		List<Order> list = new ArrayList<Order>();
		String[] paramPairs = sortParam.split(";");
		for (int i = 0; i < paramPairs.length; i++) {
			String parseParam = paramPairs[i];
			String[] fieldInfo = parseParam.split("_");
			if (fieldInfo[0].startsWith("SORT")) {
				Order o = new Order(Direction.fromString(fieldInfo[2]), fieldInfo[1]);
				list.add(o);
			}
		}
		return Sort.by(list);
	}
	
}
