/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.jckj.base.config;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.collections4.map.HashedMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.util.ReflectionUtils;
import springfox.documentation.builders.ApiListingBuilder;
import springfox.documentation.schema.CompoundModelSpecification;
import springfox.documentation.schema.ModelKey;
import springfox.documentation.schema.ModelSpecification;
import springfox.documentation.schema.QualifiedModelName;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.ApiListingBuilderPlugin;
import springfox.documentation.spi.service.contexts.ApiListingContext;

@Order(value=0x7FFFFFFF)
@Component
public class ModelRetriveApiListingPugin
implements ApiListingBuilderPlugin {
    private static final Logger log = LoggerFactory.getLogger(ModelRetriveApiListingPugin.class);
    private Map<String, QualifiedModelName> apiModels = new HashedMap();

    public void apply(ApiListingContext apiListingContext) {
        Field filed = ReflectionUtils.findField(ApiListingBuilder.class, (String)"modelSpecifications");
        filed.setAccessible(true);
        Map specsMap = (Map)ReflectionUtils.getField((Field)filed, (Object)apiListingContext.apiListingBuilder());
        this.retriveApiModels(specsMap.values());
    }

    private void retriveApiModels(Collection<ModelSpecification> specs) {
        specs.forEach(spec -> {
            ModelKey modelKey = ((CompoundModelSpecification)spec.getCompound().get()).getModelKey();
            QualifiedModelName modelName = modelKey.getQualifiedModelName();
            this.apiModels.put(modelName.getName(), modelName);
            log.info(modelName.toString());
        });
    }

    public Map<String, QualifiedModelName> getApiModels() {
        return this.apiModels;
    }

    public boolean supports(DocumentationType delimiter) {
        return true;
    }
}

