/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.jckj.base.support;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

public class DbUtil {
    private DbUtil() {
    }

    public static String getFilterByList(List<String> sqhList, int splitNum, String columnName) {
        if (sqhList == null || sqhList.size() == 0) {
            return " 1=1 ";
        }
        if (sqhList.size() < splitNum) {
            return columnName + " in (" + String.join((CharSequence)",", sqhList) + ")";
        }
        StringBuilder sql = new StringBuilder("");
        sql.append(" ").append(columnName).append(" IN ( ");
        for (int i = 0; i < sqhList.size(); ++i) {
            sql.append(sqhList.get(i) + ",");
            if ((i + 1) % splitNum != 0 || i + 1 >= sqhList.size()) continue;
            sql.deleteCharAt(sql.length() - 1);
            sql.append(" ) OR ").append(columnName).append(" IN (");
        }
        sql.deleteCharAt(sql.length() - 1);
        sql.append(" )");
        return sql.toString();
    }

    public static boolean isTableExist(JdbcTemplate jdbcTemplate, String tableName) {
        Long exist;
        String dbTypeName = DbUtil.queryDbType(jdbcTemplate);
        String checkTableName = tableName;
        int index = checkTableName.lastIndexOf(".");
        if (index > -1) {
            checkTableName = checkTableName.substring(index + 1);
        }
        String sql = String.format("select count(1) from user_tables where table_name ='%s'", checkTableName.toUpperCase());
        if (dbTypeName.trim().toLowerCase().equals("postgresql")) {
            sql = String.format("select count(1) from pg_class where lower(relname) ='%s'", checkTableName.toLowerCase());
        }
        return (exist = (Long)jdbcTemplate.queryForObject(sql, Long.class)) > 0L;
    }

    public static boolean hasData(JdbcTemplate jdbcTemplate, String tableName) {
        String sql = "select count(*) from " + tableName;
        List result = jdbcTemplate.query(sql, (RowMapper)new RowMapper<Integer>(){

            public Integer mapRow(ResultSet rs, int rowNum) throws SQLException {
                return Integer.parseInt(rs.getString(1));
            }
        });
        return (Integer)result.get(0) > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String queryDbType(JdbcTemplate jdbcTemplate) {
        String dbTypeName = null;
        Connection myConn = null;
        try {
            myConn = jdbcTemplate.getDataSource().getConnection();
            dbTypeName = myConn.getMetaData().getDatabaseProductName();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            if (myConn != null) {
                try {
                    myConn.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        return dbTypeName;
    }

    public static List<HashMap<String, Object>> listArrayToListMap(List<Object> list, String[] keys) {
        if (list == null || list.size() <= 0) {
            return null;
        }
        ArrayList<HashMap<String, Object>> mapList = new ArrayList<HashMap<String, Object>>();
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i) instanceof Map) continue;
            HashMap<String, Object> map = new HashMap<String, Object>();
            Object[] m = (Object[])list.get(i);
            for (int j = 0; j < keys.length; ++j) {
                map.put(keys[j], m[j]);
            }
            mapList.add(map);
        }
        return mapList;
    }
}

