/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.jckj.base.support.filter;

import com.geoway.jckj.base.annotation.SwaggerInputFieldIgnore;
import com.geoway.jckj.base.config.ModelRetriveApiListingPugin;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections4.map.HashedMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.ReflectionUtils;
import springfox.documentation.oas.web.OpenApiTransformationContext;
import springfox.documentation.oas.web.WebMvcOpenApiTransformationFilter;
import springfox.documentation.schema.QualifiedModelName;
import springfox.documentation.spi.DocumentationType;

@Component
public class InputFieldIgnoreFilter
implements WebMvcOpenApiTransformationFilter {
    private static final Logger log = LoggerFactory.getLogger(InputFieldIgnoreFilter.class);
    public static final String SUFFIX_INPUT = "-input";
    private Map<String, InjectedInputSchema> injectedSchemaMap = new HashedMap();
    @Autowired
    private ModelRetriveApiListingPugin modelRetriveApiListingPugin;
    @Value(value="${swagger.fieldIgnore.Enable:true}")
    private Boolean fieldIgnoreEnable;

    private void processInputInject(OpenAPI oas) {
        if (!this.fieldIgnoreEnable.booleanValue()) {
            return;
        }
        for (PathItem each : oas.getPaths().values()) {
            this.removeRedundancy(each.getPost());
            this.removeRedundancy(each.getGet());
        }
    }

    private void removeRedundancy(Operation operation) {
        if (operation == null) {
            return;
        }
        List params = operation.getParameters();
        ArrayList<Parameter> removeParams = new ArrayList<Parameter>();
        for (Parameter param : params) {
            if (!param.getName().contains("[0].")) continue;
            removeParams.add(param);
        }
        removeParams.forEach(p -> params.remove(p));
    }

    private void appendRefWithInput(Operation operation) {
        if (operation == null || operation.getRequestBody() == null) {
            return;
        }
        try {
            Content content = operation.getRequestBody().getContent();
            MediaType mediaType = (MediaType)content.get((Object)"application/json");
            Schema schema = mediaType.getSchema();
            String $ref = schema.get$ref();
            if ($ref == null) {
                return;
            }
            String originName = $ref.substring($ref.lastIndexOf("/") + 1);
            QualifiedModelName modelName = this.modelRetriveApiListingPugin.getApiModels().get(originName);
            if (modelName != null) {
                schema.set$ref($ref + SUFFIX_INPUT);
                this.injectedSchemaMap.put(originName, new InjectedInputSchema(originName, InputFieldIgnoreFilter.constructClazz(modelName)));
            }
        }
        catch (Exception e) {
            log.error("error occured", (Throwable)e);
        }
    }

    private static Class<?> constructClazz(QualifiedModelName modelName) throws ClassNotFoundException {
        return Class.forName(modelName.getNamespace() + "." + modelName.getName());
    }

    private Schema constructSchema(InjectedInputSchema each, Schema old) {
        ObjectSchema result = new ObjectSchema();
        result.title(each.injectedKey);
        result.type(old.getType());
        result.description(old.getDescription());
        HashMap props = new HashMap(old.getProperties());
        HashSet removingKey = new HashSet();
        props.keySet().forEach(filedName -> {
            Field field = ReflectionUtils.findField((Class)each.schemaClazz, (String)filedName);
            SwaggerInputFieldIgnore anno = (SwaggerInputFieldIgnore)AnnotationUtils.findAnnotation((AnnotatedElement)field, SwaggerInputFieldIgnore.class);
            if (anno != null) {
                removingKey.add(filedName);
            }
        });
        removingKey.forEach(field -> {
            Schema cfr_ignored_0 = (Schema)props.remove(field);
        });
        result.setProperties(props);
        return result;
    }

    public OpenAPI transform(OpenApiTransformationContext<HttpServletRequest> context) {
        OpenAPI openApi = context.getSpecification();
        this.processInputInject(openApi);
        return openApi;
    }

    public boolean supports(DocumentationType delimiter) {
        return delimiter == DocumentationType.OAS_30;
    }

    public static final class InjectedInputSchema {
        String originKey;
        String injectedKey;
        Class schemaClazz;
        Schema injectedSchema;

        public InjectedInputSchema(String originKey, Class schemaClazz) {
            this.originKey = originKey;
            this.injectedKey = originKey + InputFieldIgnoreFilter.SUFFIX_INPUT;
            this.schemaClazz = schemaClazz;
        }
    }
}

