/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.jckj.base.support.query;

import com.geoway.jckj.base.support.StringUtils;
import com.geoway.jckj.base.support.query.OperationModel;
import com.geoway.jckj.base.support.query.QueryFilterParam;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class QueryParamParseUtil {
    public static final String complexFindKey = "#";

    public static boolean isComplexExpession(String matchParam) {
        String regex = "\\([^\\(\\)]+\\)";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(matchParam);
        return matcher.find();
    }

    public static QueryFilterParam parseComplexMatchParam(String matchParam, Map<String, String> cacheMap, boolean oldMode) {
        if (!cacheMap.containsKey(matchParam)) {
            return null;
        }
        String filterParam = cacheMap.get(matchParam);
        QueryFilterParam queryFilterParam = new QueryFilterParam();
        queryFilterParam.setExpression(matchParam);
        String[] paramPairs = filterParam.split(";");
        ArrayList<QueryFilterParam> childrens = new ArrayList<QueryFilterParam>();
        QueryFilterParam subQueryParam = null;
        for (int i = 0; i < paramPairs.length; ++i) {
            String subMatchParam = paramPairs[i];
            if (StringUtils.isBlank((CharSequence)subMatchParam)) continue;
            subQueryParam = subMatchParam.contains(complexFindKey) ? QueryParamParseUtil.parseComplexMatchParam(subMatchParam, cacheMap, oldMode) : QueryParamParseUtil.parseMatchParam(subMatchParam, oldMode);
            childrens.add(subQueryParam);
        }
        queryFilterParam.setChildrens(childrens);
        queryFilterParam.setNest(true);
        if (childrens.size() > 0) {
            queryFilterParam.setJoinModel(((QueryFilterParam)childrens.get(0)).getJoinModel());
        }
        return queryFilterParam;
    }

    public static List<QueryFilterParam> parse4QueryParams(String filterParam, boolean oldMode) {
        ArrayList<QueryFilterParam> queryParams = new ArrayList<QueryFilterParam>();
        if (StringUtils.isBlank((CharSequence)filterParam)) {
            return queryParams;
        }
        String[] paramPairs = filterParam.split(";");
        for (int i = 0; i < paramPairs.length; ++i) {
            if (StringUtils.isBlank((CharSequence)paramPairs[i])) continue;
            queryParams.add(QueryParamParseUtil.parseMatchParam(paramPairs[i], oldMode));
        }
        return queryParams;
    }

    public static QueryFilterParam parseMatchParam(String matchParam, boolean oldMode) {
        QueryFilterParam queryParam = new QueryFilterParam();
        queryParam.setExpression(matchParam);
        if (matchParam.equalsIgnoreCase("and")) {
            queryParam.setOnlyJoinModel(true);
            queryParam.setJoinModel(QueryFilterParam.JoinModel.AND);
            return queryParam;
        }
        if (matchParam.equalsIgnoreCase("or")) {
            queryParam.setOnlyJoinModel(true);
            queryParam.setJoinModel(QueryFilterParam.JoinModel.OR);
            return queryParam;
        }
        String operation = "EQ";
        if (oldMode) {
            String[] paramValPair = matchParam.split("=");
            String parseParam = paramValPair[0].trim();
            String[] fieldInfo = parseParam.split("_");
            String joinParam = fieldInfo[0];
            if (joinParam.toUpperCase().equals("Q") || joinParam.toUpperCase().equals("QA")) {
                queryParam.setJoinModel(QueryFilterParam.JoinModel.AND);
            } else if (joinParam.toUpperCase().equals("QOR")) {
                queryParam.setJoinModel(QueryFilterParam.JoinModel.OR);
            }
            queryParam.setParamName(fieldInfo[1].trim());
            queryParam.setParamValue(paramValPair[1].trim());
            String fieldType = fieldInfo[2];
            if (fieldType.toUpperCase().equals("N")) {
                queryParam.setFieldType(QueryFilterParam.DataFieldType.NumberField);
            } else if (fieldType.toUpperCase().equals("S")) {
                queryParam.setFieldType(QueryFilterParam.DataFieldType.StringField);
            } else if (fieldType.toUpperCase().equals("D")) {
                queryParam.setFieldType(QueryFilterParam.DataFieldType.DateField);
            }
            operation = fieldInfo[3];
        } else {
            queryParam.setJoinModel(QueryFilterParam.JoinModel.AND);
            String[] filters = matchParam.split("_");
            if (filters.length < 3) {
                return queryParam;
            }
            queryParam.setParamName(filters[0]);
            operation = filters[1];
            queryParam.setParamValue(filters[2]);
        }
        QueryParamParseUtil.setOperation(queryParam, operation);
        return queryParam;
    }

    private static void setOperation(QueryFilterParam queryParam, String operation1) {
        String operation = operation1.toUpperCase();
        queryParam.setOperation(operation);
        switch (operation) {
            case "EQ": {
                queryParam.setOperationMode(OperationModel.EQ);
                break;
            }
            case "NE": {
                queryParam.setOperationMode(OperationModel.NE);
                break;
            }
            case "LK": {
                queryParam.setOperationMode(OperationModel.LK);
                break;
            }
            case "LFK": {
                queryParam.setOperationMode(OperationModel.LFK);
                break;
            }
            case "RHK": {
                queryParam.setOperationMode(OperationModel.RHK);
                break;
            }
            case "BTW": {
                queryParam.setOperationMode(OperationModel.BTW);
                break;
            }
            case "LT": {
                queryParam.setOperationMode(OperationModel.LT);
                break;
            }
            case "GT": {
                queryParam.setOperationMode(OperationModel.GT);
                break;
            }
            case "LE": {
                queryParam.setOperationMode(OperationModel.LE);
                break;
            }
            case "GE": {
                queryParam.setOperationMode(OperationModel.GE);
                break;
            }
            case "IN": {
                queryParam.setOperationMode(OperationModel.IN);
                break;
            }
            case "NOTIN": {
                queryParam.setOperationMode(OperationModel.NOTIN);
                break;
            }
            default: {
                queryParam.setOperationMode(OperationModel.EQ);
            }
        }
    }
}

