package com.geoway.jckj.base.support.query;
import lombok.Data;

import java.util.ArrayList;
import java.util.List;

@Data
public class QueryFilterParam {

	/**
	 * 仅仅只作为连接符
	 */
	private boolean onlyJoinModel = false;

	/**
	 * 参数名称
	 */
	private String paramName = "";

	/**
	 * 参数名值
	 */
	private String paramValue;


	/**
	 * 字段类型
	 */
	private DataFieldType fieldType = DataFieldType.StringField;

	/**
	 * 关系模型
	 */
	private String operation;

	/**
	 * 关系模型
	 */
	private OperationModel operationMode;


	/**
	 * 连接模式
	 */
	private JoinModel  joinModel = JoinModel.AND;

	/**
	 * 对应表达式
	 */
	private String expression;

	/**
	 * 是否嵌套查询
	 */
	private boolean isNest = false;

	/**
	 * 嵌套子对象
	 */
	private List<QueryFilterParam>  childrens;

	public QueryFilterParam(){
		this.childrens = new ArrayList<QueryFilterParam>();
	}


	/**
	 * 字段类型枚举
	 *
	 */
	public enum DataFieldType {
		NumberField, StringField, DateField
	}



	public enum JoinModel{
		AND,OR
	}

}