package com.geoway.jckj.base.base.dto;

import com.geoway.jckj.base.constants.CommonConstants;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name = "LoginResponse")
@XmlAccessorType(XmlAccessType.NONE)
public class LoginResponse extends BaseResponse {

  @XmlElement String userId = "";
  @XmlElement private String alisName = "";
  public String getAliasName() {
    return aliasName;
  }

  public void setAliasName(String aliasName) {
    this.aliasName = aliasName;
  }

  @XmlElement private String aliasName = "";
  @XmlElement private String userName = "";
  @XmlElement private String token = "";
  @XmlElement private String regionCode = "";
  @XmlElement private String regionName = "";
  @XmlElement private String validateType = "";
  @XmlElement private String refreshToken = "";
  @XmlElement private Integer userCatalog;


  public Object getPasswordPolicy() {
    return passwordPolicy;
  }

  public void setPasswordPolicy(Object passwordPolicy) {
    this.passwordPolicy = passwordPolicy;
  }

  @XmlElement private Object passwordPolicy="";
  public String getUserId() {
    return userId;
  }

  public void setUserId(String userId) {this.userId = userId;}

  public String getAlisName() {
    return alisName;
  }

  public void setAlisName(String alisname) {
    this.alisName = alisname;
  }

  public String getUserName() {
    return userName;
  }

  public void setUserName(String userName) { this.userName = userName; }

  public String getToken() {
    return token;
  }

  public void setToken(String token) {this.token = token;}

  public String getRegionCode() {
    return regionCode;
  }

  public void setRegionCode(String regionCode) {
    this.regionCode = regionCode;
  }

  public String getRegionName() {
    return regionName;
  }

  public void setRegionName(String regionName) {
    this.regionName = regionName;
  }

  public String getValidateType() {
    return validateType;
  }

  public void setValidateType(String validateType) {
    this.validateType = validateType;
  }

  public String getRefreshToken() {
    return refreshToken;
  }

  public void setRefreshToken(String refreshToken) {
    this.refreshToken = refreshToken;
  }

  public Integer getUserCatalog() {
    return userCatalog;
  }

  public void setUserCatalog(Integer userCatalog) {
    this.userCatalog = userCatalog;
  }

  public static LoginResponse buildRestPasswordResponse(String token,String error) {
    LoginResponse response = new LoginResponse();
    response.setStatus(CommonConstants.RESPONSE_STATUS_OK);
    response.setCode(CommonConstants.STATUS_RESETPASSWORD);
    response.setToken(token);
    response.setMessage(error);
    return response;
  }
}
