package com.geoway.jckj.base.support;

import org.springframework.data.redis.core.RedisTemplate;

import java.util.concurrent.TimeUnit;

/**
 * @ClassName PhoneSmsCodeUtil
 * @Description
 * @TODO
 * @Author cls
 * @Date 2022/11/10 14:54
 * @Version v1.0
 */
public class PhoneSmsCodeUtil {

  public static final Long SMSCODE_OUTTIME = 60l;

  public static Boolean checkSmsCodeNum(RedisTemplate redisTemplate, String phone) {
    Boolean tag = false;
    String key = "sms" + phone;
    Boolean hasKey = redisTemplate.hasKey(key);
    if (hasKey) {
      Long num = redisTemplate.opsForSet().size(key);
      if (num >= 3) {
        tag = true;
      } else {
        redisTemplate.opsForSet().add(key, num++);
      }
    } else {
      redisTemplate.opsForSet().add(key, 1);
      redisTemplate.expire(key, SMSCODE_OUTTIME, TimeUnit.SECONDS);
    }
    return tag;
  }
}
