package com.geoway.jckj.base.support.encryption;

import java.security.Security;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

/**
 * @description: AES加密工具
 * <br>
 * @author: wujing
 * @date: 2023-05-17 10:32
 */
public class AESUtils {

    /**
     * 加密方式
     */
    public static final String AES = "AES";

    /**
     * 默认key
     */
    public static final String KEY = "FWAijk4A2Dwt2MKw";

    /**
     * 模式
     */
    public static final String MODE = "AES/ECB/PKCS7Padding";

    /**
     * 注册BouncyCastle ，直接使用其提供的 加密算法 和 哈希算法
     */
    static {
        Security.addProvider(new BouncyCastleProvider());
    }

    /**
     * 加密
     * @param input
     * @param key
     * @return
     * @throws Exception
     */
    public static String encrypt(String input, String key) throws Exception {
        SecretKeySpec skey = new SecretKeySpec(key.getBytes(), AES);
        Cipher cipher = Cipher.getInstance(MODE);
        cipher.init(Cipher.ENCRYPT_MODE, skey);
        byte[] crypted = cipher.doFinal(input.getBytes());
        return new String(Base64.encodeBase64(crypted));
    }

    /**
     * 解密
     * @param data
     * @param key
     * @return
     * @throws Exception
     */
    public static String decrypt(String data, String key) throws Exception {
        SecretKeySpec skey = new SecretKeySpec(key.getBytes(), AES);
        Cipher cipher = Cipher.getInstance(MODE);
        cipher.init(Cipher.DECRYPT_MODE, skey);
        byte[] output = cipher.doFinal(Base64.decodeBase64(data));
        return new String(output);
    }

}