/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.jckj.biz.bgjpt.controller;

import cn.hutool.core.util.StrUtil;
import com.geoway.jckj.base.enums.UserSysEnum;
import com.geoway.jckj.base.exception.ServiceException;
import com.geoway.jckj.biz.entity.SysUser;
import com.geoway.jckj.biz.mapper.SysRegionMapper;
import com.geoway.jckj.biz.service.dev.unity.IUnityUserTelService;
import com.geoway.sso.client.config.ProjectConfig;
import com.geoway.sso.client.rpc.RpcAccessToken;
import com.geoway.sso.client.rpc.SsoUser;
import com.geoway.sso.server.common.AccessTokenContent;
import com.geoway.sso.server.common.CodeContent;
import com.geoway.sso.server.session.AccessTokenManager;
import com.geoway.sso.server.session.RefreshTokenManager;
import com.geoway.sso.server.session.TicketGrantingTicketManager;
import com.uc.sso.UserCenterClient;
import com.uc.sso.entity.UserCenterResponse;
import com.uc.sso.entity.request.UserCenterRequest;
import com.uc.sso.entity.response.TokenInfo;
import com.uc.sso.entity.response.UserInfo;
import io.swagger.annotations.Api;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import springfox.documentation.annotations.ApiIgnore;

@Api(tags={"\u90e8\u56fd\u9645\u5e73\u53f0\u5355\u70b9\u767b\u5165"})
@Controller
@RequestMapping(value={"/bgjptSSO"})
public class BgjptLoginController {
    private static final Logger log = LoggerFactory.getLogger(BgjptLoginController.class);
    @Autowired
    private AccessTokenManager accessTokenManager;
    @Autowired
    private RefreshTokenManager refreshTokenManager;
    @Autowired
    private TicketGrantingTicketManager ticketGrantingTicketManager;
    @Autowired
    private SysRegionMapper sysRegionMapper;
    @Autowired
    private ProjectConfig projectConfig;
    @Value(value="${bgjpt.oauth2.issuer-uri:}")
    private String bgjptUrl;
    @Value(value="${bgjpt.oauth2.cer-path:}")
    private String bgjptCerPath;
    @Value(value="${bgjpt.oauth2.redirect-uri:}")
    private String bgjptRedirectUrl;
    @Autowired
    private IUnityUserTelService unityUserTelService;
    private static Map<String, String> redirectUrlMap = new ConcurrentHashMap<String, String>();

    @ApiIgnore
    @GetMapping(value={"/login"})
    public String login(HttpServletRequest request, String redirect_url) throws Exception {
        redirect_url = URLDecoder.decode(redirect_url, "UTF-8");
        String state = UUID.randomUUID().toString();
        redirectUrlMap.put(state, redirect_url);
        redirect_url = String.format("%s?backUrl=%s?state=%s", this.bgjptUrl, this.bgjptRedirectUrl, state);
        log.error("\u56de\u8c03\u5730\u5740\uff1aredirect:" + redirect_url);
        return "redirect:" + redirect_url;
    }

    @ApiIgnore
    @GetMapping(value={"/loginProcessing"})
    public String loginProcessing(HttpServletRequest request, HttpServletResponse httpResponse, String code, String state, String ticket) throws Exception {
        if (StrUtil.isBlank((CharSequence)this.bgjptCerPath)) {
            this.bgjptCerPath = "tls/uc-sso.cer";
        }
        UserCenterClient.init((String)this.bgjptCerPath);
        UserCenterClient ucClient = UserCenterClient.getInstance();
        UserCenterRequest ucRequest = new UserCenterRequest();
        ucRequest.setTicket(ticket);
        UserCenterResponse tokenRes = ucClient.getTokenByTicket(ucRequest);
        if (tokenRes.getSuccess()) {
            ucRequest = new UserCenterRequest();
            ucRequest.setToken(((TokenInfo)tokenRes.getData()).getToken());
            UserCenterResponse userRes = ucClient.getUserInfo(ucRequest);
            if (userRes.getSuccess()) {
                SsoUser ssoUser = new SsoUser();
                SysUser user = this.unityUserTelService.query(((UserInfo)userRes.getData()).getTelPhone());
                List regions = this.sysRegionMapper.queryUserRegions(user.getId());
                String regionCode = regions.stream().map(i -> i.getCode()).collect(Collectors.joining(","));
                String regionName = regions.stream().map(i -> i.getName()).collect(Collectors.joining(","));
                ssoUser.setId(user.getId());
                ssoUser.setUserid(user.getId());
                ssoUser.setUserName(user.getName());
                ssoUser.setLoginName(user.getAname());
                ssoUser.setRegionCode(regionCode);
                ssoUser.setRegionName(regionName);
                ssoUser.setToken(((TokenInfo)tokenRes.getData()).getToken());
                ssoUser.setSource(UserSysEnum.GTDJ.value);
                String tgt = this.ticketGrantingTicketManager.generate(ssoUser);
                CodeContent codeContent = new CodeContent(tgt, false, null);
                AccessTokenContent authDto = new AccessTokenContent(codeContent, ssoUser, this.projectConfig.getSsoAppId(), null);
                String redirect_url = redirectUrlMap.get(state);
                redirectUrlMap.remove(state);
                redirect_url = URLDecoder.decode(redirect_url, "UTF-8");
                redirect_url = this.authRedirectUri(redirect_url, ((TokenInfo)tokenRes.getData()).getToken());
                this.genereateRpcAccessToken(authDto, "");
                log.error("\u56de\u8c03\u5730\u5740\uff1aredirect:" + redirect_url);
                return "redirect:" + redirect_url;
            }
            throw new ServiceException("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25\uff01");
        }
        throw new ServiceException("\u83b7\u53d6token\u5931\u8d25\uff01");
    }

    private String authRedirectUri(String redirectUri, String code) throws UnsupportedEncodingException {
        StringBuilder sbf = new StringBuilder(redirectUri);
        if (redirectUri.indexOf("?") > -1) {
            sbf.append("&");
        } else {
            sbf.append("?");
        }
        sbf.append("token").append("=").append(code);
        return URLDecoder.decode(sbf.toString(), "utf-8");
    }

    private RpcAccessToken genereateRpcAccessToken(AccessTokenContent accessTokenContent, String accessToken) {
        String newAccessToken = accessToken;
        if (newAccessToken == null || !this.accessTokenManager.refresh(newAccessToken)) {
            newAccessToken = this.accessTokenManager.generate(accessTokenContent);
        }
        String refreshToken = this.refreshTokenManager.generate(accessTokenContent, newAccessToken);
        AccessTokenContent tokenContent = this.accessTokenManager.get(newAccessToken);
        tokenContent.setRefreshToken(refreshToken);
        this.accessTokenManager.create(newAccessToken, tokenContent);
        return new RpcAccessToken(newAccessToken, this.accessTokenManager.getExpiresIn(), refreshToken, accessTokenContent.getUser());
    }
}

