/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.jckj.biz.bgjpt.controller;

import cn.hutool.core.util.StrUtil;
import com.geoway.jckj.base.exception.ServiceException;
import com.geoway.jckj.base.support.encryption.AESUtils;
import com.geoway.jckj.biz.entity.SysUser;
import com.geoway.jckj.biz.enums.UserSysEnum;
import com.geoway.jckj.biz.service.dev.unity.IUnityUserTelService;
import com.geoway.jckj.biz.util.LoginUtil;
import com.geoway.jckj.biz.util.SysUserUtil;
import com.geoway.sso.client.rpc.SsoUser;
import com.uc.sso.UserCenterClient;
import com.uc.sso.entity.UserCenterResponse;
import com.uc.sso.entity.request.UserCenterRequest;
import com.uc.sso.entity.response.TokenInfo;
import com.uc.sso.entity.response.UserInfo;
import io.swagger.annotations.Api;
import java.net.URLDecoder;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import springfox.documentation.annotations.ApiIgnore;

@Api(tags={"\u90e8\u56fd\u9645\u5e73\u53f0\u5355\u70b9\u767b\u5165"})
@Controller
@RequestMapping(value={"/bgjptSSO"})
public class BgjptLoginController {
    private static final Logger log = LoggerFactory.getLogger(BgjptLoginController.class);
    @Value(value="${bgjpt.oauth2.issuer-uri:}")
    private String bgjptUrl;
    @Value(value="${bgjpt.oauth2.cer-path:}")
    private String bgjptCerPath;
    @Value(value="${bgjpt.oauth2.redirect-uri:}")
    private String bgjptRedirectUrl;
    @Autowired
    private IUnityUserTelService unityUserTelService;

    @ApiIgnore
    @GetMapping(value={"/login"})
    public String login(HttpServletRequest request, String redirect_url) throws Exception {
        redirect_url = URLDecoder.decode(redirect_url, "UTF-8");
        redirect_url = String.format("%s?backUrl=%s?state=%s", this.bgjptUrl, this.bgjptRedirectUrl, AESUtils.encrypt((String)redirect_url, (String)"FWAijk4A2Dwt2MKw"));
        log.error("\u56de\u8c03\u5730\u5740\uff1aredirect:" + redirect_url);
        return "redirect:" + redirect_url;
    }

    @ApiIgnore
    @GetMapping(value={"/loginProcessing"})
    public String loginProcessing(HttpServletRequest request, HttpServletResponse httpResponse, String code, String state, String ticket) throws Exception {
        if (StrUtil.isBlank((CharSequence)this.bgjptCerPath)) {
            this.bgjptCerPath = "tls/uc-sso.cer";
        }
        UserCenterClient.init((String)this.bgjptCerPath);
        UserCenterClient ucClient = UserCenterClient.getInstance();
        UserCenterRequest ucRequest = new UserCenterRequest();
        ucRequest.setTicket(ticket);
        UserCenterResponse tokenRes = ucClient.getTokenByTicket(ucRequest);
        if (tokenRes.getSuccess()) {
            ucRequest = new UserCenterRequest();
            ucRequest.setToken(((TokenInfo)tokenRes.getData()).getToken());
            UserCenterResponse userRes = ucClient.getUserInfo(ucRequest);
            if (userRes.getSuccess()) {
                SysUser user = this.unityUserTelService.query(((UserInfo)userRes.getData()).getTelPhone());
                if (user == null) {
                    user = SysUserUtil.getGuestUser();
                }
                SsoUser ssoUser = SysUserUtil.convertToSsoUser((SysUser)user);
                ssoUser.setToken(((TokenInfo)tokenRes.getData()).getToken());
                ssoUser.setSource(UserSysEnum.BGJPT.value);
                LoginUtil.genereateRpcAccessToken((SsoUser)ssoUser);
                String redirect_url = LoginUtil.authRedirectUri((String)AESUtils.decrypt((String)state, (String)"FWAijk4A2Dwt2MKw"), (String)((TokenInfo)tokenRes.getData()).getToken());
                log.error("\u56de\u8c03\u5730\u5740\uff1aredirect:" + redirect_url);
                return "redirect:" + redirect_url;
            }
            throw new ServiceException("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25\uff01");
        }
        throw new ServiceException("\u83b7\u53d6token\u5931\u8d25\uff01");
    }
}

