/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.jckj.biz.gtdc.util;

import cn.hutool.core.util.StrUtil;
import com.geoway.jckj.base.enums.UserSysEnum;
import com.geoway.jckj.biz.dto.UserSyncDTO;
import com.geoway.jckj.biz.entity.SysOrganization;
import com.geoway.jckj.biz.entity.SysUser;
import com.geoway.jckj.biz.entity.SysUserOrganization;
import com.geoway.jckj.biz.entity.SysUserRegion;
import com.geoway.landteam.platform.business.BusinessRes3Sdk;
import com.geoway.landteam.platform.business.res3.api.orguser.reso.BusUserDetailPager;
import com.geoway.landteam.platform.business.res3.api.orguser.reso.BusUserDetailReso;
import com.geoway.landteam.platform.business.res3.api.orguser.reso.BusUserSearchReso;
import com.geoway.landteam.platform.organization.OrganizationRes3Sdk;
import com.geoway.landteam.platform.organization.res3.api.reso.OrganizationPager;
import com.geoway.landteam.platform.organization.res3.api.reso.OrganizationReso;
import com.geoway.landteam.platform.organization.res3.api.reso.OrganizationSearchReso;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class GtdcUserUtil {
    private static final Logger log = LoggerFactory.getLogger(GtdcUserUtil.class);

    public UserSyncDTO getUserInfo() {
        List<BusUserDetailReso> busUserDetailResos = this.getAllBusUserDetail("");
        UserSyncDTO userSyncDTO = new UserSyncDTO();
        userSyncDTO.setOrgs(this.getSysOrganizations());
        userSyncDTO.setUsers(this.getSysUsers(busUserDetailResos));
        userSyncDTO.setUserOrgs(this.getAllSysUserOrganization(busUserDetailResos));
        userSyncDTO.setUserRoles(new ArrayList());
        userSyncDTO.setUserRegions(this.getAllSysUserRegions(busUserDetailResos));
        return userSyncDTO;
    }

    public UserSyncDTO getUserInfo(String userName) {
        List<BusUserDetailReso> busUserDetailResos = this.getAllBusUserDetail(userName);
        UserSyncDTO userSyncDTO = new UserSyncDTO();
        userSyncDTO.setOrgs(this.getSysOrganizations(busUserDetailResos.stream().map(f -> f.getOrgId()).collect(Collectors.toList())));
        userSyncDTO.setUsers(this.getSysUsers(busUserDetailResos));
        userSyncDTO.setUserOrgs(this.getAllSysUserOrganization(busUserDetailResos));
        userSyncDTO.setUserRoles(new ArrayList());
        userSyncDTO.setUserRegions(this.getAllSysUserRegions(busUserDetailResos));
        return userSyncDTO;
    }

    private List<BusUserDetailReso> getAllBusUserDetail() {
        BusUserSearchReso busUserSearchReso = new BusUserSearchReso();
        BusUserDetailPager busUserDetailPager = BusinessRes3Sdk.getOrgUserSelectRes3Service().listOrganizationAndBusUserPage(busUserSearchReso, Integer.valueOf(1), Integer.valueOf(100000));
        return busUserDetailPager.getList();
    }

    public SysUser getSysUser(String userName) {
        List<BusUserDetailReso> busUserDetailResos = this.getAllBusUserDetail(userName);
        List<SysUser> sysUsers = this.getSysUsers(busUserDetailResos);
        return sysUsers == null || sysUsers.size() == 0 ? null : sysUsers.get(0);
    }

    private List<BusUserDetailReso> getAllBusUserDetail(String userName) {
        BusUserSearchReso busUserSearchReso = new BusUserSearchReso();
        if (StrUtil.isNotBlank((CharSequence)userName)) {
            busUserSearchReso.setUserName(userName);
        }
        BusUserDetailPager busUserDetailPager = BusinessRes3Sdk.getOrgUserSelectRes3Service().listOrganizationAndBusUserPage(busUserSearchReso, Integer.valueOf(1), Integer.valueOf(100000));
        if (StrUtil.isNotBlank((CharSequence)userName)) {
            return busUserDetailPager.getList().stream().filter(f -> f.getUserName().equals(userName)).collect(Collectors.toList());
        }
        return busUserDetailPager.getList();
    }

    private List<SysUser> getSysUsers(List<BusUserDetailReso> busUserDetailResos) {
        ArrayList<SysUser> list = new ArrayList<SysUser>();
        HashMap<String, String> map = new HashMap<String, String>();
        for (BusUserDetailReso busUserDetailReso : busUserDetailResos) {
            if (map.containsKey(busUserDetailReso.getMidUserId())) continue;
            map.put(busUserDetailReso.getMidUserId(), busUserDetailReso.getMidUserId());
            SysUser sysUser = new SysUser();
            sysUser.setId(busUserDetailReso.getMidUserId());
            sysUser.setName(busUserDetailReso.getUserName());
            sysUser.setAname(busUserDetailReso.getRealName());
            sysUser.setTel(busUserDetailReso.getPhone());
            sysUser.setWorktel(busUserDetailReso.getPhone());
            sysUser.setEmail(busUserDetailReso.getEmail());
            sysUser.setBh("");
            sysUser.setZhiwu("");
            sysUser.setGanwei("0");
            sysUser.setZhiji("0");
            sysUser.setZhicheng("0");
            sysUser.setSex(0);
            sysUser.setWorktype("0");
            sysUser.setAddress("");
            sysUser.setStatus(Short.valueOf((short)0));
            sysUser.setCreatetime(new Date());
            sysUser.setUpdatetime(new Date());
            sysUser.setParams("");
            sysUser.setSource(UserSysEnum.GTDJ.value);
            sysUser.setImgid(null);
            sysUser.setCatalog(Integer.valueOf(3));
            list.add(sysUser);
        }
        return list;
    }

    private List<SysOrganization> getSysOrganizations(List<String> ids) {
        ArrayList<SysOrganization> organizations = new ArrayList<SysOrganization>();
        for (String id : ids) {
            OrganizationReso organizationReso = OrganizationRes3Sdk.getOrganizationSelectRes3Service().searchOrganizationById(id);
            organizations.add(this.praseSysOrganization(organizationReso));
        }
        return organizations;
    }

    private SysOrganization praseSysOrganization(OrganizationReso organizationReso) {
        SysOrganization sysOrganization = new SysOrganization();
        sysOrganization.setId(organizationReso.getOrgId());
        sysOrganization.setName(organizationReso.getOrgName());
        sysOrganization.setAname(organizationReso.getOrgName());
        String pid = organizationReso.getOrgPid();
        if (StrUtil.isBlank((CharSequence)pid)) {
            pid = "-1";
        }
        sysOrganization.setPid(pid);
        sysOrganization.setSort(organizationReso.getSeq());
        sysOrganization.setAllname(organizationReso.getPath());
        sysOrganization.setLevel(Integer.valueOf(organizationReso.getLevel() + 1));
        sysOrganization.setSource(UserSysEnum.GTDJ.value);
        return sysOrganization;
    }

    private List<SysOrganization> getSysOrganizations() {
        OrganizationPager organizationPager = OrganizationRes3Sdk.getOrganizationSelectRes3Service().searchOrganizationPage(new OrganizationSearchReso(), Integer.valueOf(1), Integer.valueOf(100000));
        ArrayList<SysOrganization> organizations = new ArrayList<SysOrganization>();
        for (OrganizationReso organizationReso : organizationPager.getList()) {
            organizations.add(this.praseSysOrganization(organizationReso));
        }
        return organizations;
    }

    private List<SysUserOrganization> getAllSysUserOrganization(List<BusUserDetailReso> busUserDetailResos) {
        ArrayList<SysUserOrganization> userOrgs = new ArrayList<SysUserOrganization>();
        for (BusUserDetailReso sysUser : busUserDetailResos) {
            SysUserOrganization userOrg = new SysUserOrganization();
            userOrg.setId(sysUser.getMidUserId() + "_" + sysUser.getOrgId());
            userOrg.setUserid(sysUser.getMidUserId());
            userOrg.setOrgid(sysUser.getOrgId());
            userOrgs.add(userOrg);
        }
        return userOrgs;
    }

    private List<SysUserRegion> getAllSysUserRegions(List<BusUserDetailReso> busUserDetailResos) {
        ArrayList<SysUserRegion> regions = new ArrayList<SysUserRegion>();
        for (BusUserDetailReso sysUser : busUserDetailResos) {
            SysUserRegion sysUserRegion = new SysUserRegion();
            sysUserRegion.setRegioncode(sysUser.getRegionCode());
            sysUserRegion.setUserid(sysUser.getMidUserId());
            regions.add(sysUserRegion);
        }
        return regions;
    }
}

