/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.jckj.biz.gtdc.service;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.IService;
import com.geoway.jckj.base.enums.UserSysEnum;
import com.geoway.jckj.biz.dto.UserSyncDTO;
import com.geoway.jckj.biz.entity.SysOrganization;
import com.geoway.jckj.biz.entity.SysUser;
import com.geoway.jckj.biz.entity.SysUserOrganization;
import com.geoway.jckj.biz.entity.SysUserRegion;
import com.geoway.jckj.biz.gtdc.util.GtdcUserUtil;
import com.geoway.jckj.biz.mapper.SysOrganizationMapper;
import com.geoway.jckj.biz.service.dev.base.IUserOrganizationService;
import com.geoway.jckj.biz.service.dev.base.impl.AbstractUserSyncService;
import com.geoway.jckj.biz.service.dev.unity.IUnityOrganizationService;
import com.geoway.jckj.biz.service.dev.unity.IUnityUserOrganizationService;
import com.geoway.jckj.biz.service.dev.unity.IUnityUserService;
import com.geoway.jckj.biz.service.sys.SysUserRegionService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class GtdcUserSyncServiceImpl
extends AbstractUserSyncService {
    @Autowired
    private SysUserRegionService sysUserRegionService;
    @Autowired
    private GtdcUserUtil gtdcUserService;
    @Autowired
    private SysOrganizationMapper sysOrganizationMapper;
    @Autowired
    private IUnityOrganizationService unityOrganizationService;
    @Autowired
    private IUnityUserOrganizationService unityUserOrganizationService;
    @Autowired
    private IUnityUserService unityUserService;

    @Transactional
    public String syncUserInfo(UserSyncDTO userInfo) {
        if (userInfo == null) {
            return "\u65e0\u7528\u6237\u4fe1\u606f\u9700\u8981\u540c\u6b65\uff01";
        }
        List<Object> stockUserIds = new ArrayList();
        int userNumber = 0;
        if (userInfo.getUsers() != null) {
            LambdaQueryWrapper userWarpper = Wrappers.lambdaQuery();
            userWarpper.eq(SysUser::getSource, (Object)this.getUserSystem());
            stockUserIds = ((IService)this.unityUserService.getLocalService()).list((Wrapper)userWarpper).stream().map(f -> f.getId()).collect(Collectors.toList());
            userNumber = userInfo.getUsers().size();
            ((IService)this.unityUserService.getLocalService()).remove((Wrapper)userWarpper);
            ((IService)this.unityUserService.getLocalService()).saveBatch((Collection)userInfo.getUsers());
        }
        int orgNumber = 0;
        if (userInfo.getOrgs() != null) {
            orgNumber = userInfo.getOrgs().size();
            LambdaQueryWrapper orgWarpper = Wrappers.lambdaQuery();
            orgWarpper.eq(SysOrganization::getSource, (Object)this.getUserSystem());
            ((IService)this.unityOrganizationService.getLocalService()).remove((Wrapper)orgWarpper);
            ((IService)this.unityOrganizationService.getLocalService()).saveBatch((Collection)userInfo.getOrgs());
        }
        int userOrgs = 0;
        if (userInfo.getUserOrgs() != null) {
            if (stockUserIds.size() > 0) {
                List idGroups = Lists.partition(stockUserIds, (int)1000);
                for (List ids : idGroups) {
                    LambdaQueryWrapper userOrgWarpper = Wrappers.lambdaQuery();
                    userOrgWarpper.in(SysUserOrganization::getUserid, (Collection)ids);
                    ((IService)this.unityUserOrganizationService.getLocalService()).remove((Wrapper)userOrgWarpper);
                }
            }
            userOrgs = userInfo.getUserOrgs().size();
            ((IUserOrganizationService)this.unityUserOrganizationService.getLocalService()).saveBatch(userInfo.getUserOrgs());
        }
        int userRegion = 0;
        if (userInfo.getUserRegions() != null) {
            userRegion = userInfo.getUserRegions().size();
            if (stockUserIds.size() > 0) {
                List idGroups = Lists.partition(stockUserIds, (int)1000);
                for (List ids : idGroups) {
                    LambdaQueryWrapper userRegionWarpper = Wrappers.lambdaQuery();
                    userRegionWarpper.in(SysUserRegion::getUserid, (Collection)ids);
                    this.sysUserRegionService.remove((Wrapper)userRegionWarpper);
                }
            }
            this.sysUserRegionService.saveBatch((Collection)userInfo.getUserRegions());
        }
        this.sysOrganizationMapper.resetIdPathFieldValue();
        return String.format("\u603b\u5171\u540c\u6b65\u4e86\uff1a%s\u4e2a\u7528\u6237,%s\u4e2a\u7ec4\u7ec7\u673a\u6784\uff0c%s\u4e2a\u7528\u6237-\u7ec4\u7ec7\u673a\u6784\u5173\u7cfb,%s\u4e2a\u7528\u6237\u884c\u653f\u533a", userNumber, orgNumber, userOrgs, userRegion);
    }

    public void syncUserInfoByUserName(String userName) {
        UserSyncDTO userInfo = this.gtdcUserService.getUserInfo(userName);
        if (userInfo.getUsers() != null) {
            ((IService)this.unityUserService.getLocalService()).saveOrUpdateBatch((Collection)userInfo.getUsers());
        }
        if (userInfo.getOrgs() != null && userInfo.getOrgs().size() != 0) {
            ((IService)this.unityUserOrganizationService.getLocalService()).saveOrUpdateBatch((Collection)userInfo.getOrgs());
        }
        if (userInfo.getUserOrgs() != null && userInfo.getOrgs().size() != 0) {
            ((IService)this.unityUserOrganizationService.getLocalService()).saveOrUpdateBatch((Collection)userInfo.getUserOrgs());
        }
    }

    public UserSyncDTO getUserInfo() {
        return this.gtdcUserService.getUserInfo();
    }

    public String getUserSystem() {
        return UserSysEnum.GTDJ.value;
    }
}

