/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.jckj.biz.local.service;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.geoway.jckj.base.exception.ServiceException;
import com.geoway.jckj.biz.entity.SysUser;
import com.geoway.jckj.biz.local.mapper.SysUserMapper;
import com.geoway.jckj.biz.service.dev.base.IUserTelService;
import com.geoway.jckj.biz.util.PhoneNumberUtil;
import com.geoway.jckj.biz.util.SysUserUtil;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="localUserTelService")
public class LocalUserTelServiceImpl
implements IUserTelService {
    @Autowired
    private SysUserMapper sysUserMapper;
    @Autowired
    private PhoneNumberUtil phoneNumberUtil;

    public void encrypt(String phone) {
        try {
            LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
            if (StrUtil.isNotBlank((CharSequence)phone)) {
                queryWrapper.eq(SysUser::getTel, (Object)phone);
                queryWrapper.or();
                queryWrapper.eq(SysUser::getWorktel, (Object)phone);
            }
            List users = this.sysUserMapper.selectList((Wrapper)queryWrapper);
            for (SysUser user : users) {
                if (user.getTel().contains("****")) continue;
                try {
                    user.setTelEncrypt(this.phoneNumberUtil.getEncryptPhoneNumber(user.getTel()));
                    user.setTel(this.phoneNumberUtil.getHidePhoneNumber(user.getTel()));
                    this.sysUserMapper.updateById(user);
                }
                catch (Exception ex) {
                    System.out.println(ex.getMessage());
                }
            }
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public void decrypt(String phone) {
        try {
            LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
            if (StrUtil.isNotBlank((CharSequence)phone)) {
                if (this.phoneNumberUtil.isTelEncrypt()) {
                    queryWrapper.eq(SysUser::getTelEncrypt, (Object)this.phoneNumberUtil.getEncryptPhoneNumber(phone));
                    queryWrapper.or();
                    queryWrapper.eq(SysUser::getWorktel, (Object)this.phoneNumberUtil.getEncryptPhoneNumber(phone));
                } else {
                    queryWrapper.eq(SysUser::getTel, (Object)phone);
                    queryWrapper.or();
                    queryWrapper.eq(SysUser::getWorktel, (Object)phone);
                }
            }
            List users = this.sysUserMapper.selectList((Wrapper)queryWrapper);
            for (SysUser user : users) {
                if (user.getTelEncrypt() == null) continue;
                try {
                    String tel = this.phoneNumberUtil.getDecryptPhoneNumber(user.getTelEncrypt());
                    LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
                    wrapper.set(SysUser::getTelEncrypt, null);
                    wrapper.set(SysUser::getTel, (Object)tel);
                    wrapper.eq(SysUser::getId, (Object)user.getId());
                    this.sysUserMapper.update(user, (Wrapper)wrapper);
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public SysUser query(String phone) {
        try {
            LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
            if (this.phoneNumberUtil.isTelEncrypt()) {
                queryWrapper.eq(SysUser::getTelEncrypt, (Object)this.phoneNumberUtil.getEncryptPhoneNumber(phone));
                queryWrapper.or();
                queryWrapper.eq(SysUser::getWorktel, (Object)this.phoneNumberUtil.getEncryptPhoneNumber(phone));
            } else {
                queryWrapper.eq(SysUser::getTel, (Object)phone);
                queryWrapper.or();
                queryWrapper.eq(SysUser::getWorktel, (Object)phone);
            }
            List users = this.sysUserMapper.selectList((Wrapper)queryWrapper);
            if (users == null || users.size() == 0) {
                return null;
            }
            SysUserUtil.wrapperUserCatalogs((List)users);
            SysUser user = (SysUser)users.get(0);
            return user;
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
    }
}

