/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.jckj.biz.local.service;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.geoway.jckj.base.exception.ServiceException;
import com.geoway.jckj.base.support.Pair;
import com.geoway.jckj.biz.dto.AppOneLoginDTO;
import com.geoway.jckj.biz.entity.SysUser;
import com.geoway.jckj.biz.entity.SysUserSecurity;
import com.geoway.jckj.biz.local.mapper.SysUserMapper;
import com.geoway.jckj.biz.mapper.SysUserSecurityMapper;
import com.geoway.jckj.biz.service.dev.base.IUserTelService;
import com.geoway.jckj.biz.service.dev.base.impl.AbstractLoginServiceImpl;
import com.geoway.jckj.biz.service.dev.unity.IUnityUserTelService;
import com.geoway.jckj.biz.service.login.IAppOneLoginService;
import com.geoway.jckj.biz.service.login.ICAService;
import com.geoway.jckj.biz.service.login.ISmsCaptchaService;
import com.geoway.jckj.biz.util.PasswordUtil;
import com.geoway.jckj.biz.util.PhoneNumberUtil;
import com.geoway.sso.client.rpc.Result;
import com.geoway.sso.client.rpc.SsoUser;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="userService")
public class LocalLoginServiceImpl
extends AbstractLoginServiceImpl {
    @Autowired
    private SysUserMapper sysUserMapper;
    @Autowired
    private SysUserSecurityMapper sysUserSecurityMapper;
    @Autowired
    private PasswordUtil passwordUtil;
    @Autowired
    private PhoneNumberUtil phoneNumberUtil;
    @Autowired
    private ISmsCaptchaService smsCaptchaService;
    @Autowired
    private IUnityUserTelService unityUserTelService;
    @Autowired
    private ICAService icaService;
    @Autowired
    private IAppOneLoginService appOneLoginService;
    @Value(value="${password.security.enable:false}")
    private Boolean securityEnable;
    @Value(value="${password.security.expireDays:90}")
    private int expireDays;

    public Result<SsoUser> loginByOne(String processId, String token, String authCode, HttpServletRequest req) {
        AppOneLoginDTO result = this.appOneLoginService.validate(processId, token, authCode);
        if (!result.isSucceed()) {
            return Result.createError((String)result.getMessage());
        }
        String tel = result.getTel();
        SysUser loginUser = ((IUserTelService)this.unityUserTelService.getLocalService()).query(tel);
        if (loginUser == null) {
            return Result.createError((String)"\u6b64\u624b\u673a\u53f7\u7801\u672a\u6ce8\u518c");
        }
        if (!loginUser.getStatus().toString().equals("1")) {
            return Result.createError((String)"\u7528\u6237\u5df2\u505c\u7528\u6216\u8005\u72b6\u6001\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01");
        }
        return Result.createSuccess((Object)this.convertToSsoUser(loginUser));
    }

    public Result<SsoUser> loginByCa(String caUserCert, String caOauthName, HttpServletRequest req) {
        Pair result = this.icaService.validate(caUserCert, caOauthName);
        if (!((Boolean)result.getKey()).booleanValue()) {
            return Result.createError((String)((String)result.getValue()));
        }
        String sfz = (String)result.getValue();
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(SysUser::getCertificateCode, (Object)sfz);
        queryWrapper.last(" limit 1");
        SysUser loginUser = (SysUser)this.sysUserMapper.selectOne((Wrapper)queryWrapper);
        if (loginUser == null) {
            return Result.createError((String)"\u6b64\u8bc1\u4e66\u672a\u5173\u8054\u5230\u7528\u6237");
        }
        if (!loginUser.getStatus().toString().equals("1")) {
            return Result.createError((String)"\u7528\u6237\u5df2\u505c\u7528\u6216\u8005\u72b6\u6001\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01");
        }
        return Result.createSuccess((Object)this.convertToSsoUser(loginUser));
    }

    public Result<SsoUser> loginBySms(String phoneNumber, String uuid, String verifyCode, HttpServletRequest req) {
        if (phoneNumber == null || phoneNumber.equals("")) {
            return Result.createError((String)"\u624b\u673a\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (verifyCode == null || verifyCode.equals("") || verifyCode.length() != 6) {
            return Result.createError((String)"\u9a8c\u8bc1\u7801\u4e0d\u80fd\u4e3a\u7a7a,\u4e14\u957f\u5ea6\u5fc5\u987b\u662f6\u4f4d\uff01\uff01");
        }
        Pair pair = this.smsCaptchaService.validateCaptcha(uuid, verifyCode);
        if (!((Boolean)pair.getKey()).booleanValue()) {
            return Result.createError((String)((String)pair.getValue()));
        }
        SysUser loginUser = ((IUserTelService)this.unityUserTelService.getLocalService()).query(phoneNumber);
        if (loginUser == null) {
            return Result.createError((String)"\u6b64\u624b\u673a\u53f7\u7801\u672a\u6ce8\u518c");
        }
        if (!loginUser.getStatus().toString().equals("1")) {
            return Result.createError((String)"\u7528\u6237\u5df2\u505c\u7528\u6216\u8005\u72b6\u6001\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01");
        }
        return Result.createSuccess((Object)this.convertToSsoUser(loginUser));
    }

    public Result<SsoUser> login(String username, String password, String uuid, String code, HttpServletRequest req) {
        this.validateCaptcha(uuid, code);
        return this.checkLogin(username, password, null);
    }

    protected Result<SsoUser> checkLogin(String username, String password, List<String> sources) {
        try {
            LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
            queryWrapper.eq(SysUser::getName, (Object)username);
            if (this.phoneNumberUtil.isTelEncrypt()) {
                ((LambdaQueryWrapper)queryWrapper.or()).eq(SysUser::getTelEncrypt, (Object)this.phoneNumberUtil.getEncryptPhoneNumber(username));
            } else {
                ((LambdaQueryWrapper)queryWrapper.or()).eq(SysUser::getTel, (Object)username);
            }
            if (sources != null && sources.size() != 0) {
                queryWrapper.and(gw -> {
                    LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)gw.in(SysUser::getSource, (Collection)sources);
                });
            }
            queryWrapper.last(" limit 1");
            SysUser user = (SysUser)this.sysUserMapper.selectOne((Wrapper)queryWrapper);
            if (user == null || user.getId() == null) {
                return Result.createError((String)"\u7528\u6237\u4e0d\u5b58\u5728\u6216\u8005\u5bc6\u7801\u9519\u8bef");
            }
            if (!user.getStatus().toString().equals("1")) {
                return Result.createError((String)"\u7528\u6237\u5df2\u505c\u7528\u6216\u8005\u72b6\u6001\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01");
            }
            SysUserSecurity sysUserSecurity = (SysUserSecurity)this.sysUserSecurityMapper.selectOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"f_id", (Object)user.getId())).eq((Object)"f_password", (Object)this.passwordUtil.getMD5Password(password)));
            if (sysUserSecurity == null) {
                return Result.createErrorPassword((String)"\u7528\u6237\u4e0d\u5b58\u5728\u6216\u8005\u5bc6\u7801\u9519\u8bef\u3002");
            }
            Result result = Result.createSuccess((Object)this.convertToSsoUser(user));
            if (this.securityEnable.booleanValue()) {
                boolean isExipred = false;
                if (sysUserSecurity.getExpiretime() != null && sysUserSecurity.getExpiretime().getTime() < System.currentTimeMillis()) {
                    isExipred = true;
                }
                if (isExipred) {
                    result.setCode(3003);
                    result.setMessage("\u5bc6\u7801\u5df2\u8fc7\u671f\uff0c\u9700\u8981\u4fee\u6539\u5bc6\u7801\u624d\u80fd\u4f7f\u7528!");
                }
            }
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ServiceException(e.getMessage(), (Throwable)e);
        }
    }
}

