/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.jckj.biz.wxwork.controller;

import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpUtil;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.geoway.jckj.base.enums.UserSysEnum;
import com.geoway.jckj.base.exception.ServiceException;
import com.geoway.jckj.biz.entity.SysUser;
import com.geoway.jckj.biz.mapper.SysRegionMapper;
import com.geoway.jckj.biz.service.dev.unity.IUnityUserTelService;
import com.geoway.sso.client.provider.RpcClientInfoProvider;
import com.geoway.sso.client.rpc.RpcAccessToken;
import com.geoway.sso.client.rpc.SsoUser;
import com.geoway.sso.server.common.AccessTokenContent;
import com.geoway.sso.server.common.CodeContent;
import com.geoway.sso.server.session.AccessTokenManager;
import com.geoway.sso.server.session.RefreshTokenManager;
import com.geoway.sso.server.session.TicketGrantingTicketManager;
import io.swagger.annotations.Api;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import springfox.documentation.annotations.ApiIgnore;

@Api(tags={"\u90e8\u56fd\u9645\u5e73\u53f0\u5355\u70b9\u767b\u5165"})
@Controller
@RequestMapping(value={"/wxworkSSO"})
public class WxWorkLoginController {
    private static final Logger log = LoggerFactory.getLogger(WxWorkLoginController.class);
    @Autowired
    private AccessTokenManager accessTokenManager;
    @Autowired
    private RefreshTokenManager refreshTokenManager;
    @Autowired
    private TicketGrantingTicketManager ticketGrantingTicketManager;
    @Autowired
    private SysRegionMapper sysRegionMapper;
    @Autowired
    private RpcClientInfoProvider rpcClientInfoProvider;
    @Value(value="${wxwork.oauth2.corpid:}")
    private String corpid;
    @Value(value="${wxwork.oauth2.corpsecret:}")
    private String corpsecret;
    @Value(value="${wxwork.oauth2.redirect-uri:}")
    private String corRedirectUrl;
    @Autowired
    private IUnityUserTelService unityUserTelService;

    @ApiIgnore
    @GetMapping(value={"/login"})
    public String login(HttpServletRequest request, String redirect_url, String code) throws Exception {
        redirect_url = URLDecoder.decode(redirect_url, "UTF-8");
        String state = UUID.randomUUID().toString();
        redirect_url = String.format("%s?backUrl=%s&code=%s", this.corRedirectUrl, redirect_url, code);
        log.error("\u56de\u8c03\u5730\u5740\uff1aredirect:" + redirect_url);
        return "redirect:" + redirect_url;
    }

    @ApiIgnore
    @GetMapping(value={"/loginProcessing"})
    public String loginProcessing(HttpServletRequest request, HttpServletResponse httpResponse, String code, String backUrl) throws Exception {
        if (StrUtil.isBlank((CharSequence)code)) {
            throw new ServiceException("\u4f01\u4e1a\u5fae\u4fe1\u767b\u5165\uff1a\u83b7\u53d6code\u7801\u5931\u8d25\uff01");
        }
        String tokenUrl = String.format("https://qyapi.weixin.qq.com/cgi-bin/gettoken?corpid=%s&corpsecret=%s", this.corpid, this.corpsecret);
        log.info("\u83b7\u53d6\u5fae\u4fe1token\u8bf7\u6c42\u5730\u5740\uff1a" + tokenUrl);
        String result = HttpUtil.get((String)tokenUrl);
        log.info("\u83b7\u53d6\u5fae\u4fe1token\u8bf7\u6c42\u7ed3\u679c\uff1a" + result);
        if (StrUtil.isBlank((CharSequence)result)) {
            throw new ServiceException("\u4f01\u4e1a\u5fae\u4fe1\u767b\u5165\uff1a\u83b7\u53d6token\u5931\u8d25\uff01");
        }
        JSONObject tokenObject = JSONUtil.parseObj((String)result);
        if (tokenObject == null) {
            throw new ServiceException("\u4f01\u4e1a\u5fae\u4fe1\u767b\u5165\uff1a\u83b7\u53d6token\u5931\u8d25:" + result);
        }
        if (!tokenObject.containsKey((Object)"access_token")) {
            throw new ServiceException("\u4f01\u4e1a\u5fae\u4fe1\u767b\u5165\uff1a\u83b7\u53d6token\u5931\u8d25:" + result);
        }
        String accessToken = tokenObject.getStr((Object)"access_token");
        String userInfoUrl = String.format("https://qyapi.weixin.qq.com/cgi-bin/user/getuserinfo?access_token=%s&code=%s", accessToken, code);
        log.info("\u83b7\u53d6\u4f01\u4e1a\u5fae\u4fe1\u7528\u6237id\u8bf7\u6c42\u5730\u5740\uff1a" + userInfoUrl);
        String userResult = HttpUtil.get((String)userInfoUrl);
        log.info("\u83b7\u53d6\u4f01\u4e1a\u5fae\u4fe1\u7528\u6237id\u8bf7\u6c42\u7ed3\u679c\uff1a" + userResult);
        if (StrUtil.isBlank((CharSequence)userResult)) {
            throw new ServiceException("\u4f01\u4e1a\u5fae\u4fe1\u767b\u5165\uff1a\u83b7\u53d6\u7528\u6237id\u5931\u8d25\uff01");
        }
        JSONObject userJsonObject = JSONUtil.parseObj((String)userResult);
        if (!userJsonObject.containsKey((Object)"UserId")) {
            throw new ServiceException("\u4f01\u4e1a\u5fae\u4fe1\u767b\u5165\uff1a\u83b7\u53d6\u7528\u6237id\u5931\u8d25:" + userResult);
        }
        String userId = userJsonObject.getStr((Object)"UserId");
        String detailUrl = String.format("https://qyapi.weixin.qq.com/cgi-bin/user/get?access_token=%s&userid=%s", accessToken, userId);
        log.info("\u83b7\u53d6\u4f01\u4e1a\u5fae\u4fe1\u7528\u6237\u4fe1\u606f\u8bf7\u6c42\u5730\u5740\uff1a" + detailUrl);
        String detailResult = HttpUtil.get((String)detailUrl);
        log.info("\u83b7\u53d6\u4f01\u4e1a\u5fae\u4fe1\u7528\u6237\u4fe1\u606f\u8bf7\u6c42\u7ed3\u679c\uff1a" + detailResult);
        JSONObject detailJsonObject = JSONUtil.parseObj((String)detailResult);
        if (!detailJsonObject.containsKey((Object)"mobile")) {
            throw new ServiceException("\u4f01\u4e1a\u5fae\u4fe1\u767b\u5165\uff1a\u83b7\u53d6\u7528\u6237\u8be6\u60c5\u5931\u8d25:" + detailResult);
        }
        String telPhone = detailJsonObject.getStr((Object)"mobile");
        SsoUser ssoUser = new SsoUser();
        SysUser user = this.unityUserTelService.query(telPhone);
        if (user == null) {
            throw new ServiceException("\u7528\u6237\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        List regions = this.sysRegionMapper.queryUserRegions(user.getId());
        String regionCode = regions.stream().map(i -> i.getCode()).collect(Collectors.joining(","));
        String regionName = regions.stream().map(i -> i.getName()).collect(Collectors.joining(","));
        ssoUser.setId(user.getId());
        ssoUser.setUserid(user.getId());
        ssoUser.setUserName(user.getAname());
        ssoUser.setLoginName(user.getName());
        ssoUser.setRegionCode(regionCode);
        ssoUser.setRegionName(regionName);
        ssoUser.setToken(accessToken);
        ssoUser.setSource(UserSysEnum.GTDJ.value);
        ssoUser.setUserCatalog(user.getCatalog());
        String tgt = this.ticketGrantingTicketManager.generate(ssoUser);
        CodeContent codeContent = new CodeContent(tgt, false, null);
        AccessTokenContent authDto = new AccessTokenContent(codeContent, ssoUser, this.rpcClientInfoProvider.getRpcClientInfo().getAppId(), null);
        backUrl = URLDecoder.decode(backUrl, "UTF-8");
        backUrl = this.authRedirectUri(backUrl, accessToken);
        this.genereateRpcAccessToken(authDto, "");
        log.error("\u56de\u8c03\u5730\u5740\uff1aredirect:" + backUrl);
        return "redirect:" + backUrl;
    }

    private String authRedirectUri(String redirectUri, String code) throws UnsupportedEncodingException {
        StringBuilder sbf = new StringBuilder(redirectUri);
        if (redirectUri.indexOf("?") > -1) {
            sbf.append("&");
        } else {
            sbf.append("?");
        }
        sbf.append("token").append("=").append(code);
        return URLDecoder.decode(sbf.toString(), "utf-8");
    }

    private RpcAccessToken genereateRpcAccessToken(AccessTokenContent accessTokenContent, String accessToken) {
        String newAccessToken = accessToken;
        if (newAccessToken == null || !this.accessTokenManager.refresh(newAccessToken)) {
            newAccessToken = this.accessTokenManager.generate(accessTokenContent);
        }
        String refreshToken = this.refreshTokenManager.generate(accessTokenContent, newAccessToken);
        AccessTokenContent tokenContent = this.accessTokenManager.get(newAccessToken);
        tokenContent.setRefreshToken(refreshToken);
        this.accessTokenManager.create(newAccessToken, tokenContent);
        return new RpcAccessToken(newAccessToken, this.accessTokenManager.getExpiresIn(), refreshToken, accessTokenContent.getUser());
    }
}

