package com.geoway.jckj.biz.service.dev.unity;

import cn.hutool.core.util.StrUtil;
import com.geoway.jckj.base.enums.UserSysEnum;
import com.geoway.jckj.base.support.spring.SpringUtils;
import com.geoway.jckj.biz.config.UserSystemConfig;
import com.geoway.jckj.biz.service.dev.base.IUserSystem;
import com.geoway.sso.client.constant.SsoConstant;
import com.geoway.sso.client.rpc.SsoUser;
import com.geoway.sso.client.util.CommonLoginUserUtil;
import com.geoway.sso.client.util.CookieUtils;
import com.geoway.sso.client.util.HttpServletUtil;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Component;

import javax.servlet.http.HttpServletRequest;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author 连世忠
 * @ClassName UserSysFactory
 * @Description TODO
 * @date 2025/4/30 10:37
 * @Version 1.0
 */
@Component
public class UnityUtil {

    private static UserSystemConfig userSystemConfig;


    private   static String localUserType = UserSysEnum.JCKJ.value;

    private static String defaultUserType="";

    public UnityUtil(UserSystemConfig userSystemConfig){

        UnityUtil.userSystemConfig = userSystemConfig;
        UnityUtil.defaultUserType=userSystemConfig.getUserSystem().get(0).getCode();
        //List<String> userTypes= Arrays.stream(ssoConfig.getLoginType().split(",")).collect(Collectors.toList());
        //UnityUtil.defaultUserType=userTypes.get(0);
    }

    public static <T extends IUserSystem> T getService(Class<T> type){
        String userType= getCurrentUserType();
        return getService(type,userType,true);
    }


    public static <T extends IUserSystem> T getDefaultService(Class<T> type){
        return getService(type, defaultUserType);
    }

    public static <T extends IUserSystem> T getLocalService(Class<T> type){
        return getService(type, localUserType);
    }
    public static <T extends IUserSystem> List<T> getServices(Class<T> type){
        List<String> userTypes= userSystemConfig.getUserSystem().stream().map(f->f.getCode()).collect(Collectors.toList());
        List<T>  beans= SpringUtils.getBeansOfType(type);
        beans= beans.stream().filter(f->userTypes.contains(f.getUserSystem())).collect(Collectors.toList());
        //Map<String,List<T>> groupBy=beans.stream().collect(Collectors.groupingBy(f->f.getUserType()));
        List<T> result=new ArrayList<>();
        for(String userType:userTypes){
            List<T> typeBeans=beans.stream().filter(f->f.getUserSystem().equals(userType)).collect(Collectors.toList());
            if(typeBeans.size()==0){
                continue;
            }
            if(typeBeans.size()==1){
                result.add(typeBeans.get(0));
                continue;
            }
            T temp=typeBeans.get(0);
            for (T service : typeBeans) {
                // 如果出现多个
                Class aClass = ((IUserSystem) service).getClass();
                Annotation annotation = aClass.getAnnotation(Primary.class);
                if (annotation != null) {
                    temp = service;
                    break;
                }
            }
            result.add(temp);
        }
        return result;
    }



    private  static <T extends IUserSystem> T getService(Class<T> type, String userType,boolean returnLocalType){
       T result=getService(type,userType);
       if(result==null&&returnLocalType){
           return getService(type, localUserType);
       }
       return result;
    }

    public  static <T extends IUserSystem> T getService(Class<T> type, String userType){
        List<T>  beans= SpringUtils.getBeansOfType(type);
        beans= beans.stream().filter(f->f.getUserSystem().equals(userType)).collect(Collectors.toList());
        if(beans.size()==0){
           return null;
        }
        T result=beans.get(0);
        if(beans.size()==1){
            return result;
        }
        for (T service : beans) {
            // 如果出现多个
            Class aClass = ((IUserSystem)service).getClass();
            Annotation annotation = aClass.getAnnotation(Primary.class);
            if(annotation != null){
                result=service;
                break;
            }
        }
        return result;
    }

    private static String getCurrentUserType(){
        // 获取当前http请求
        HttpServletRequest request = HttpServletUtil.getRequest();
        // 1. 优先从param参数中获取
        String parameterUserSys = request.getParameter(SsoConstant.PARAM_USER_SYS);
        // 不为空则直接返回param
        if (StrUtil.isNotBlank(parameterUserSys)) {
            return parameterUserSys;
        }

        // 2. 从header中获取
        String headerUserSys = request.getHeader(SsoConstant.HEADER_USER_SYS);
        if (StrUtil.isNotBlank(headerUserSys)) {
            return headerUserSys;
        }

        // 3. 从cookie中获取
        String cookieUserSys = CookieUtils.getCookie(request, SsoConstant.COOKIE_USER_SYS);
        if (StrUtil.isNotBlank(cookieUserSys)) {
            return cookieUserSys;
        }
        //从用户的登入信息中获取
        SsoUser ssoUser = CommonLoginUserUtil.getUser();
        String   userSys= ssoUser!=null?ssoUser.getSource(): localUserType;
        return userSys;
    }
    
}
