package com.geoway.jckj.biz.service.dev.unity.impl;

import cn.hutool.core.util.StrUtil;
import cn.hutool.cron.CronUtil;
import cn.hutool.cron.task.Task;
import com.geoway.jckj.biz.config.UserSystemConfig;
import com.geoway.jckj.biz.dto.UserSyncDTO;
import com.geoway.jckj.biz.entity.UserSystem;
import com.geoway.jckj.biz.enums.SyncModeEnum;
import com.geoway.jckj.biz.mapper.SysOrganizationMapper;
import com.geoway.jckj.biz.service.dev.base.IUserSyncService;
import com.geoway.jckj.biz.service.dev.unity.IUnityUserSyncService;
import com.geoway.jckj.biz.service.dev.unity.UnityUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.stream.Collectors;

/**
 * @author 连世忠
 * @ClassName UnityUserSyncServiceImpl
 * @Description TODO
 * @date 2025/4/30 16:48
 * @Version 1.0
 */
@Service
@Slf4j
public class UnityUserSyncServiceImpl extends UnityBaseImpl<IUserSyncService> implements IUnityUserSyncService {

    @Autowired
    private SysOrganizationMapper sysOrganizationMapper;
    @Autowired
    private UserSystemConfig userSystemConfig;
    @Override
    public void syncUserInfo() {
        List<UserSystem> userSystems=userSystemConfig.getUserSystem();
        userSystems=userSystems.stream().filter(f->
                        f.getSyncEnable()
                        &&f.getSyncMode().equals(SyncModeEnum.SYNC.getValue())
                        && StrUtil.isNotBlank(f.getSyncCron())).collect(Collectors.toList());
        if(userSystems.size()==0){
            log.info("-------无需同步用户------");
        }
        for(UserSystem userSystem:userSystems){
            IUserSyncService userSyncService= UnityUtil.getService(IUserSyncService.class,userSystem.getCode());
            if(userSyncService==null){
                log.warn(String.format("未找到用户体系【%s】的用户同步接口，请核查",userSystem.getName()));
            }

            CronUtil.schedule(userSystem.getSyncCron(),new Task(){
                @Override
                public void execute() {
                    try {
                        log.info(String.format("用户体系【%s】开始同步用户",userSystem.getName()));
                        UserSyncDTO userSyncDTO = userSyncService.getUserInfo();
                        String msg = userSyncService.syncUserInfo(userSyncDTO);
                        sysOrganizationMapper.resetIdPathFieldValue();
                        log.info(String.format("用户体系【%s】,同步用户结束:" + msg,userSystem.getName()));
                    }catch (Exception e){
                        log.error(String.format("用户体系【%s】同步用户异常",userSystem.getName()),e);
                    }
                }

            });
        }

        CronUtil.setMatchSecond(true);
        CronUtil.start(true);
    }
}
