package com.geoway.jckj.biz.service.login.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.geoway.jckj.base.config.SsoConfigProp;
import com.geoway.jckj.base.support.QrCodeUtils;
import com.geoway.jckj.base.support.RedisUtil;
import com.geoway.jckj.biz.service.login.IQrLoginService;
import com.geoway.sso.client.rpc.SsoUser;
import com.geoway.sso.client.util.CommonLoginUserUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.UUID;

/**
 * @author ALMJ
 * @desc
 * @date 2022/10/17 17:33
 */
@Service
public class QrLoginServiceImpl implements IQrLoginService {

    @Autowired
    SsoConfigProp ssoConfigProp;

    @Autowired
    private RedisUtil redisUtil;

    private  static  final String REDIS_QR_PREFIX="QR_";
    @Override
    public HashMap<String, Object> generateQrCode() throws Exception {
        HashMap<String, Object> map = new HashMap<>();
        JSONObject qrCOntent = new JSONObject();
        try {
            String uidKey =REDIS_QR_PREFIX + UUID.randomUUID().toString();
            int timeout = ssoConfigProp.getQrTimeout();
            //先redis 存个空值的key, 移动端登录时放值
            redisUtil.set(uidKey, "", timeout);
            qrCOntent.put("key", uidKey);
            qrCOntent.put("expires", timeout);
            qrCOntent.put("timestamp", System.currentTimeMillis());

            //从配置文件读取需要生成二维码的连接
            String baseQr = QrCodeUtils.getBase64QRCode(qrCOntent.toJSONString());
            map.put("qr", baseQr);
            map.put("key", uidKey);
            map.put("timestamp", System.currentTimeMillis());
            map.put("expires", timeout);
        } catch (Exception e) {
            e.printStackTrace();
            throw new Exception("生成登录二维码失败!");
        }
        return map;
    }

    @Override
    public SsoUser getLoginInfo(String key) throws Exception {
        String accessToken = (String) redisUtil.get(key);
        if(StrUtil.isNotEmpty(accessToken)){
            SsoUser user = CommonLoginUserUtil.getUser(accessToken);
            user.setToken(accessToken);
            redisUtil.del(key);
           return  user;
        }
        return null;
    }

    @Override
    public Boolean autoLogin(String accessToken, String key) {
        if(redisUtil.hasKey(key)){
            redisUtil.set(key,accessToken);
            return true;
        }
        return false;
    }
}
