package com.geoway.jckj.biz.service.sys;

import com.geoway.jckj.biz.entity.SysTenantMenu;
import com.baomidou.mybatisplus.extension.service.IService;

import java.util.List;

/**
* @author daidongdong
* @description 针对表【sys_tenant_menu(租户表)】的数据库操作Service
* @createDate 2025-01-09 17:52:35
*/
public interface SysTenantMenuService extends IService<SysTenantMenu> {
    /**
     * 查询特定租户下绑定了哪些菜单
     * @param tenantId
     * @param systemId
     * @return
     */
    List<SysTenantMenu> queryBindMenus(String tenantId, String systemId);

    /**
     * 给租户绑定菜单信息
     * @param tenantId
     * @param systemId
     * @param menus
     */
    void bindMenus(String tenantId, String systemId, List<SysTenantMenu> menus);
}
