package com.geoway.jckj.biz.service.sys;

import com.baomidou.mybatisplus.extension.service.IService;
import com.geoway.jckj.biz.entity.SysRegion;
import com.geoway.jckj.biz.entity.SysTenantMenu;
import com.geoway.jckj.biz.entity.SysTenantRegion;

import java.util.List;

/**
* @author daidongdong
* @description 针对表【sys_tenant_menu(租户表)】的数据库操作Service
* @createDate 2025-01-09 17:52:35
*/
public interface SysTenantRegionService extends IService<SysTenantRegion> {
    /**
     * 查询特定租户下绑定了哪些政区
     * @param tenantId
     * @return
     */
    List<SysRegion> queryBindRegions(String tenantId);
    /**
     * 租户绑定政区
     * @param tenantId
     * @param regionIds
     */
    void bindRegions(String tenantId, List<String> regionIds);

    /**
     * 租户绑定政区
     * @param tenantId
     * @param regionIds
     */
    void bindRegions(String tenantId, String regionIds);


}
