package com.geoway.jckj.biz.service.sys;

import com.geoway.jckj.biz.dto.AppMenuDTO;
import com.geoway.jckj.biz.dto.UserSysDTO;
import com.geoway.jckj.biz.entity.SysGroup;
import com.geoway.jckj.biz.entity.SysSystem;
import com.github.yulichang.extension.mapping.base.MPJDeepService;
import org.springframework.web.multipart.MultipartFile;

import java.util.HashMap;
import java.util.List;

/**
 * 系统
 * @author: wujing
 * @Date: 2021/11/11
 */
public interface SystemService extends MPJDeepService<SysSystem> {

    /**
     * 保存和编辑
     * @param sysNsSystem
     * @throws Exception
     */
    void saveOrUp(SysSystem sysNsSystem, MultipartFile logofile, MultipartFile bgfile) throws Exception;

    /**
     * 删除
     * @param id
     */
    void deleteSystem(String id) throws Exception;

    /**
     * 删除
     * @param ids
     */
    void deleteSystems(String ids) throws Exception;

    /**
     * 查询
     * @param key
     * @return
     */
    HashMap<String, Object> queryInfo(String key);

    /**
     * 查询列表
     * @param
     * @return
     */
    List<SysSystem> queryList() throws Exception;

    /**
     * 查询不在角色中的系统列表
     * @param roleId
     * @return
     * @throws Exception
     */
    List<SysSystem> queryListNotInRole(String roleId) throws Exception;

    /**
     * 查询所有
     * @param
     * @return
     */
    List<SysSystem> queryAll();

    /**
     * 状态管理
     * @param id
     * @param state
     */
    void stateUp(String id,Integer state);

    /**
     * 按分组查询系统列表
     * @return
     * @throws Exception
     */
    List<SysGroup> queryGroupSystems() throws Exception;


    HashMap<String, Object> querySystemInfoByUser(String key);
    /**
     * 查询用户授权的应用列表
     * @return
     */
    List<SysSystem> querySystemListByUser(String userId);



    /**
     * 保存系统分组
     * @param group
     * @throws Exception
     */
    void saveGroup(SysGroup group) throws Exception;

    /**
     * 保存
     * @param systemId
     * @param roleIds
     * @param menuIds
     */
    void saveRoleSystem(String systemId, List<String> roleIds,List<String> menuIds);
    /**
     * 删除系统分组
     * @param groupId
     * @throws Exception
     */
    void deleteGroup(String groupId) throws Exception;

    /**
     * 根据用户查询菜单树
     * @param key
     * @return
     */
    List<AppMenuDTO> queryAppMenus(String key) throws Exception;

    /**
     * 根据菜单key查询系统
     * @param key
     * @return
     */
    SysSystem querySystemByKey(String key);
}
