/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.jckj.biz.aspect;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.geoway.jckj.biz.entity.SysTenant;
import com.geoway.jckj.biz.util.TenantUtil;
import com.geoway.sso.client.annotation.RequireAuth;
import com.geoway.sso.client.enums.RoleLevelEnum;
import com.geoway.sso.client.rpc.SsoUser;
import com.geoway.sso.client.util.CommonLoginUserUtil;
import com.geoway.sso.client.util.HttpServletUtil;
import java.lang.reflect.Method;
import javax.servlet.http.HttpServletResponse;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;

@Aspect
@Service
@ConditionalOnExpression(value="#{T(com.geoway.sso.client.constant.SystemConstant).IS_SERVER}")
public class RequireAuthAspect {
    private static final Logger log = LoggerFactory.getLogger(RequireAuthAspect.class);

    @Pointcut(value="@within(com.geoway.sso.client.annotation.RequireAuth)")
    public void authClassPointCut() {
    }

    @Before(value="authClassPointCut()")
    public void beforeClassExec(JoinPoint joinPoint) {
        this.excute(joinPoint);
    }

    @Pointcut(value="@annotation(com.geoway.sso.client.annotation.RequireAuth)")
    public void authMethodPointCut() {
    }

    @Before(value="authMethodPointCut()")
    public void beforeMethodExec(JoinPoint joinPoint) {
        this.excute(joinPoint);
    }

    private void excute(JoinPoint joinPoint) {
        RequireAuth requireAuth = this.getAnnotationAuth(joinPoint);
        if (requireAuth == null || requireAuth.roleLevel() == RoleLevelEnum.None) {
            return;
        }
        SsoUser sysUser = CommonLoginUserUtil.getUser();
        if (sysUser == null) {
            this.markLoginResponse("\u7528\u6237\u65e0\u6743\u9650\u8bbf\u95ee");
            return;
        }
        switch (requireAuth.roleLevel()) {
            case superAdmin: {
                if (sysUser.getUserCatalog().equals(RoleLevelEnum.superAdmin.getValue())) {
                    return;
                }
                throw new RuntimeException("\u7528\u6237\u65e0\u6743\u9650\u8bbf\u95ee,\u9700\u7cfb\u7edf\u7ba1\u7406\u5458\u6743\u9650");
            }
            case tenantAdmin: {
                if (sysUser.getUserCatalog() > RoleLevelEnum.tenantAdmin.getValue()) {
                    throw new RuntimeException("\u7528\u6237\u65e0\u6743\u9650\u8bbf\u95ee,\u9700\u7ba1\u7406\u5458\u6743\u9650");
                }
                SysTenant sysTenant = TenantUtil.getTenant();
                if (sysTenant.getId().equals("0")) {
                    if (sysUser.getUserCatalog().equals(RoleLevelEnum.superAdmin.getValue())) break;
                    throw new RuntimeException("\u7528\u6237\u65e0\u6743\u9650\u8bbf\u95ee,\u9700\u7cfb\u7edf\u7ba1\u7406\u5458\u6743\u9650");
                }
                if (sysTenant.getUsers().stream().anyMatch(f -> f.getId().equals(sysUser.getUserid()))) break;
                throw new RuntimeException("\u7528\u6237\u65e0\u6743\u9650\u8bbf\u95ee,\u9700\u7ba1\u7406\u5458\u6743\u9650");
            }
        }
    }

    private RequireAuth getAnnotationAuth(JoinPoint joinPoint) {
        Signature signature = joinPoint.getSignature();
        MethodSignature methodSignature = (MethodSignature)signature;
        Method method = methodSignature.getMethod();
        RequireAuth requireAuth = null;
        if (method != null) {
            requireAuth = method.getAnnotation(RequireAuth.class);
        }
        if (requireAuth != null) {
            return requireAuth;
        }
        Class classT = methodSignature.getDeclaringType();
        if (classT != null) {
            requireAuth = classT.getAnnotation(RequireAuth.class);
        }
        return requireAuth;
    }

    private void markLoginResponse(String msg) {
        try {
            HttpServletResponse response = HttpServletUtil.getResponse();
            response.setStatus(HttpStatus.OK.value());
            response.setContentType("application/json");
            response.setCharacterEncoding("UTF-8");
            response.setHeader("Cache-Control", "no-cache, must-revalidate");
            JSONObject baseResopnse = new JSONObject();
            baseResopnse.put("code", (Object)2100);
            baseResopnse.put("status", (Object)"NEEDLOGIN");
            baseResopnse.put("message", (Object)"\u65e0\u6548token\u6216token\u5df2\u8fc7\u671f");
            if (StrUtil.isNotEmpty((CharSequence)msg)) {
                baseResopnse.put("message", (Object)msg);
            }
            String jsonResult = JSON.toJSONString((Object)baseResopnse, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteNullStringAsEmpty});
            response.getOutputStream().write(jsonResult.getBytes());
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }
}

