/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.jckj.biz.service.dev.unity.impl;

import cn.hutool.core.util.StrUtil;
import cn.hutool.cron.CronUtil;
import cn.hutool.cron.task.Task;
import com.geoway.jckj.biz.config.UserSystemConfig;
import com.geoway.jckj.biz.dto.UserSyncDTO;
import com.geoway.jckj.biz.entity.UserSystem;
import com.geoway.jckj.biz.enums.SyncModeEnum;
import com.geoway.jckj.biz.mapper.SysOrganizationMapper;
import com.geoway.jckj.biz.service.dev.base.IUserSyncService;
import com.geoway.jckj.biz.service.dev.unity.IUnityUserSyncService;
import com.geoway.jckj.biz.service.dev.unity.UnityUtil;
import com.geoway.jckj.biz.service.dev.unity.impl.UnityBaseImpl;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UnityUserSyncServiceImpl
extends UnityBaseImpl<IUserSyncService>
implements IUnityUserSyncService {
    private static final Logger log = LoggerFactory.getLogger(UnityUserSyncServiceImpl.class);
    @Autowired
    private SysOrganizationMapper sysOrganizationMapper;
    @Autowired
    private UserSystemConfig userSystemConfig;

    @Override
    public void syncUserInfo() {
        List<UserSystem> userSystems = this.userSystemConfig.getUserSystem();
        if ((userSystems = userSystems.stream().filter(f -> f.getSync() != null && f.getSync().getEnable() != false && SyncModeEnum.SYNC.getValue().equals(f.getSync().getMode()) && StrUtil.isNotBlank((CharSequence)f.getSync().getCron())).collect(Collectors.toList())).size() == 0) {
            log.info("-------\u65e0\u9700\u540c\u6b65\u7528\u6237------");
        }
        for (final UserSystem userSystem : userSystems) {
            final IUserSyncService userSyncService = UnityUtil.getService(IUserSyncService.class, userSystem.getCode());
            if (userSyncService == null) {
                log.warn(String.format("\u672a\u627e\u5230\u7528\u6237\u4f53\u7cfb\u3010%s\u3011\u7684\u7528\u6237\u540c\u6b65\u63a5\u53e3\uff0c\u8bf7\u6838\u67e5", userSystem.getName()));
            }
            CronUtil.schedule((String)userSystem.getSync().getCron(), (Task)new Task(){

                public void execute() {
                    try {
                        log.info(String.format("\u7528\u6237\u4f53\u7cfb\u3010%s\u3011\u5f00\u59cb\u540c\u6b65\u7528\u6237", userSystem.getName()));
                        UserSyncDTO userSyncDTO = userSyncService.getUserInfo();
                        String msg = userSyncService.syncUserInfo(userSyncDTO);
                        UnityUserSyncServiceImpl.this.sysOrganizationMapper.resetIdPathFieldValue();
                        log.info(String.format("\u7528\u6237\u4f53\u7cfb\u3010%s\u3011,\u540c\u6b65\u7528\u6237\u7ed3\u675f:" + msg, userSystem.getName()));
                    }
                    catch (Exception e) {
                        log.error(String.format("\u7528\u6237\u4f53\u7cfb\u3010%s\u3011\u540c\u6b65\u7528\u6237\u5f02\u5e38", userSystem.getName()), (Throwable)e);
                    }
                }
            });
        }
        CronUtil.setMatchSecond((boolean)true);
        CronUtil.start((boolean)true);
    }
}

