/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.jckj.biz.service.sys.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.servlet.ServletUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.geoway.jckj.base.support.query.MPJQueryMapperUtil;
import com.geoway.jckj.biz.entity.SaasEntity;
import com.geoway.jckj.biz.entity.SysMenu;
import com.geoway.jckj.biz.entity.SysOplog;
import com.geoway.jckj.biz.entity.SysSystem;
import com.geoway.jckj.biz.mapper.SysMenuMapper;
import com.geoway.jckj.biz.mapper.SysOplogMapper;
import com.geoway.jckj.biz.mapper.SysSystemMapper;
import com.geoway.jckj.biz.service.ISaasEntityService;
import com.geoway.jckj.biz.service.sys.SysOplogService;
import com.geoway.jckj.biz.util.TenantUtil;
import com.geoway.sso.client.rpc.SsoUser;
import com.geoway.sso.client.util.CommonLoginUserUtil;
import com.github.yulichang.wrapper.MPJLambdaWrapper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SysOplogServiceImpl
extends ServiceImpl<SysOplogMapper, SysOplog>
implements SysOplogService,
ISaasEntityService<SysOplog> {
    @Autowired
    SysSystemMapper sysSystemMapper;
    @Autowired
    SysMenuMapper sysMenuMapper;

    public boolean save(SysOplog entity) {
        this.wrapperEntity(entity);
        return super.save((Object)entity);
    }

    @Override
    public List<SysOplog> findByFilterParam(String filterParam) throws Exception {
        MPJLambdaWrapper<SysOplog> queryWrapper = this.buildLambdaWrapper(filterParam, "");
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public MPJLambdaWrapper<SysOplog> buildLambdaWrapper(String filterParam, String sortParam) {
        try {
            if (filterParam == null) {
                filterParam = "";
            }
            if (sortParam == null) {
                sortParam = "";
            }
            MPJQueryMapperUtil qmu = new MPJQueryMapperUtil();
            MPJLambdaWrapper queryWrapper = qmu.queryMapper(filterParam, sortParam, this.getClassT());
            if (TenantUtil.isSuperTenant()) {
                return queryWrapper;
            }
            queryWrapper.eq(SaasEntity::getTenantid, (Object)this.getTenantId());
            return queryWrapper;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public IPage<SysOplog> findPageByFilterParam(String filterParam, int page, int size) throws Exception {
        MPJLambdaWrapper<SysOplog> queryWrapper = this.buildLambdaWrapper(filterParam, "");
        queryWrapper.orderByDesc((Object)"f_createtime");
        Page pages = new Page((long)page, (long)size);
        return this.page((IPage)pages, (Wrapper)queryWrapper);
    }

    @Override
    public void addMenuOpLog(HttpServletRequest request, String systemKey, String menuId) {
        SsoUser sysUser = CommonLoginUserUtil.getUser();
        if (sysUser == null) {
            return;
        }
        SysSystem systemItem = this.queryNsSystemByKey(systemKey);
        if (systemItem == null) {
            return;
        }
        ArrayList<SysMenu> menuTree = new ArrayList<SysMenu>();
        this.buildMenuTree(menuId, menuTree);
        if (menuTree.size() == 0) {
            return;
        }
        CollectionUtil.reverse(menuTree);
        String opMenuName = menuTree.stream().map(i -> i.getName()).collect(Collectors.joining(" ->"));
        String ip = ServletUtil.getClientIP((HttpServletRequest)request, (String[])new String[0]);
        String opName = String.format("%s: %s\u8bbf\u95ee\u4e86\u7cfb\u7edf\u83dc\u5355(%s)", systemItem.getName(), sysUser.getUserName(), opMenuName);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("systemId", (Object)systemItem.getId());
        jsonObject.put("systemName", (Object)systemItem.getName());
        jsonObject.put("menuId", (Object)menuId);
        jsonObject.put("menuName", (Object)opMenuName);
        SysOplog sysOplog = new SysOplog();
        sysOplog.setUserid(sysUser.getUserid());
        sysOplog.setUsername(sysUser.getUserName());
        sysOplog.setMethod("openMenu");
        sysOplog.setParam(jsonObject.toJSONString());
        sysOplog.setIp(ip);
        sysOplog.setName(opName);
        sysOplog.setDetail(opMenuName);
        sysOplog.setOptype("openMenu");
        sysOplog.setCreatetime(new Date());
        sysOplog.setSystemid(systemItem.getId());
        sysOplog.setAppid(systemItem.getKey());
        this.save(sysOplog);
    }

    private SysSystem queryNsSystemByKey(String key) {
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(SysSystem::getKey, (Object)key);
        queryWrapper.last(" limit 1");
        return (SysSystem)this.sysSystemMapper.selectOne((Wrapper)queryWrapper);
    }

    private void buildMenuTree(String menuId, List<SysMenu> menuTree) {
        SysMenu sysMenu = (SysMenu)this.sysMenuMapper.selectById((Serializable)((Object)menuId));
        if (sysMenu == null) {
            return;
        }
        menuTree.add(sysMenu);
        if (StrUtil.isNotBlank((CharSequence)sysMenu.getPid()) || "-1".equals(sysMenu.getPid())) {
            this.buildMenuTree(sysMenu.getPid(), menuTree);
        }
    }
}

