/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.jckj.biz.service.sys.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.tree.TreeNodeConfig;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.geoway.jckj.base.config.SsoConfigProp;
import com.geoway.jckj.base.support.BaseTreeUtil;
import com.geoway.jckj.base.support.StringUtils;
import com.geoway.jckj.base.support.query.MPJQueryMapperUtil;
import com.geoway.jckj.biz.dto.AppMenuDTO;
import com.geoway.jckj.biz.entity.SaasEntity;
import com.geoway.jckj.biz.entity.SysGroup;
import com.geoway.jckj.biz.entity.SysImage;
import com.geoway.jckj.biz.entity.SysMenu;
import com.geoway.jckj.biz.entity.SysRole;
import com.geoway.jckj.biz.entity.SysRoleSystem;
import com.geoway.jckj.biz.entity.SysSystem;
import com.geoway.jckj.biz.entity.SysTheme;
import com.geoway.jckj.biz.entity.SysUserRole;
import com.geoway.jckj.biz.exception.BizException;
import com.geoway.jckj.biz.mapper.SysMenuMapper;
import com.geoway.jckj.biz.mapper.SysRoleSystemMapper;
import com.geoway.jckj.biz.mapper.SysSystemMapper;
import com.geoway.jckj.biz.service.ISaasEntityService;
import com.geoway.jckj.biz.service.dev.unity.IUnityMenuUrlHandlerService;
import com.geoway.jckj.biz.service.sys.SysGroupService;
import com.geoway.jckj.biz.service.sys.SysImageService;
import com.geoway.jckj.biz.service.sys.SysRoleMenuService;
import com.geoway.jckj.biz.service.sys.SysRoleService;
import com.geoway.jckj.biz.service.sys.SysRoleSystemService;
import com.geoway.jckj.biz.service.sys.SysTenantSystemService;
import com.geoway.jckj.biz.service.sys.SysThemeService;
import com.geoway.jckj.biz.service.sys.SysUserTenantService;
import com.geoway.jckj.biz.service.sys.SystemService;
import com.geoway.jckj.biz.service.sys.impl.SysMenuServiceImpl;
import com.geoway.jckj.biz.util.SaasEntityUtil;
import com.geoway.jckj.biz.util.SysSystemUtil;
import com.github.yulichang.base.MPJBaseServiceImpl;
import com.github.yulichang.interfaces.MPJBaseJoin;
import com.github.yulichang.wrapper.MPJLambdaWrapper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class SystemServiceImpl
extends MPJBaseServiceImpl<SysSystemMapper, SysSystem>
implements SystemService,
ISaasEntityService<SysSystem> {
    @Autowired
    private SysSystemMapper sysSystemMapper;
    @Autowired
    private SysMenuMapper menuMapper;
    @Autowired
    private SysMenuServiceImpl menuService;
    @Autowired
    private SysThemeService sysThemeService;
    @Autowired
    SysImageService sysImageService;
    @Autowired
    SysGroupService sysGroupService;
    @Autowired
    SysRoleService sysRoleService;
    @Autowired
    SysRoleSystemMapper sysRoleSystemMapper;
    @Autowired
    private SsoConfigProp ssoConfig;
    @Autowired
    SysTenantSystemService sysTenantSystemService;
    @Autowired
    SysUserTenantService sysUserTenantService;
    @Autowired
    SysRoleMenuService sysRoleMenuService;
    @Autowired
    SysRoleSystemService sysRoleSystemService;
    @Autowired
    IUnityMenuUrlHandlerService menuUrlHandlerService;

    @Override
    public void saveOrUp(SysSystem sysNsSystem, MultipartFile logofile, MultipartFile bgfile) throws Exception {
        SysImage sysImage;
        SysSystem one;
        if (StringUtils.isEmpty((String)sysNsSystem.getKey())) {
            throw new Exception("\u3010\u5173\u952e\u5b57\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(SysSystem::getKey, (Object)sysNsSystem.getKey());
        if (StringUtils.isNotEmpty((String)sysNsSystem.getId())) {
            wrapper.ne(SysSystem::getId, (Object)sysNsSystem.getId());
        }
        if ((one = (SysSystem)this.getOne((Wrapper)wrapper)) != null) {
            throw new Exception("\u5173\u952e\u5b57\u3010" + one.getKey() + "\u3011\u5df2\u5b58\u5728\uff01");
        }
        SysSystem exsitSystem = (SysSystem)this.getById((Serializable)((Object)sysNsSystem.getId()));
        if (exsitSystem == null) {
            this.wrapperEntity(sysNsSystem);
        }
        if (logofile != null && !logofile.isEmpty()) {
            sysImage = (SysImage)this.sysImageService.getById((Serializable)((Object)sysNsSystem.getLogoid()));
            if (sysImage == null) {
                sysImage = new SysImage();
                sysImage.setObjectid(sysNsSystem.getId());
                sysImage.setType(1);
            }
            sysImage.setImage(logofile.getBytes());
            this.sysImageService.saveOrUpdate(sysImage);
            sysNsSystem.setLogoid(sysImage.getId());
        }
        if (bgfile != null && !bgfile.isEmpty()) {
            sysImage = (SysImage)this.sysImageService.getById((Serializable)((Object)sysNsSystem.getBgid()));
            if (sysImage == null) {
                sysImage = new SysImage();
                sysImage.setObjectid(sysNsSystem.getId());
                sysImage.setType(1);
            }
            sysImage.setImage(bgfile.getBytes());
            this.sysImageService.saveOrUpdate(sysImage);
            sysNsSystem.setBgid(sysImage.getId());
        }
        if (exsitSystem == null || exsitSystem.getTenantid().equals(this.getTenantId())) {
            this.saveOrUpdate(sysNsSystem);
        } else {
            this.sysTenantSystemService.saveSystem(this.getTenantId(), sysNsSystem);
        }
    }

    @Override
    public void deleteSystem(String id) throws Exception {
        SysSystem sysNsSystem = (SysSystem)this.getById((Serializable)((Object)id));
        this.removeById((Serializable)((Object)id));
        LambdaQueryWrapper menuWrapper = Wrappers.lambdaQuery();
        menuWrapper.eq(SysMenu::getSystemId, (Object)sysNsSystem.getId());
        this.menuMapper.delete((Wrapper)menuWrapper);
        LambdaQueryWrapper queryWrapper2 = Wrappers.lambdaQuery();
        queryWrapper2.eq(SysRoleSystem::getSystemid, (Object)sysNsSystem.getId());
        this.sysRoleSystemMapper.delete((Wrapper)queryWrapper2);
    }

    @Override
    public void deleteSystems(String ids) throws Exception {
        String[] idArr;
        if (StrUtil.isBlank((CharSequence)ids)) {
            return;
        }
        for (String id : idArr = ids.split(",")) {
            this.deleteSystem(id);
        }
    }

    @Override
    public HashMap<String, Object> queryInfo(String key) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (StringUtils.isNotEmpty((String)key)) {
            LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
            wrapper.eq(SysSystem::getKey, (Object)key);
            SysSystem sysNsSystem = (SysSystem)this.getOne((Wrapper)wrapper);
            SysSystemUtil.wrapper(Collections.singletonList(sysNsSystem));
            if (sysNsSystem != null) {
                List<SysMenu> sysMenus = this.menuService.queryMenuTree(sysNsSystem.getId(), 0);
                List<SysMenu> uCenterMenu = this.menuService.queryMenuTree(sysNsSystem.getId(), 1);
                map.put("system", sysNsSystem);
                map.put("menu", sysMenus);
                map.put("uCenterMenu", uCenterMenu);
            } else {
                map = null;
            }
        }
        return map;
    }

    @Override
    public List<SysSystem> queryList() throws Exception {
        MPJLambdaWrapper<SysSystem> queryWrapper = this.buildLambdaWrapper("", "");
        List systems = this.list((Wrapper)queryWrapper);
        SysSystemUtil.wrapper(systems);
        return CollUtil.distinct((Collection)systems);
    }

    @Override
    public List<SysSystem> queryListNotInRole(String roleId) throws Exception {
        MPJLambdaWrapper<SysSystem> queryWrapper = this.buildLambdaWrapper("", "");
        if (StrUtil.isNotBlank((CharSequence)roleId)) {
            LambdaQueryWrapper queryWrapper2 = Wrappers.lambdaQuery();
            queryWrapper2.eq(SysRoleSystem::getRoleid, (Object)roleId);
            List sysRoleSystems = this.sysRoleSystemMapper.selectList((Wrapper)queryWrapper2);
            if (sysRoleSystems != null && sysRoleSystems.size() > 0) {
                List systemIds = sysRoleSystems.stream().map(item -> item.getSystemid()).collect(Collectors.toList());
                queryWrapper.notIn(SysSystem::getId, systemIds);
            }
        }
        List result = this.list((Wrapper)queryWrapper);
        SysSystemUtil.wrapper(result);
        return result;
    }

    @Override
    public List<SysSystem> queryAll() {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.orderByDesc(SysSystem::getCreatetime);
        List list = this.list((Wrapper)wrapper);
        for (SysSystem sysNsSystem : list) {
            List<SysMenu> sysMenus = this.menuService.queryMenuTree(sysNsSystem.getId(), 0);
            List<SysMenu> userMenus = this.menuService.queryMenuTree(sysNsSystem.getId(), 1);
            sysNsSystem.setSysMenu(sysMenus);
            sysNsSystem.setUCenterMenu(userMenus);
        }
        SysSystemUtil.wrapper(list);
        return list;
    }

    @Override
    public void stateUp(String id, Integer state) {
        LambdaUpdateWrapper update = Wrappers.lambdaUpdate();
        update.eq(SysSystem::getId, (Object)id);
        update.set(SysSystem::getState, (Object)state);
        this.update((Wrapper)update);
    }

    @Override
    public List<SysGroup> queryGroupSystems() throws Exception {
        List<SysSystem> systems = this.queryList();
        List groupIds = systems.stream().map(f -> f.getGroupid()).collect(Collectors.toList());
        MPJLambdaWrapper groupWrapper = this.sysGroupService.buildLambdaWrapper("", "");
        if (groupIds.size() > 0) {
            ((MPJLambdaWrapper)groupWrapper.or()).in(SysGroup::getId, groupIds);
        }
        List groups = this.sysGroupService.list((Wrapper)groupWrapper);
        SaasEntityUtil.wrapper(groups);
        for (SysGroup group : groups) {
            group.setSystems(systems.stream().filter(f -> f.getGroupid().equals(group.getId())).collect(Collectors.toList()));
        }
        return groups;
    }

    @Override
    public HashMap<String, Object> querySystemInfoByUser(String systemKey) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (StringUtils.isNotEmpty((String)systemKey)) {
            LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
            wrapper.eq(SysSystem::getKey, (Object)systemKey);
            wrapper.last(" limit 1");
            SysSystem systemOne = (SysSystem)this.getOne((Wrapper)wrapper);
            SysSystemUtil.wrapper(Collections.singletonList(systemOne));
            if (systemOne != null) {
                SysTheme themeOne = this.sysThemeService.findOne(systemOne.getThemeid());
                List<SysMenu> sysMenus = this.menuService.queryUserMenuTree(systemOne.getId(), 0);
                this.handlerMenuUrl(systemOne, themeOne, sysMenus);
                List<SysMenu> uCenterMenu = this.menuService.queryUserMenuTree(systemOne.getId(), 1);
                this.handlerMenuUrl(systemOne, themeOne, uCenterMenu);
                map.put("system", systemOne);
                map.put("theme", themeOne);
                map.put("menu", sysMenus);
                map.put("uCenterMenu", uCenterMenu);
            } else {
                map = null;
            }
        }
        return map;
    }

    private void handlerMenuUrl(SysSystem sysSystem, SysTheme sysTheme, List<SysMenu> sysMenus) {
        if (sysMenus == null) {
            return;
        }
        sysMenus.forEach(f -> {
            this.menuUrlHandlerService.handler(sysSystem, sysTheme, (SysMenu)f);
            this.handlerMenuUrl(sysSystem, sysTheme, f.getChildren());
        });
    }

    @Override
    public List<SysSystem> querySystemListByUser(String userId) {
        if (StrUtil.isBlank((CharSequence)userId)) {
            userId = this.getQueryUserId();
        }
        if (StrUtil.isBlank((CharSequence)userId)) {
            return null;
        }
        List<SysRole> sysRoles = this.sysRoleService.queryUserRoles(userId);
        if (sysRoles.size() == 0) {
            return null;
        }
        MPJLambdaWrapper<SysSystem> joinWrapper = this.buildLambdaWrapper("", "");
        joinWrapper.leftJoin(SysRoleSystem.class, SysRoleSystem::getSystemid, SysSystem::getId);
        joinWrapper.leftJoin(SysUserRole.class, SysUserRole::getRoleid, SysRoleSystem::getRoleid);
        joinWrapper.leftJoin(SysRole.class, SysRole::getId, SysRoleSystem::getRoleid);
        joinWrapper.eq(SysUserRole::getUserid, (Object)userId);
        joinWrapper.in(SysRole::getId, (Collection)sysRoles.stream().map(f -> f.getId()).collect(Collectors.toList()));
        List roleSystems = this.sysSystemMapper.selectJoinList(SysSystem.class, (MPJBaseJoin)joinWrapper);
        SysSystemUtil.wrapper(roleSystems);
        return CollUtil.distinct((Collection)roleSystems);
    }

    @Override
    public void saveGroup(SysGroup group) throws Exception {
        group.setType(1);
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(SysGroup::getType, (Object)1);
        queryWrapper.eq(SysGroup::getName, (Object)group.getName());
        if (StrUtil.isBlank((CharSequence)group.getId())) {
            int icount = this.sysGroupService.count((Wrapper)queryWrapper);
            if (icount > 0) {
                throw new BizException("\u5206\u7ec4\u540d\u79f0: \u3010" + group.getName() + "\u3011 \u5df2\u5b58\u5728");
            }
            this.sysGroupService.wrapperEntity(group);
            this.sysGroupService.save(group);
        } else {
            queryWrapper.ne(SysGroup::getId, (Object)group.getId());
            int icount = this.sysGroupService.count((Wrapper)queryWrapper);
            if (icount > 0) {
                throw new BizException("\u5206\u7ec4\u540d\u79f0: \u3010" + group.getName() + "\u3011 \u5df2\u5b58\u5728");
            }
            this.sysGroupService.updateById(group);
        }
    }

    @Override
    public void saveRoleSystem(String systemId, List<String> roleIds, List<String> menuIds) {
        ArrayList<String> systemIds = new ArrayList<String>();
        systemIds.add(systemId);
        List<SysRole> sysRoles = this.sysRoleSystemService.systemRelateRoles(systemId);
        for (String roleId : roleIds) {
            if (sysRoles.stream().filter(f -> f.getId().equals(roleId)).count() > 0L) continue;
            this.sysRoleSystemService.saveRoleSystems(roleId, systemIds, false);
            this.sysRoleMenuService.saveRoleMenus(roleId, systemId, menuIds);
        }
        for (SysRole sysRole : sysRoles) {
            if (roleIds.contains(sysRole.getId())) continue;
            this.sysRoleSystemService.removeRoleSystem(sysRole.getId(), systemId);
        }
    }

    @Override
    public void deleteGroup(String groupId) throws Exception {
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(SysSystem::getGroupid, (Object)groupId);
        int icount = this.count((Wrapper)queryWrapper);
        if (icount > 0) {
            throw new Exception("\u5e94\u7528\u5206\u7ec4\u4e0b\u6709\u5173\u8054\u7cfb\u7edf\uff0c\u4e0d\u80fd\u5220\u9664");
        }
        this.sysGroupService.removeById((Serializable)((Object)groupId));
    }

    @Override
    public List<AppMenuDTO> queryAppMenus(String key) throws Exception {
        SysSystem system = this.querySystemByKey(key);
        if (system == null) {
            throw new Exception("\u7cfb\u7edf\u4e0d\u5b58\u5728");
        }
        String systemId = system.getId();
        List<SysMenu> menus = this.menuService.queryUserMenusList(systemId, 0);
        List<AppMenuDTO> appMenuTress = this.convertToAppMenuTree(systemId, menus);
        return appMenuTress;
    }

    @Override
    public SysSystem querySystemByKey(String key) {
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(SysSystem::getKey, (Object)key);
        queryWrapper.last(" limit 1");
        SysSystem sysSystem = (SysSystem)this.getOne((Wrapper)queryWrapper);
        SysSystemUtil.wrapper(Collections.singletonList(sysSystem));
        return sysSystem;
    }

    private List<AppMenuDTO> convertToAppMenuTree(String systemId, List<SysMenu> menus) {
        boolean relPath = true;
        int absPath = 2;
        ArrayList<AppMenuDTO> appMenuDTOS = new ArrayList<AppMenuDTO>();
        for (SysMenu menu : menus) {
            AppMenuDTO appMenuDTO = new AppMenuDTO();
            appMenuDTO.setName(menu.getName());
            appMenuDTO.setId(menu.getId());
            appMenuDTO.setKey(menu.getKey());
            appMenuDTO.setRoutename(menu.getKey());
            appMenuDTO.setPid(menu.getPid());
            appMenuDTO.setSystemId(systemId);
            appMenuDTO.setNoLogin(menu.getNologin());
            int linkType = 0;
            if (menu.getMenuPath() != null) {
                int n = linkType = menu.getMenuPath().getPathType() == 1 ? 0 : 1;
                if (menu.getMenuPath().getPathType() == 1) {
                    appMenuDTO.setPath(menu.getPath());
                } else {
                    appMenuDTO.setPath(menu.getAbsPath());
                }
            }
            appMenuDTO.setLink(linkType);
            int newPage = menu.getOpenMode() == 3 ? 1 : 0;
            appMenuDTO.setNewPage(newPage);
            appMenuDTO.setSort(menu.getSort());
            appMenuDTOS.add(appMenuDTO);
        }
        String rootPid = "0";
        TreeNodeConfig treeNodeConfig = new TreeNodeConfig().setParentIdKey("pid").setWeightKey("sort").setIdKey("id");
        List menuTrees = BaseTreeUtil.listToTree(appMenuDTOS, (TreeNodeConfig)treeNodeConfig, (String)"0");
        return menuTrees;
    }

    @Override
    public MPJLambdaWrapper<SysSystem> buildLambdaWrapper(String filterParam, String sortParam) {
        try {
            if (filterParam == null) {
                filterParam = "";
            }
            if (sortParam == null) {
                sortParam = "";
            }
            MPJQueryMapperUtil qmu = new MPJQueryMapperUtil();
            MPJLambdaWrapper queryWrapper = qmu.queryMapper(filterParam, sortParam, this.getClassT());
            List<SysSystem> bindSystems = this.sysTenantSystemService.queryBindSystems(this.getTenantId());
            if (bindSystems.size() == 0) {
                queryWrapper.and(wrapper -> {
                    MPJLambdaWrapper cfr_ignored_0 = (MPJLambdaWrapper)wrapper.eq(SaasEntity::getTenantid, (Object)this.getTenantId());
                });
            } else {
                queryWrapper.and(wrapper -> {
                    MPJLambdaWrapper cfr_ignored_0 = (MPJLambdaWrapper)((MPJLambdaWrapper)((MPJLambdaWrapper)wrapper.eq(SaasEntity::getTenantid, (Object)this.getTenantId())).or()).in(SysSystem::getId, (Collection)bindSystems.stream().map(g -> g.getId()).collect(Collectors.toList()));
                });
            }
            queryWrapper.selectAll(SysSystem.class);
            queryWrapper.distinct();
            return queryWrapper;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }
}

