/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.jckj.biz.util;

import com.geoway.jckj.base.support.spring.SpringUtils;
import com.geoway.jckj.biz.entity.SysOrganization;
import com.geoway.jckj.biz.entity.SysRole;
import com.geoway.jckj.biz.entity.SysUser;
import com.geoway.jckj.biz.service.dev.unity.IUnityOrganizationService;
import com.geoway.jckj.biz.service.sys.SysRoleService;
import com.geoway.jckj.biz.service.sys.SysUserCatalogService;
import java.util.List;
import java.util.stream.Collectors;

public class SysUserUtil {
    public static void wrapperUsers(List<SysUser> users) {
        SysUserUtil.wrapperUserRolesNames(users);
        SysUserUtil.wrapperUserOrgsNames(users);
        SysUserUtil.wrapperUserCatalogs(users);
    }

    public static void wrapperUserRolesNames(List<SysUser> users) {
        SysRoleService sysRoleService = (SysRoleService)SpringUtils.getBean(SysRoleService.class);
        for (SysUser user : users) {
            if (user == null) continue;
            List<SysRole> roles = sysRoleService.queryUserRoles(user.getId());
            List<String> roleAllNames = roles.stream().map(x -> x.getName()).collect(Collectors.toList());
            user.setRoleNames(roleAllNames);
        }
    }

    public static void wrapperUserOrgsNames(List<SysUser> users) {
        IUnityOrganizationService organizationService = (IUnityOrganizationService)SpringUtils.getBean(IUnityOrganizationService.class);
        for (SysUser user : users) {
            if (user == null) continue;
            List<SysOrganization> organizations = organizationService.queryUserOrgs(user.getId());
            List<String> organizationNames = organizations.stream().map(x -> x.getName()).collect(Collectors.toList());
            user.setOrgNames(organizationNames);
        }
    }

    public static void wrapperUserCatalogs(List<SysUser> users) {
        SysUserCatalogService userCatalogService = (SysUserCatalogService)SpringUtils.getBean(SysUserCatalogService.class);
        for (SysUser user : users) {
            if (user == null) continue;
            user.setCatalog(userCatalogService.getUserCatalog(user.getId()));
        }
    }
}

