package com.geoway.jckj.biz.aspect;

import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.servlet.ServletUtil;
import com.alibaba.fastjson.JSON;
import com.geoway.sso.client.annotation.OpLog;
import com.geoway.jckj.biz.entity.SysOplog;
import com.geoway.jckj.biz.service.sys.SysOplogService;
import com.geoway.sso.client.constant.Oauth2Constant;
import com.geoway.sso.client.rpc.SsoUser;
import com.geoway.sso.client.util.CommonLoginUserUtil;
import lombok.extern.slf4j.Slf4j;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * 接口日志保存切面方法
 */
@Slf4j
@Aspect
@Service
@ConditionalOnExpression("#{T(com.geoway.sso.client.constant.SystemConstant).IS_SERVER}")
@SuppressWarnings("all")
public class OpLogAspect {

    @Autowired
    private SysOplogService sysOplogService;



    @Value("${sso.app.id}")
    private String appId;

    /**
     *  配置织入点
     */
    @Pointcut("@annotation(com.geoway.sso.client.annotation.OpLog)")
    public void logPointCut() {
    }

    @Before("logPointCut()")
    public void beforeExec(JoinPoint joinPoint) {
        OpLog opLog = getAnnotationLog(joinPoint);
        if(opLog==null||!opLog.opType().equals(opLog.opType().loginout)){
           return;
        }
        this.doExec(joinPoint,null);
    }


    private void doExec(JoinPoint joinPoint, Object rvt){
        try {
            HttpServletRequest request =
                    ((ServletRequestAttributes) RequestContextHolder.getRequestAttributes()).getRequest();
            OpLog opLog = getAnnotationLog(joinPoint);

            SsoUser sysUser =CommonLoginUserUtil.getUser();// oauth2Service.queryCurrentSsoUser(request);
            if(sysUser == null){
                return;
            }
            String methodName = joinPoint.getSignature().getName();
            String typeName = joinPoint.getSignature().getDeclaringTypeName();
            int begin = typeName.lastIndexOf(".") + 1;


            String methodFullName = typeName.substring(begin) + "." + methodName;
            Map<String,String[]> map = request.getParameterMap();
            Map<String,String> newParamsMap = new LinkedHashMap<>();
            for(String key: map.keySet()){
                String newVal = ArrayUtil.join(map.get(key),",");
                newParamsMap.put(key,newVal);
            }

            String params = JSON.toJSONString(newParamsMap);
            SysOplog sysOplog = new SysOplog();
            sysOplog.setName(opLog.name());
            sysOplog.setDetail(opLog.detail());
            sysOplog.setOptype(opLog.opType().toString());
            sysOplog.setMethod(methodFullName);
            sysOplog.setParam(params);
            sysOplog.setCreatetime(new Date());
            String ip =  ServletUtil.getClientIP(request);
            sysOplog.setMachineName(getMachineName(request));
            sysOplog.setIp(ip);
            sysOplog.setSystemid("1");
            sysOplog.setUserid(sysUser.getId());
            sysOplog.setUsername(sysUser.getUserName());
            String appIdNew = this.appId;
            if(newParamsMap.containsKey(Oauth2Constant.APP_ID)){
                appIdNew = newParamsMap.get(Oauth2Constant.APP_ID);
            }
            sysOplog.setAppid(appId);


            sysOplogService.save(sysOplog);

        } catch (Exception ex) {
            log.error(ex.getMessage());
        }
    }

    @SuppressWarnings("rawtypes")
    @AfterReturning(pointcut = "logPointCut()", returning = "rvt")
    public void afterExec(JoinPoint joinPoint, Object rvt) {
        OpLog opLog = getAnnotationLog(joinPoint);
        if (opLog == null||opLog.opType().equals(opLog.opType().loginout)) {
            return;
        }
        this.doExec(joinPoint,rvt);

    }

    /**
     * 是否存在注解，如果存在就获取
     * @param joinPoint
     * @return
     */
    private OpLog getAnnotationLog(JoinPoint joinPoint) {
        Signature signature = joinPoint.getSignature();
        MethodSignature methodSignature = (MethodSignature) signature;
        Method method = methodSignature.getMethod();
        if (method != null) {
            return method.getAnnotation(OpLog.class);
        }
        return null;
    }

    private String getRemoteHost(HttpServletRequest request) {
        String ip = request.getHeader("x-real-ip");
        if (StrUtil.isBlank(ip) || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("x-forwarded-for");
        }
        if (StrUtil.isBlank(ip) || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (StrUtil.isBlank(ip) || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (StrUtil.isBlank(ip) || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        return ip.equals("0:0:0:0:0:0:0:1") ? "127.0.0.1" : ip;
    }

    private String getMachineName(HttpServletRequest request) {
        try {
            InetAddress inetAddress = InetAddress.getLocalHost(); // 获取本地IP地址
            return inetAddress.getHostName();
        }catch (Exception e){
            return "Administrator";
        }
    }
}
