package com.geoway.jckj.biz.service.dev.unity.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.geoway.jckj.biz.entity.SysOrganization;
import com.geoway.jckj.biz.entity.SysUser;
import com.geoway.jckj.biz.service.dev.base.IOrganizationService;
import com.geoway.jckj.biz.service.dev.unity.IUnityOrganizationService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author 连世忠
 * @ClassName UnityOrganizationServiceImpl
 * @Description TODO
 * @date 2025/4/30 16:19
 * @Version 1.0
 */
@Service
@Slf4j
public class UnityOrganizationServiceImpl extends  UnityBaseImpl<IOrganizationService>  implements IUnityOrganizationService {

    @Override
    public void saveOrUp(SysOrganization org) throws Exception {
        getService().saveOrUp(org);
    }

    @Override
    public void batchSave(List<SysOrganization> orgs) throws Exception {
        getService().batchSave(orgs);
    }

    @Override
    public List<SysOrganization> queryTree(String filterParam, boolean bindUser) throws Exception {
        return getService().queryTree(filterParam,bindUser);
    }

    @Override
    public List<SysOrganization> queryTreeNoUser(String filterParam) throws Exception {
        return getService().queryTreeNoUser(filterParam);
    }

    @Override
    public List<SysOrganization> queryList(String filterParam) throws Exception {
        return getService().queryList(filterParam);
    }

    @Override
    public List<SysOrganization> queryListById(String id) throws Exception {
        return getService().queryListById(id);
    }

    @Override
    public List<SysOrganization> queryAllParentOrg(String id) {
        return getService().queryAllParentOrg(id);
    }

    @Override
    public List<SysOrganization> queryAllChildOrg(String id) {
        return getService().queryAllChildOrg(id);
    }

    @Override
    public IPage<SysOrganization> queryPage(String filterParam, int page, int size) throws Exception {
        return getService().queryPage(filterParam,page,size);
    }

    @Override
    public SysOrganization findOneById(String id, String filterParam) throws Exception {
        return getService().findOneById(id,filterParam);
    }

    @Override
    public SysOrganization findOneByName(String name, String filterParam) throws Exception {
        return getService().findOneByName(name,filterParam);
    }

    @Override
    public void batchDelete(String ids) throws Exception {
        getService().batchDelete(ids);
    }

    @Override
    public void bindUsers(String orgId, String userIds) {
        getService().bindUsers(orgId,userIds);
    }

    @Override
    public void bindOneUser(String orgId, String userId) {
        getService().bindOneUser(orgId,userId);
    }

    @Override
    public void removeBindUser(String orgId, String userIds) {
        getService().removeBindUser(orgId,userIds);
    }

    @Override
    public List<SysUser> queryRelUsers(String orgId) {
        return getService().queryRelUsers(orgId);
    }

    @Override
    public IPage<SysUser> queryAllRelUsers(String orgId, String filterParam, String sortParam, int page, int size) throws Exception {
        return getService().queryAllRelUsers(orgId,filterParam,sortParam,page,size);
    }

    @Override
    public IPage<SysUser> queryOrgUsers(String orgId, String noOrgId, String noRoleId, String filterParam, String sortParam, int page, int size) throws Exception {
        return getService().queryOrgUsers(orgId,noOrgId,noRoleId,filterParam,sortParam,page,size);
    }

    @Override
    public IPage<SysUser> queryAllRelUsers(String orgId, String noOrgId, String noRoleId, String filterParam, String sortParam, int page, int size) throws Exception {
        return getService().queryAllRelUsers(orgId,noOrgId,noRoleId,filterParam,sortParam,page,size);
    }

    @Override
    public List<SysUser> queryNonOrgUsers() {
        return getService().queryNonOrgUsers();
    }

    @Override
    public int queryCount(String filterParam) throws Exception {
        return getService().queryCount(filterParam);
    }

    @Override
    public List<SysOrganization> queryUserOrgs(String userId) {
        return getService().queryUserOrgs(userId);
    }

    @Override
    public void bindUsersToOrg(List<SysOrganization> list) {
        getService().bindUsersToOrg(list);
    }

    @Override
    public List<SysOrganization> constructTree(List<SysOrganization> list) {
        return getService().constructTree(list);
    }
}
