package com.geoway.jckj.biz.service.dev.unity.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.geoway.jckj.biz.entity.SysUser;
import com.geoway.jckj.biz.service.dev.unity.IUnityUserService;
import com.geoway.jckj.biz.service.dev.base.IUserService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * @author 连世忠
 * @ClassName UnityUserServiceImpl
 * @Description TODO
 * @date 2025/4/29 11:27
 * @Version 1.0
 */
@Service
@Slf4j
public class UnityUserServiceImpl extends UnityBaseImpl<IUserService> implements IUnityUserService {



    @Override
    public void saveOrUp(SysUser user, MultipartFile photo, boolean deletePhoto) {
        getService().saveOrUp(user,photo,deletePhoto);
    }

    @Override
    public void batchSave(List<SysUser> users) {
        getService().batchSave(users);
    }

    @Override
    public SysUser query(String userId) {
        return getService().query(userId);
    }

    @Override
    public List<SysUser> query(List<String> userIds) {
        return getService().query(userIds);
    }

    @Override
    public List<SysUser> queryList(String filterParam) {
        return getService().queryList(filterParam);
    }

    @Override
    public List<SysUser> queryList(String filterParam, boolean withRoleOrg) {
        return getService().queryList(filterParam,withRoleOrg);
    }

    @Override
    public int queryCount(String filterParam) {
        return getService().queryCount(filterParam);
    }

    @Override
    public IPage<SysUser> queryPage(String filterParam, int page, int size) {
        return getService().queryPage(filterParam,page,size);
    }

    @Override
    public IPage<SysUser> queryPage(String filterParam, int page, int size, boolean containAdmin) {
        return getService().queryPage(filterParam,page,size,containAdmin);
    }

    @Override
    public void delete(String id) {
        getService().delete(id);
    }

    @Override
    public void batchDelete(String ids) {
        getService().batchDelete(ids);
    }

    @Override
    public void changePassword(String userId, String oldPwd, String newPwd) {
        getService().changePassword(userId,oldPwd,newPwd);
    }

    @Override
    public void changePassword(String userId, String password) {
        getService().changePassword(userId,password);
    }

    @Override
    public String resetPassword(String userId) {
        return getService().resetPassword(userId);
    }

    @Override
    public boolean checkIsResetPassword(String userId) {
        return getService().checkIsResetPassword(userId);
    }

    @Override
    public void exportUsers(String filterParam, Boolean isTemplate, HttpServletResponse response) {
        getService().exportUsers(filterParam,isTemplate,response);
    }

    @Override
    public String importUsers(List<SysUser> userList, Boolean isUpdateSupport, String orgId) {
        return getService().importUsers(userList,isUpdateSupport,orgId);
    }

    @Override
    public Boolean changePassword(String phoneNum, String verifyCode, String verifyCodeUid, String password) throws Exception {
        return getService().changePassword(phoneNum,verifyCode,verifyCodeUid,password);
    }


}
